// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> InboundEndpointProtocol enums. </summary>
    public readonly partial struct InboundEndpointProtocol : IEquatable<InboundEndpointProtocol>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="InboundEndpointProtocol"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public InboundEndpointProtocol(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TcpValue = "tcp";
        private const string UdpValue = "udp";

        /// <summary> Use TCP for the endpoint. </summary>
        public static InboundEndpointProtocol Tcp { get; } = new InboundEndpointProtocol(TcpValue);
        /// <summary> Use UDP for the endpoint. </summary>
        public static InboundEndpointProtocol Udp { get; } = new InboundEndpointProtocol(UdpValue);
        /// <summary> Determines if two <see cref="InboundEndpointProtocol"/> values are the same. </summary>
        public static bool operator ==(InboundEndpointProtocol left, InboundEndpointProtocol right) => left.Equals(right);
        /// <summary> Determines if two <see cref="InboundEndpointProtocol"/> values are not the same. </summary>
        public static bool operator !=(InboundEndpointProtocol left, InboundEndpointProtocol right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="InboundEndpointProtocol"/>. </summary>
        public static implicit operator InboundEndpointProtocol(string value) => new InboundEndpointProtocol(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is InboundEndpointProtocol other && Equals(other);
        /// <inheritdoc />
        public bool Equals(InboundEndpointProtocol other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
