// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Specifies how the Batch service should respond when the Task completes. </summary>
    public partial class ExitConditions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ExitConditions"/>. </summary>
        public ExitConditions()
        {
            ExitCodes = new ChangeTrackingList<ExitCodeMapping>();
            ExitCodeRanges = new ChangeTrackingList<ExitCodeRangeMapping>();
        }

        /// <summary> Initializes a new instance of <see cref="ExitConditions"/>. </summary>
        /// <param name="exitCodes"> A list of individual Task exit codes and how the Batch service should respond to them. </param>
        /// <param name="exitCodeRanges"> A list of Task exit code ranges and how the Batch service should respond to them. </param>
        /// <param name="preProcessingError"> How the Batch service should respond if the Task fails to start due to an error. </param>
        /// <param name="fileUploadError"> How the Batch service should respond if a file upload error occurs. If the Task exited with an exit code that was specified via exitCodes or exitCodeRanges, and then encountered a file upload error, then the action specified by the exit code takes precedence. </param>
        /// <param name="default"> How the Batch service should respond if the Task fails with an exit condition not covered by any of the other properties. This value is used if the Task exits with any nonzero exit code not listed in the exitCodes or exitCodeRanges collection, with a pre-processing error if the preProcessingError property is not present, or with a file upload error if the fileUploadError property is not present. If you want non-default behavior on exit code 0, you must list it explicitly using the exitCodes or exitCodeRanges collection. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ExitConditions(IList<ExitCodeMapping> exitCodes, IList<ExitCodeRangeMapping> exitCodeRanges, ExitOptions preProcessingError, ExitOptions fileUploadError, ExitOptions @default, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExitCodes = exitCodes;
            ExitCodeRanges = exitCodeRanges;
            PreProcessingError = preProcessingError;
            FileUploadError = fileUploadError;
            Default = @default;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of individual Task exit codes and how the Batch service should respond to them. </summary>
        public IList<ExitCodeMapping> ExitCodes { get; }
        /// <summary> A list of Task exit code ranges and how the Batch service should respond to them. </summary>
        public IList<ExitCodeRangeMapping> ExitCodeRanges { get; }
        /// <summary> How the Batch service should respond if the Task fails to start due to an error. </summary>
        public ExitOptions PreProcessingError { get; set; }
        /// <summary> How the Batch service should respond if a file upload error occurs. If the Task exited with an exit code that was specified via exitCodes or exitCodeRanges, and then encountered a file upload error, then the action specified by the exit code takes precedence. </summary>
        public ExitOptions FileUploadError { get; set; }
        /// <summary> How the Batch service should respond if the Task fails with an exit condition not covered by any of the other properties. This value is used if the Task exits with any nonzero exit code not listed in the exitCodes or exitCodeRanges collection, with a pre-processing error if the preProcessingError property is not present, or with a file upload error if the fileUploadError property is not present. If you want non-default behavior on exit code 0, you must list it explicitly using the exitCodes or exitCodeRanges collection. </summary>
        public ExitOptions Default { get; set; }
    }
}
