// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class ExitConditions : IUtf8JsonSerializable, IJsonModel<ExitConditions>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ExitConditions>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ExitConditions>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExitConditions>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExitConditions)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(ExitCodes))
            {
                writer.WritePropertyName("exitCodes"u8);
                writer.WriteStartArray();
                foreach (var item in ExitCodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ExitCodeRanges))
            {
                writer.WritePropertyName("exitCodeRanges"u8);
                writer.WriteStartArray();
                foreach (var item in ExitCodeRanges)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(PreProcessingError))
            {
                writer.WritePropertyName("preProcessingError"u8);
                writer.WriteObjectValue(PreProcessingError, options);
            }
            if (Optional.IsDefined(FileUploadError))
            {
                writer.WritePropertyName("fileUploadError"u8);
                writer.WriteObjectValue(FileUploadError, options);
            }
            if (Optional.IsDefined(Default))
            {
                writer.WritePropertyName("default"u8);
                writer.WriteObjectValue(Default, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ExitConditions IJsonModel<ExitConditions>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExitConditions>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ExitConditions)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeExitConditions(document.RootElement, options);
        }

        internal static ExitConditions DeserializeExitConditions(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<ExitCodeMapping> exitCodes = default;
            IList<ExitCodeRangeMapping> exitCodeRanges = default;
            ExitOptions preProcessingError = default;
            ExitOptions fileUploadError = default;
            ExitOptions @default = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("exitCodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ExitCodeMapping> array = new List<ExitCodeMapping>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ExitCodeMapping.DeserializeExitCodeMapping(item, options));
                    }
                    exitCodes = array;
                    continue;
                }
                if (property.NameEquals("exitCodeRanges"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ExitCodeRangeMapping> array = new List<ExitCodeRangeMapping>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ExitCodeRangeMapping.DeserializeExitCodeRangeMapping(item, options));
                    }
                    exitCodeRanges = array;
                    continue;
                }
                if (property.NameEquals("preProcessingError"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    preProcessingError = ExitOptions.DeserializeExitOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("fileUploadError"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fileUploadError = ExitOptions.DeserializeExitOptions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("default"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    @default = ExitOptions.DeserializeExitOptions(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ExitConditions(
                exitCodes ?? new ChangeTrackingList<ExitCodeMapping>(),
                exitCodeRanges ?? new ChangeTrackingList<ExitCodeRangeMapping>(),
                preProcessingError,
                fileUploadError,
                @default,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ExitConditions>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExitConditions>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ExitConditions)} does not support writing '{options.Format}' format.");
            }
        }

        ExitConditions IPersistableModel<ExitConditions>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ExitConditions>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeExitConditions(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ExitConditions)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ExitConditions>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ExitConditions FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeExitConditions(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
