// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> ErrorCategory enums. </summary>
    public readonly partial struct ErrorCategory : IEquatable<ErrorCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ErrorCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ErrorCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserErrorValue = "usererror";
        private const string ServerErrorValue = "servererror";

        /// <summary> The error is due to a user issue, such as misconfiguration. </summary>
        public static ErrorCategory UserError { get; } = new ErrorCategory(UserErrorValue);
        /// <summary> The error is due to an internal server issue. </summary>
        public static ErrorCategory ServerError { get; } = new ErrorCategory(ServerErrorValue);
        /// <summary> Determines if two <see cref="ErrorCategory"/> values are the same. </summary>
        public static bool operator ==(ErrorCategory left, ErrorCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ErrorCategory"/> values are not the same. </summary>
        public static bool operator !=(ErrorCategory left, ErrorCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ErrorCategory"/>. </summary>
        public static implicit operator ErrorCategory(string value) => new ErrorCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ErrorCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ErrorCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
