// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> ElevationLevel enums. </summary>
    public readonly partial struct ElevationLevel : IEquatable<ElevationLevel>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ElevationLevel"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ElevationLevel(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NonAdminValue = "nonadmin";
        private const string AdminValue = "admin";

        /// <summary> The user is a standard user without elevated access. </summary>
        public static ElevationLevel NonAdmin { get; } = new ElevationLevel(NonAdminValue);
        /// <summary> The user is a user with elevated access and operates with full Administrator permissions. </summary>
        public static ElevationLevel Admin { get; } = new ElevationLevel(AdminValue);
        /// <summary> Determines if two <see cref="ElevationLevel"/> values are the same. </summary>
        public static bool operator ==(ElevationLevel left, ElevationLevel right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ElevationLevel"/> values are not the same. </summary>
        public static bool operator !=(ElevationLevel left, ElevationLevel right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ElevationLevel"/>. </summary>
        public static implicit operator ElevationLevel(string value) => new ElevationLevel(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ElevationLevel other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ElevationLevel other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
