// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> DynamicVNetAssignmentScope enums. </summary>
    public readonly partial struct DynamicVNetAssignmentScope : IEquatable<DynamicVNetAssignmentScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynamicVNetAssignmentScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynamicVNetAssignmentScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string JobValue = "job";

        /// <summary> No dynamic VNet assignment is enabled. </summary>
        public static DynamicVNetAssignmentScope None { get; } = new DynamicVNetAssignmentScope(NoneValue);
        /// <summary> Dynamic VNet assignment is done per-job. </summary>
        public static DynamicVNetAssignmentScope Job { get; } = new DynamicVNetAssignmentScope(JobValue);
        /// <summary> Determines if two <see cref="DynamicVNetAssignmentScope"/> values are the same. </summary>
        public static bool operator ==(DynamicVNetAssignmentScope left, DynamicVNetAssignmentScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynamicVNetAssignmentScope"/> values are not the same. </summary>
        public static bool operator !=(DynamicVNetAssignmentScope left, DynamicVNetAssignmentScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynamicVNetAssignmentScope"/>. </summary>
        public static implicit operator DynamicVNetAssignmentScope(string value) => new DynamicVNetAssignmentScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynamicVNetAssignmentScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynamicVNetAssignmentScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
