// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> DiskEncryptionTarget enums. </summary>
    public readonly partial struct DiskEncryptionTarget : IEquatable<DiskEncryptionTarget>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DiskEncryptionTarget"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DiskEncryptionTarget(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OsDiskValue = "osdisk";
        private const string TemporaryDiskValue = "temporarydisk";

        /// <summary> The OS Disk on the compute node is encrypted. </summary>
        public static DiskEncryptionTarget OsDisk { get; } = new DiskEncryptionTarget(OsDiskValue);
        /// <summary> The temporary disk on the compute node is encrypted. On Linux this encryption applies to other partitions (such as those on mounted data disks) when encryption occurs at boot time. </summary>
        public static DiskEncryptionTarget TemporaryDisk { get; } = new DiskEncryptionTarget(TemporaryDiskValue);
        /// <summary> Determines if two <see cref="DiskEncryptionTarget"/> values are the same. </summary>
        public static bool operator ==(DiskEncryptionTarget left, DiskEncryptionTarget right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DiskEncryptionTarget"/> values are not the same. </summary>
        public static bool operator !=(DiskEncryptionTarget left, DiskEncryptionTarget right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DiskEncryptionTarget"/>. </summary>
        public static implicit operator DiskEncryptionTarget(string value) => new DiskEncryptionTarget(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DiskEncryptionTarget other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DiskEncryptionTarget other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
