// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> DisableBatchJobOption enums. </summary>
    public readonly partial struct DisableBatchJobOption : IEquatable<DisableBatchJobOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DisableBatchJobOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DisableBatchJobOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequeueValue = "requeue";
        private const string TerminateValue = "terminate";
        private const string WaitValue = "wait";

        /// <summary> Terminate running Tasks and requeue them. The Tasks will run again when the Job is enabled. </summary>
        public static DisableBatchJobOption Requeue { get; } = new DisableBatchJobOption(RequeueValue);
        /// <summary> Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. </summary>
        public static DisableBatchJobOption Terminate { get; } = new DisableBatchJobOption(TerminateValue);
        /// <summary> Allow currently running Tasks to complete. </summary>
        public static DisableBatchJobOption Wait { get; } = new DisableBatchJobOption(WaitValue);
        /// <summary> Determines if two <see cref="DisableBatchJobOption"/> values are the same. </summary>
        public static bool operator ==(DisableBatchJobOption left, DisableBatchJobOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DisableBatchJobOption"/> values are not the same. </summary>
        public static bool operator !=(DisableBatchJobOption left, DisableBatchJobOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DisableBatchJobOption"/>. </summary>
        public static implicit operator DisableBatchJobOption(string value) => new DisableBatchJobOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DisableBatchJobOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DisableBatchJobOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
