// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> DependencyAction enums. </summary>
    public readonly partial struct DependencyAction : IEquatable<DependencyAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DependencyAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DependencyAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SatisfyValue = "satisfy";
        private const string BlockValue = "block";

        /// <summary> Satisfy tasks waiting on this task; once all dependencies are satisfied, the task will be scheduled to run. </summary>
        public static DependencyAction Satisfy { get; } = new DependencyAction(SatisfyValue);
        /// <summary> Blocks tasks waiting on this task, preventing them from being scheduled. </summary>
        public static DependencyAction Block { get; } = new DependencyAction(BlockValue);
        /// <summary> Determines if two <see cref="DependencyAction"/> values are the same. </summary>
        public static bool operator ==(DependencyAction left, DependencyAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DependencyAction"/> values are not the same. </summary>
        public static bool operator !=(DependencyAction left, DependencyAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DependencyAction"/>. </summary>
        public static implicit operator DependencyAction(string value) => new DependencyAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DependencyAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DependencyAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
