// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// Settings which will be used by the data disks associated to Compute Nodes in
    /// the Pool. When using attached data disks, you need to mount and format the
    /// disks from within a VM to use them.
    /// </summary>
    public partial class DataDisk
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataDisk"/>. </summary>
        /// <param name="logicalUnitNumber"> The logical unit number. The logicalUnitNumber is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct logicalUnitNumber. The value must be between 0 and 63, inclusive. </param>
        /// <param name="diskSizeGb"> The initial disk size in gigabytes. </param>
        public DataDisk(int logicalUnitNumber, int diskSizeGb)
        {
            LogicalUnitNumber = logicalUnitNumber;
            DiskSizeGb = diskSizeGb;
        }

        /// <summary> Initializes a new instance of <see cref="DataDisk"/>. </summary>
        /// <param name="logicalUnitNumber"> The logical unit number. The logicalUnitNumber is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct logicalUnitNumber. The value must be between 0 and 63, inclusive. </param>
        /// <param name="caching"> The type of caching to be enabled for the data disks. The default value for caching is readwrite. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. </param>
        /// <param name="diskSizeGb"> The initial disk size in gigabytes. </param>
        /// <param name="storageAccountType"> The storage Account type to be used for the data disk. If omitted, the default is "standard_lrs". </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataDisk(int logicalUnitNumber, CachingType? caching, int diskSizeGb, StorageAccountType? storageAccountType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LogicalUnitNumber = logicalUnitNumber;
            Caching = caching;
            DiskSizeGb = diskSizeGb;
            StorageAccountType = storageAccountType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataDisk"/> for deserialization. </summary>
        internal DataDisk()
        {
        }

        /// <summary> The logical unit number. The logicalUnitNumber is used to uniquely identify each data disk. If attaching multiple disks, each should have a distinct logicalUnitNumber. The value must be between 0 and 63, inclusive. </summary>
        public int LogicalUnitNumber { get; set; }
        /// <summary> The type of caching to be enabled for the data disks. The default value for caching is readwrite. For information about the caching options see: https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/. </summary>
        public CachingType? Caching { get; set; }
        /// <summary> The initial disk size in gigabytes. </summary>
        public int DiskSizeGb { get; set; }
        /// <summary> The storage Account type to be used for the data disk. If omitted, the default is "standard_lrs". </summary>
        public StorageAccountType? StorageAccountType { get; set; }
    }
}
