// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> ContainerType enums. </summary>
    public readonly partial struct ContainerType : IEquatable<ContainerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContainerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContainerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DockerCompatibleValue = "dockerCompatible";
        private const string CriCompatibleValue = "criCompatible";

        /// <summary> A Docker compatible container technology will be used to launch the containers. </summary>
        public static ContainerType DockerCompatible { get; } = new ContainerType(DockerCompatibleValue);
        /// <summary> A CRI based technology will be used to launch the containers. </summary>
        public static ContainerType CriCompatible { get; } = new ContainerType(CriCompatibleValue);
        /// <summary> Determines if two <see cref="ContainerType"/> values are the same. </summary>
        public static bool operator ==(ContainerType left, ContainerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContainerType"/> values are not the same. </summary>
        public static bool operator !=(ContainerType left, ContainerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContainerType"/>. </summary>
        public static implicit operator ContainerType(string value) => new ContainerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContainerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContainerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
