// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The configuration for container-enabled Pools. </summary>
    public partial class ContainerConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContainerConfiguration"/>. </summary>
        /// <param name="type"> The container technology to be used. </param>
        public ContainerConfiguration(ContainerType type)
        {
            Type = type;
            ContainerImageNames = new ChangeTrackingList<string>();
            ContainerRegistries = new ChangeTrackingList<ContainerRegistryReference>();
        }

        /// <summary> Initializes a new instance of <see cref="ContainerConfiguration"/>. </summary>
        /// <param name="type"> The container technology to be used. </param>
        /// <param name="containerImageNames"> The collection of container Image names. This is the full Image reference, as would be specified to "docker pull". An Image will be sourced from the default Docker registry unless the Image is fully qualified with an alternative registry. </param>
        /// <param name="containerRegistries"> Additional private registries from which containers can be pulled. If any Images must be downloaded from a private registry which requires credentials, then those credentials must be provided here. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContainerConfiguration(ContainerType type, IList<string> containerImageNames, IList<ContainerRegistryReference> containerRegistries, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            ContainerImageNames = containerImageNames;
            ContainerRegistries = containerRegistries;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ContainerConfiguration"/> for deserialization. </summary>
        internal ContainerConfiguration()
        {
        }

        /// <summary> The container technology to be used. </summary>
        public ContainerType Type { get; set; }
        /// <summary> The collection of container Image names. This is the full Image reference, as would be specified to "docker pull". An Image will be sourced from the default Docker registry unless the Image is fully qualified with an alternative registry. </summary>
        public IList<string> ContainerImageNames { get; }
        /// <summary> Additional private registries from which containers can be pulled. If any Images must be downloaded from a private registry which requires credentials, then those credentials must be provided here. </summary>
        public IList<ContainerRegistryReference> ContainerRegistries { get; }
    }
}
