// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Compute.Batch
{
    /// <summary> Model factory for models. </summary>
    public static partial class ComputeBatchModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Batch.BatchApplication"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the application within the Account. </param>
        /// <param name="displayName"> The display name for the application. </param>
        /// <param name="versions"> The list of available versions of the application. </param>
        /// <returns> A new <see cref="Batch.BatchApplication"/> instance for mocking. </returns>
        public static BatchApplication BatchApplication(string id = null, string displayName = null, IEnumerable<string> versions = null)
        {
            versions ??= new List<string>();

            return new BatchApplication(id, displayName, versions?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchError"/>. </summary>
        /// <param name="code"> An identifier for the error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the error, intended to be suitable for display in a user interface. </param>
        /// <param name="values"> A collection of key-value pairs containing additional details about the error. </param>
        /// <returns> A new <see cref="Batch.BatchError"/> instance for mocking. </returns>
        public static BatchError BatchError(string code = null, BatchErrorMessage message = null, IEnumerable<BatchErrorDetail> values = null)
        {
            values ??= new List<BatchErrorDetail>();

            return new BatchError(code, message, values?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchErrorMessage"/>. </summary>
        /// <param name="lang"> The language code of the error message. </param>
        /// <param name="value"> The text of the message. </param>
        /// <returns> A new <see cref="Batch.BatchErrorMessage"/> instance for mocking. </returns>
        public static BatchErrorMessage BatchErrorMessage(string lang = null, string value = null)
        {
            return new BatchErrorMessage(lang, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchErrorDetail"/>. </summary>
        /// <param name="key"> An identifier specifying the meaning of the Value property. </param>
        /// <param name="value"> The additional information included with the error response. </param>
        /// <returns> A new <see cref="Batch.BatchErrorDetail"/> instance for mocking. </returns>
        public static BatchErrorDetail BatchErrorDetail(string key = null, string value = null)
        {
            return new BatchErrorDetail(key, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolUsageMetrics"/>. </summary>
        /// <param name="poolId"> The ID of the Pool whose metrics are aggregated in this entry. </param>
        /// <param name="startTime"> The start time of the aggregation interval covered by this entry. </param>
        /// <param name="endTime"> The end time of the aggregation interval covered by this entry. </param>
        /// <param name="vmSize"> The size of virtual machines in the Pool. All VMs in a Pool are the same size. For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes). </param>
        /// <param name="totalCoreHours"> The total core hours used in the Pool during this aggregation interval. </param>
        /// <returns> A new <see cref="Batch.BatchPoolUsageMetrics"/> instance for mocking. </returns>
        public static BatchPoolUsageMetrics BatchPoolUsageMetrics(string poolId = null, DateTimeOffset startTime = default, DateTimeOffset endTime = default, string vmSize = null, float totalCoreHours = default)
        {
            return new BatchPoolUsageMetrics(
                poolId,
                startTime,
                endTime,
                vmSize,
                totalCoreHours,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolCreateContent"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Pool within the Account. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two Pool IDs within an Account that differ only by case). </param>
        /// <param name="displayName"> The display name for the Pool. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="vmSize"> The size of virtual machines in the Pool. All virtual machines in a Pool are the same size. For information about available VM sizes for Pools using Images from the Virtual Machines Marketplace (pools created with virtualMachineConfiguration), see Sizes for Virtual Machines (Linux) (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/) or Sizes for Virtual Machines (Windows) (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/). Batch supports all Azure VM sizes except STANDARD_A0 and those with premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series). </param>
        /// <param name="virtualMachineConfiguration"> The virtual machine configuration for the Pool. This property must be specified. </param>
        /// <param name="resizeTimeout"> The timeout for allocation of Compute Nodes to the Pool. This timeout applies only to manual scaling; it has no effect when enableAutoScale is set to true. The default value is 15 minutes. The minimum value is 5 minutes. If you specify a value less than 5 minutes, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). </param>
        /// <param name="resourceTags"> The user-specified tags associated with the pool. The user-defined tags to be associated with the Azure Batch Pool. When specified, these tags are propagated to the backing Azure resources associated with the pool. This property can only be specified when the Batch account was created with the poolAllocationMode property set to 'UserSubscription'. </param>
        /// <param name="targetDedicatedNodes"> The desired number of dedicated Compute Nodes in the Pool. This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both. </param>
        /// <param name="targetLowPriorityNodes"> The desired number of Spot/Low-priority Compute Nodes in the Pool. This property must not be specified if enableAutoScale is set to true. If enableAutoScale is set to false, then you must set either targetDedicatedNodes, targetLowPriorityNodes, or both. </param>
        /// <param name="enableAutoScale"> Whether the Pool size should automatically adjust over time. If false, at least one of targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the Pool automatically resizes according to the formula. The default value is false. </param>
        /// <param name="autoScaleFormula"> A formula for the desired number of Compute Nodes in the Pool. This property must not be specified if enableAutoScale is set to false. It is required if enableAutoScale is set to true. The formula is checked for validity before the Pool is created. If the formula is not valid, the Batch service rejects the request with detailed error information. For more information about specifying this formula, see 'Automatically scale Compute Nodes in an Azure Batch Pool' (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/). </param>
        /// <param name="autoScaleEvaluationInterval"> The time interval at which to automatically adjust the Pool size according to the autoscale formula. The default value is 15 minutes. The minimum and maximum value are 5 minutes and 168 hours respectively. If you specify a value less than 5 minutes or greater than 168 hours, the Batch service returns an error; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). </param>
        /// <param name="enableInterNodeCommunication"> Whether the Pool permits direct communication between Compute Nodes. Enabling inter-node communication limits the maximum size of the Pool due to deployment restrictions on the Compute Nodes of the Pool. This may result in the Pool not reaching its desired size. The default value is false. </param>
        /// <param name="networkConfiguration"> The network configuration for the Pool. </param>
        /// <param name="startTask"> A Task specified to run on each Compute Node as it joins the Pool. The Task runs when the Compute Node is added to the Pool or when the Compute Node is restarted. </param>
        /// <param name="applicationPackageReferences"> The list of Packages to be installed on each Compute Node in the Pool. When creating a pool, the package's application ID must be fully qualified (/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationName}). Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package references on any given Pool. </param>
        /// <param name="taskSlotsPerNode"> The number of task slots that can be used to run concurrent tasks on a single compute node in the pool. The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256. </param>
        /// <param name="taskSchedulingPolicy"> How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is spread. </param>
        /// <param name="userAccounts"> The list of user Accounts to be created on each Compute Node in the Pool. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the Pool as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <param name="mountConfiguration"> Mount storage using specified file system for the entire lifetime of the pool. Mount the storage using Azure fileshare, NFS, CIFS or Blobfuse based file system. </param>
        /// <param name="targetNodeCommunicationMode"> The desired node communication mode for the pool. If omitted, the default value is Default. </param>
        /// <param name="upgradePolicy"> The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or rolling. </param>
        /// <returns> A new <see cref="Batch.BatchPoolCreateContent"/> instance for mocking. </returns>
        public static BatchPoolCreateContent BatchPoolCreateContent(string id = null, string displayName = null, string vmSize = null, VirtualMachineConfiguration virtualMachineConfiguration = null, TimeSpan? resizeTimeout = null, IDictionary<string, string> resourceTags = null, int? targetDedicatedNodes = null, int? targetLowPriorityNodes = null, bool? enableAutoScale = null, string autoScaleFormula = null, TimeSpan? autoScaleEvaluationInterval = null, bool? enableInterNodeCommunication = null, NetworkConfiguration networkConfiguration = null, BatchStartTask startTask = null, IEnumerable<BatchApplicationPackageReference> applicationPackageReferences = null, int? taskSlotsPerNode = null, BatchTaskSchedulingPolicy taskSchedulingPolicy = null, IEnumerable<UserAccount> userAccounts = null, IEnumerable<MetadataItem> metadata = null, IEnumerable<MountConfiguration> mountConfiguration = null, BatchNodeCommunicationMode? targetNodeCommunicationMode = null, UpgradePolicy upgradePolicy = null)
        {
            resourceTags ??= new Dictionary<string, string>();
            applicationPackageReferences ??= new List<BatchApplicationPackageReference>();
            userAccounts ??= new List<UserAccount>();
            metadata ??= new List<MetadataItem>();
            mountConfiguration ??= new List<MountConfiguration>();

            return new BatchPoolCreateContent(
                id,
                displayName,
                vmSize,
                virtualMachineConfiguration,
                resizeTimeout,
                resourceTags,
                targetDedicatedNodes,
                targetLowPriorityNodes,
                enableAutoScale,
                autoScaleFormula,
                autoScaleEvaluationInterval,
                enableInterNodeCommunication,
                networkConfiguration,
                startTask,
                applicationPackageReferences?.ToList(),
                taskSlotsPerNode,
                taskSchedulingPolicy,
                userAccounts?.ToList(),
                metadata?.ToList(),
                mountConfiguration?.ToList(),
                targetNodeCommunicationMode,
                upgradePolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.ImageReference"/>. </summary>
        /// <param name="publisher"> The publisher of the Azure Virtual Machines Marketplace Image. For example, Canonical or MicrosoftWindowsServer. </param>
        /// <param name="offer"> The offer type of the Azure Virtual Machines Marketplace Image. For example, UbuntuServer or WindowsServer. </param>
        /// <param name="sku"> The SKU of the Azure Virtual Machines Marketplace Image. For example, 18.04-LTS or 2019-Datacenter. </param>
        /// <param name="version"> The version of the Azure Virtual Machines Marketplace Image. A value of 'latest' can be specified to select the latest version of an Image. If omitted, the default is 'latest'. </param>
        /// <param name="virtualMachineImageId"> The ARM resource identifier of the Azure Compute Gallery Image. Compute Nodes in the Pool will be created using this Image Id. This is of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName}/versions/{VersionId} or /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/galleries/{galleryName}/images/{imageDefinitionName} for always defaulting to the latest image version. This property is mutually exclusive with other ImageReference properties. The Azure Compute Gallery Image must have replicas in the same region and must be in the same subscription as the Azure Batch account. If the image version is not specified in the imageId, the latest version will be used. For information about the firewall settings for the Batch Compute Node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration. </param>
        /// <param name="exactVersion"> The specific version of the platform image or marketplace image used to create the node. This read-only field differs from 'version' only if the value specified for 'version' when the pool was created was 'latest'. </param>
        /// <returns> A new <see cref="Batch.ImageReference"/> instance for mocking. </returns>
        public static ImageReference ImageReference(string publisher = null, string offer = null, string sku = null, string version = null, string virtualMachineImageId = null, string exactVersion = null)
        {
            return new ImageReference(
                publisher,
                offer,
                sku,
                version,
                virtualMachineImageId,
                exactVersion,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPool"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Pool within the Account. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case). </param>
        /// <param name="displayName"> The display name for the Pool. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="url"> The URL of the Pool. </param>
        /// <param name="eTag"> The ETag of the Pool. This is an opaque string. You can use it to detect whether the Pool has changed between requests. In particular, you can be pass the ETag when updating a Pool to specify that your changes should take effect only if nobody else has modified the Pool in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Pool. This is the last time at which the Pool level data, such as the targetDedicatedNodes or enableAutoscale settings, changed. It does not factor in node-level changes such as a Compute Node changing state. </param>
        /// <param name="creationTime"> The creation time of the Pool. </param>
        /// <param name="state"> The current state of the Pool. </param>
        /// <param name="stateTransitionTime"> The time at which the Pool entered its current state. </param>
        /// <param name="allocationState"> Whether the Pool is resizing. </param>
        /// <param name="allocationStateTransitionTime"> The time at which the Pool entered its current allocation state. </param>
        /// <param name="vmSize"> The size of virtual machines in the Pool. All virtual machines in a Pool are the same size. For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes). </param>
        /// <param name="virtualMachineConfiguration"> The virtual machine configuration for the Pool. This property must be specified. </param>
        /// <param name="resizeTimeout"> The timeout for allocation of Compute Nodes to the Pool. This is the timeout for the most recent resize operation. (The initial sizing when the Pool is created counts as a resize.) The default value is 15 minutes. </param>
        /// <param name="resizeErrors"> A list of errors encountered while performing the last resize on the Pool. This property is set only if one or more errors occurred during the last Pool resize, and only when the Pool allocationState is Steady. </param>
        /// <param name="resourceTags"> The user-specified tags associated with the pool. The user-defined tags to be associated with the Azure Batch Pool. When specified, these tags are propagated to the backing Azure resources associated with the pool. This property can only be specified when the Batch account was created with the poolAllocationMode property set to 'UserSubscription'. </param>
        /// <param name="currentDedicatedNodes"> The number of dedicated Compute Nodes currently in the Pool. </param>
        /// <param name="currentLowPriorityNodes"> The number of Spot/Low-priority Compute Nodes currently in the Pool. Spot/Low-priority Compute Nodes which have been preempted are included in this count. </param>
        /// <param name="targetDedicatedNodes"> The desired number of dedicated Compute Nodes in the Pool. </param>
        /// <param name="targetLowPriorityNodes"> The desired number of Spot/Low-priority Compute Nodes in the Pool. </param>
        /// <param name="enableAutoScale"> Whether the Pool size should automatically adjust over time. If false, at least one of targetDedicatedNodes and targetLowPriorityNodes must be specified. If true, the autoScaleFormula property is required and the Pool automatically resizes according to the formula. The default value is false. </param>
        /// <param name="autoScaleFormula"> A formula for the desired number of Compute Nodes in the Pool. This property is set only if the Pool automatically scales, i.e. enableAutoScale is true. </param>
        /// <param name="autoScaleEvaluationInterval"> The time interval at which to automatically adjust the Pool size according to the autoscale formula. This property is set only if the Pool automatically scales, i.e. enableAutoScale is true. </param>
        /// <param name="autoScaleRun"> The results and errors from the last execution of the autoscale formula. This property is set only if the Pool automatically scales, i.e. enableAutoScale is true. </param>
        /// <param name="enableInterNodeCommunication"> Whether the Pool permits direct communication between Compute Nodes. This imposes restrictions on which Compute Nodes can be assigned to the Pool. Specifying this value can reduce the chance of the requested number of Compute Nodes to be allocated in the Pool. </param>
        /// <param name="networkConfiguration"> The network configuration for the Pool. </param>
        /// <param name="startTask"> A Task specified to run on each Compute Node as it joins the Pool. </param>
        /// <param name="applicationPackageReferences"> The list of Packages to be installed on each Compute Node in the Pool. Changes to Package references affect all new Nodes joining the Pool, but do not affect Compute Nodes that are already in the Pool until they are rebooted or reimaged. There is a maximum of 10 Package references on any given Pool. </param>
        /// <param name="taskSlotsPerNode"> The number of task slots that can be used to run concurrent tasks on a single compute node in the pool. The default value is 1. The maximum value is the smaller of 4 times the number of cores of the vmSize of the pool or 256. </param>
        /// <param name="taskSchedulingPolicy"> How Tasks are distributed across Compute Nodes in a Pool. If not specified, the default is spread. </param>
        /// <param name="userAccounts"> The list of user Accounts to be created on each Compute Node in the Pool. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the Pool as metadata. </param>
        /// <param name="stats"> Utilization and resource usage statistics for the entire lifetime of the Pool. This property is populated only if the CloudPool was retrieved with an expand clause including the 'stats' attribute; otherwise it is null. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes. </param>
        /// <param name="mountConfiguration"> A list of file systems to mount on each node in the pool. This supports Azure Files, NFS, CIFS/SMB, and Blobfuse. </param>
        /// <param name="identity"> The identity of the Batch pool, if configured. The list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'. </param>
        /// <param name="targetNodeCommunicationMode"> The desired node communication mode for the pool. If omitted, the default value is Default. </param>
        /// <param name="currentNodeCommunicationMode"> The current state of the pool communication mode. </param>
        /// <param name="upgradePolicy"> The upgrade policy for the Pool. Describes an upgrade policy - automatic, manual, or rolling. </param>
        /// <returns> A new <see cref="Batch.BatchPool"/> instance for mocking. </returns>
        public static BatchPool BatchPool(string id = null, string displayName = null, string url = null, string eTag = null, DateTimeOffset? lastModified = null, DateTimeOffset? creationTime = null, BatchPoolState? state = null, DateTimeOffset? stateTransitionTime = null, AllocationState? allocationState = null, DateTimeOffset? allocationStateTransitionTime = null, string vmSize = null, VirtualMachineConfiguration virtualMachineConfiguration = null, TimeSpan? resizeTimeout = null, IEnumerable<ResizeError> resizeErrors = null, IReadOnlyDictionary<string, string> resourceTags = null, int? currentDedicatedNodes = null, int? currentLowPriorityNodes = null, int? targetDedicatedNodes = null, int? targetLowPriorityNodes = null, bool? enableAutoScale = null, string autoScaleFormula = null, TimeSpan? autoScaleEvaluationInterval = null, AutoScaleRun autoScaleRun = null, bool? enableInterNodeCommunication = null, NetworkConfiguration networkConfiguration = null, BatchStartTask startTask = null, IEnumerable<BatchApplicationPackageReference> applicationPackageReferences = null, int? taskSlotsPerNode = null, BatchTaskSchedulingPolicy taskSchedulingPolicy = null, IEnumerable<UserAccount> userAccounts = null, IEnumerable<MetadataItem> metadata = null, BatchPoolStatistics stats = null, IEnumerable<MountConfiguration> mountConfiguration = null, BatchPoolIdentity identity = null, BatchNodeCommunicationMode? targetNodeCommunicationMode = null, BatchNodeCommunicationMode? currentNodeCommunicationMode = null, UpgradePolicy upgradePolicy = null)
        {
            resizeErrors ??= new List<ResizeError>();
            resourceTags ??= new Dictionary<string, string>();
            applicationPackageReferences ??= new List<BatchApplicationPackageReference>();
            userAccounts ??= new List<UserAccount>();
            metadata ??= new List<MetadataItem>();
            mountConfiguration ??= new List<MountConfiguration>();

            return new BatchPool(
                id,
                displayName,
                url,
                eTag,
                lastModified,
                creationTime,
                state,
                stateTransitionTime,
                allocationState,
                allocationStateTransitionTime,
                vmSize,
                virtualMachineConfiguration,
                resizeTimeout,
                resizeErrors?.ToList(),
                resourceTags,
                currentDedicatedNodes,
                currentLowPriorityNodes,
                targetDedicatedNodes,
                targetLowPriorityNodes,
                enableAutoScale,
                autoScaleFormula,
                autoScaleEvaluationInterval,
                autoScaleRun,
                enableInterNodeCommunication,
                networkConfiguration,
                startTask,
                applicationPackageReferences?.ToList(),
                taskSlotsPerNode,
                taskSchedulingPolicy,
                userAccounts?.ToList(),
                metadata?.ToList(),
                stats,
                mountConfiguration?.ToList(),
                identity,
                targetNodeCommunicationMode,
                currentNodeCommunicationMode,
                upgradePolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.ResizeError"/>. </summary>
        /// <param name="code"> An identifier for the Pool resize error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the Pool resize error, intended to be suitable for display in a user interface. </param>
        /// <param name="values"> A list of additional error details related to the Pool resize error. </param>
        /// <returns> A new <see cref="Batch.ResizeError"/> instance for mocking. </returns>
        public static ResizeError ResizeError(string code = null, string message = null, IEnumerable<NameValuePair> values = null)
        {
            values ??= new List<NameValuePair>();

            return new ResizeError(code, message, values?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.NameValuePair"/>. </summary>
        /// <param name="name"> The name in the name-value pair. </param>
        /// <param name="value"> The value in the name-value pair. </param>
        /// <returns> A new <see cref="Batch.NameValuePair"/> instance for mocking. </returns>
        public static NameValuePair NameValuePair(string name = null, string value = null)
        {
            return new NameValuePair(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.AutoScaleRun"/>. </summary>
        /// <param name="timestamp"> The time at which the autoscale formula was last evaluated. </param>
        /// <param name="results"> The final values of all variables used in the evaluation of the autoscale formula. Each variable value is returned in the form $variable=value, and variables are separated by semicolons. </param>
        /// <param name="error"> Details of the error encountered evaluating the autoscale formula on the Pool, if the evaluation was unsuccessful. </param>
        /// <returns> A new <see cref="Batch.AutoScaleRun"/> instance for mocking. </returns>
        public static AutoScaleRun AutoScaleRun(DateTimeOffset timestamp = default, string results = null, AutoScaleRunError error = null)
        {
            return new AutoScaleRun(timestamp, results, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.AutoScaleRunError"/>. </summary>
        /// <param name="code"> An identifier for the autoscale error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the autoscale error, intended to be suitable for display in a user interface. </param>
        /// <param name="values"> A list of additional error details related to the autoscale error. </param>
        /// <returns> A new <see cref="Batch.AutoScaleRunError"/> instance for mocking. </returns>
        public static AutoScaleRunError AutoScaleRunError(string code = null, string message = null, IEnumerable<NameValuePair> values = null)
        {
            values ??= new List<NameValuePair>();

            return new AutoScaleRunError(code, message, values?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolStatistics"/>. </summary>
        /// <param name="url"> The URL for the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="usageStats"> Statistics related to Pool usage, such as the amount of core-time used. </param>
        /// <param name="resourceStats"> Statistics related to resource consumption by Compute Nodes in the Pool. </param>
        /// <returns> A new <see cref="Batch.BatchPoolStatistics"/> instance for mocking. </returns>
        public static BatchPoolStatistics BatchPoolStatistics(string url = null, DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, BatchPoolUsageStatistics usageStats = null, BatchPoolResourceStatistics resourceStats = null)
        {
            return new BatchPoolStatistics(
                url,
                startTime,
                lastUpdateTime,
                usageStats,
                resourceStats,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolUsageStatistics"/>. </summary>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="dedicatedCoreTime"> The aggregated wall-clock time of the dedicated Compute Node cores being part of the Pool. </param>
        /// <returns> A new <see cref="Batch.BatchPoolUsageStatistics"/> instance for mocking. </returns>
        public static BatchPoolUsageStatistics BatchPoolUsageStatistics(DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, TimeSpan dedicatedCoreTime = default)
        {
            return new BatchPoolUsageStatistics(startTime, lastUpdateTime, dedicatedCoreTime, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolResourceStatistics"/>. </summary>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="avgCpuPercentage"> The average CPU usage across all Compute Nodes in the Pool (percentage per node). </param>
        /// <param name="avgMemoryGiB"> The average memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakMemoryGiB"> The peak memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="avgDiskGiB"> The average used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakDiskGiB"> The peak used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadIOps"> The total number of disk read operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteIOps"> The total number of disk write operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadGiB"> The total amount of data in GiB of disk reads across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteGiB"> The total amount of data in GiB of disk writes across all Compute Nodes in the Pool. </param>
        /// <param name="networkReadGiB"> The total amount of data in GiB of network reads across all Compute Nodes in the Pool. </param>
        /// <param name="networkWriteGiB"> The total amount of data in GiB of network writes across all Compute Nodes in the Pool. </param>
        /// <returns> A new <see cref="Batch.BatchPoolResourceStatistics"/> instance for mocking. </returns>
        public static BatchPoolResourceStatistics BatchPoolResourceStatistics(DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, float avgCpuPercentage = default, float avgMemoryGiB = default, float peakMemoryGiB = default, float avgDiskGiB = default, float peakDiskGiB = default, long diskReadIOps = default, long diskWriteIOps = default, float diskReadGiB = default, float diskWriteGiB = default, float networkReadGiB = default, float networkWriteGiB = default)
        {
            return new BatchPoolResourceStatistics(
                startTime,
                lastUpdateTime,
                avgCpuPercentage,
                avgMemoryGiB,
                peakMemoryGiB,
                avgDiskGiB,
                peakDiskGiB,
                diskReadIOps,
                diskWriteIOps,
                diskReadGiB,
                diskWriteGiB,
                networkReadGiB,
                networkWriteGiB,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolIdentity"/>. </summary>
        /// <param name="type"> The identity of the Batch pool, if configured. The list of user identities associated with the Batch pool. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'. </param>
        /// <param name="userAssignedIdentities"> The list of user identities associated with the Batch account. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'. </param>
        /// <returns> A new <see cref="Batch.BatchPoolIdentity"/> instance for mocking. </returns>
        public static BatchPoolIdentity BatchPoolIdentity(BatchPoolIdentityType type = default, IEnumerable<UserAssignedIdentity> userAssignedIdentities = null)
        {
            userAssignedIdentities ??= new List<UserAssignedIdentity>();

            return new BatchPoolIdentity(type, userAssignedIdentities?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.UserAssignedIdentity"/>. </summary>
        /// <param name="resourceId"> The ARM resource id of the user assigned identity. </param>
        /// <param name="clientId"> The client id of the user assigned identity. </param>
        /// <param name="principalId"> The principal id of the user assigned identity. </param>
        /// <returns> A new <see cref="Batch.UserAssignedIdentity"/> instance for mocking. </returns>
        public static UserAssignedIdentity UserAssignedIdentity(string resourceId = null, string clientId = null, string principalId = null)
        {
            return new UserAssignedIdentity(resourceId, clientId, principalId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchSupportedImage"/>. </summary>
        /// <param name="nodeAgentSkuId"> The ID of the Compute Node agent SKU which the Image supports. </param>
        /// <param name="imageReference"> The reference to the Azure Virtual Machine's Marketplace Image. </param>
        /// <param name="osType"> The type of operating system (e.g. Windows or Linux) of the Image. </param>
        /// <param name="capabilities"> The capabilities or features which the Image supports. Not every capability of the Image is listed. Capabilities in this list are considered of special interest and are generally related to integration with other features in the Azure Batch service. </param>
        /// <param name="batchSupportEndOfLife"> The time when the Azure Batch service will stop accepting create Pool requests for the Image. </param>
        /// <param name="verificationType"> Whether the Azure Batch service actively verifies that the Image is compatible with the associated Compute Node agent SKU. </param>
        /// <returns> A new <see cref="Batch.BatchSupportedImage"/> instance for mocking. </returns>
        public static BatchSupportedImage BatchSupportedImage(string nodeAgentSkuId = null, ImageReference imageReference = null, OSType osType = default, IEnumerable<string> capabilities = null, DateTimeOffset? batchSupportEndOfLife = null, ImageVerificationType verificationType = default)
        {
            capabilities ??= new List<string>();

            return new BatchSupportedImage(
                nodeAgentSkuId,
                imageReference,
                osType,
                capabilities?.ToList(),
                batchSupportEndOfLife,
                verificationType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchPoolNodeCounts"/>. </summary>
        /// <param name="poolId"> The ID of the Pool. </param>
        /// <param name="dedicated"> The number of dedicated Compute Nodes in each state. </param>
        /// <param name="lowPriority"> The number of Spot/Low-priority Compute Nodes in each state. </param>
        /// <returns> A new <see cref="Batch.BatchPoolNodeCounts"/> instance for mocking. </returns>
        public static BatchPoolNodeCounts BatchPoolNodeCounts(string poolId = null, BatchNodeCounts dedicated = null, BatchNodeCounts lowPriority = null)
        {
            return new BatchPoolNodeCounts(poolId, dedicated, lowPriority, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeCounts"/>. </summary>
        /// <param name="creating"> The number of Compute Nodes in the creating state. </param>
        /// <param name="idle"> The number of Compute Nodes in the idle state. </param>
        /// <param name="offline"> The number of Compute Nodes in the offline state. </param>
        /// <param name="preempted"> The number of Compute Nodes in the preempted state. </param>
        /// <param name="rebooting"> The count of Compute Nodes in the rebooting state. </param>
        /// <param name="reimaging"> The number of Compute Nodes in the reimaging state. </param>
        /// <param name="running"> The number of Compute Nodes in the running state. </param>
        /// <param name="starting"> The number of Compute Nodes in the starting state. </param>
        /// <param name="startTaskFailed"> The number of Compute Nodes in the startTaskFailed state. </param>
        /// <param name="leavingPool"> The number of Compute Nodes in the leavingPool state. </param>
        /// <param name="unknown"> The number of Compute Nodes in the unknown state. </param>
        /// <param name="unusable"> The number of Compute Nodes in the unusable state. </param>
        /// <param name="waitingForStartTask"> The number of Compute Nodes in the waitingForStartTask state. </param>
        /// <param name="total"> The total number of Compute Nodes. </param>
        /// <param name="upgradingOs"> The number of Compute Nodes in the upgradingOS state. </param>
        /// <returns> A new <see cref="Batch.BatchNodeCounts"/> instance for mocking. </returns>
        public static BatchNodeCounts BatchNodeCounts(int creating = default, int idle = default, int offline = default, int preempted = default, int rebooting = default, int reimaging = default, int running = default, int starting = default, int startTaskFailed = default, int leavingPool = default, int unknown = default, int unusable = default, int waitingForStartTask = default, int total = default, int upgradingOs = default)
        {
            return new BatchNodeCounts(
                creating,
                idle,
                offline,
                preempted,
                rebooting,
                reimaging,
                running,
                starting,
                startTaskFailed,
                leavingPool,
                unknown,
                unusable,
                waitingForStartTask,
                total,
                upgradingOs,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJob"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Job within the Account. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case). </param>
        /// <param name="displayName"> The display name for the Job. </param>
        /// <param name="usesTaskDependencies"> Whether Tasks in the Job can define dependencies on each other. The default is false. </param>
        /// <param name="url"> The URL of the Job. </param>
        /// <param name="eTag"> The ETag of the Job. This is an opaque string. You can use it to detect whether the Job has changed between requests. In particular, you can be pass the ETag when updating a Job to specify that your changes should take effect only if nobody else has modified the Job in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Job. This is the last time at which the Job level data, such as the Job state or priority, changed. It does not factor in task-level changes such as adding new Tasks or Tasks changing state. </param>
        /// <param name="creationTime"> The creation time of the Job. </param>
        /// <param name="state"> The current state of the Job. </param>
        /// <param name="stateTransitionTime"> The time at which the Job entered its current state. </param>
        /// <param name="previousState"> The previous state of the Job. This property is not set if the Job is in its initial Active state. </param>
        /// <param name="previousStateTransitionTime"> The time at which the Job entered its previous state. This property is not set if the Job is in its initial Active state. </param>
        /// <param name="priority"> The priority of the Job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0. </param>
        /// <param name="allowTaskPreemption"> Whether Tasks in this job can be preempted by other high priority jobs. If the value is set to True, other high priority jobs submitted to the system will take precedence and will be able requeue tasks from this job. You can update a job's allowTaskPreemption after it has been created using the update job API. </param>
        /// <param name="maxParallelTasks"> The maximum number of tasks that can be executed in parallel for the job. The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value is -1, which means there's no limit to the number of tasks that can be run at once. You can update a job's maxParallelTasks after it has been created using the update job API. </param>
        /// <param name="constraints"> The execution constraints for the Job. </param>
        /// <param name="jobManagerTask"> Details of a Job Manager Task to be launched when the Job is started. </param>
        /// <param name="jobPreparationTask"> The Job Preparation Task. The Job Preparation Task is a special Task run on each Compute Node before any other Task of the Job. </param>
        /// <param name="jobReleaseTask"> The Job Release Task. The Job Release Task is a special Task run at the end of the Job on each Compute Node that has run any other Task of the Job. </param>
        /// <param name="commonEnvironmentSettings"> The list of common environment variable settings. These environment variables are set for all Tasks in the Job (including the Job Manager, Job Preparation and Job Release Tasks). Individual Tasks can override an environment setting specified here by specifying the same setting name with a different value. </param>
        /// <param name="poolInfo"> The Pool settings associated with the Job. </param>
        /// <param name="onAllTasksComplete"> The action the Batch service should take when all Tasks in the Job are in the completed state. The default is noaction. </param>
        /// <param name="onTaskFailure"> The action the Batch service should take when any Task in the Job fails. A Task is considered to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero exit code after exhausting its retry count, or if there was an error starting the Task, for example due to a resource file download error. The default is noaction. </param>
        /// <param name="networkConfiguration"> The network configuration for the Job. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the Job as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <param name="executionInfo"> The execution information for the Job. </param>
        /// <param name="stats"> Resource usage statistics for the entire lifetime of the Job. This property is populated only if the CloudJob was retrieved with an expand clause including the 'stats' attribute; otherwise it is null. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes. </param>
        /// <returns> A new <see cref="Batch.BatchJob"/> instance for mocking. </returns>
        public static BatchJob BatchJob(string id = null, string displayName = null, bool? usesTaskDependencies = null, string url = null, string eTag = null, DateTimeOffset? lastModified = null, DateTimeOffset? creationTime = null, BatchJobState? state = null, DateTimeOffset? stateTransitionTime = null, BatchJobState? previousState = null, DateTimeOffset? previousStateTransitionTime = null, int? priority = null, bool? allowTaskPreemption = null, int? maxParallelTasks = null, BatchJobConstraints constraints = null, BatchJobManagerTask jobManagerTask = null, BatchJobPreparationTask jobPreparationTask = null, BatchJobReleaseTask jobReleaseTask = null, IEnumerable<EnvironmentSetting> commonEnvironmentSettings = null, BatchPoolInfo poolInfo = null, OnAllBatchTasksComplete? onAllTasksComplete = null, OnBatchTaskFailure? onTaskFailure = null, BatchJobNetworkConfiguration networkConfiguration = null, IEnumerable<MetadataItem> metadata = null, BatchJobExecutionInfo executionInfo = null, BatchJobStatistics stats = null)
        {
            commonEnvironmentSettings ??= new List<EnvironmentSetting>();
            metadata ??= new List<MetadataItem>();

            return new BatchJob(
                id,
                displayName,
                usesTaskDependencies,
                url,
                eTag,
                lastModified,
                creationTime,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                priority,
                allowTaskPreemption,
                maxParallelTasks,
                constraints,
                jobManagerTask,
                jobPreparationTask,
                jobReleaseTask,
                commonEnvironmentSettings?.ToList(),
                poolInfo,
                onAllTasksComplete,
                onTaskFailure,
                networkConfiguration,
                metadata?.ToList(),
                executionInfo,
                stats,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobExecutionInfo"/>. </summary>
        /// <param name="startTime"> The start time of the Job. This is the time at which the Job was created. </param>
        /// <param name="endTime"> The completion time of the Job. This property is set only if the Job is in the completed state. </param>
        /// <param name="poolId"> The ID of the Pool to which this Job is assigned. This element contains the actual Pool where the Job is assigned. When you get Job details from the service, they also contain a poolInfo element, which contains the Pool configuration data from when the Job was added or updated. That poolInfo element may also contain a poolId element. If it does, the two IDs are the same. If it does not, it means the Job ran on an auto Pool, and this property contains the ID of that auto Pool. </param>
        /// <param name="schedulingError"> Details of any error encountered by the service in starting the Job. This property is not set if there was no error starting the Job. </param>
        /// <param name="terminationReason"> A string describing the reason the Job ended. This property is set only if the Job is in the completed state. If the Batch service terminates the Job, it sets the reason as follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion was set to true. MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the Job's onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job are complete. TaskFailed - the Job's onTaskFailure attribute is set to performExitOptionsJobAction, and a Task in the Job failed with an exit condition that specified a jobAction of terminatejob. Any other string is a user-defined reason specified in a call to the 'Terminate a Job' operation. </param>
        /// <returns> A new <see cref="Batch.BatchJobExecutionInfo"/> instance for mocking. </returns>
        public static BatchJobExecutionInfo BatchJobExecutionInfo(DateTimeOffset startTime = default, DateTimeOffset? endTime = null, string poolId = null, BatchJobSchedulingError schedulingError = null, string terminationReason = null)
        {
            return new BatchJobExecutionInfo(
                startTime,
                endTime,
                poolId,
                schedulingError,
                terminationReason,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobSchedulingError"/>. </summary>
        /// <param name="category"> The category of the Job scheduling error. </param>
        /// <param name="code"> An identifier for the Job scheduling error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the Job scheduling error, intended to be suitable for display in a user interface. </param>
        /// <param name="details"> A list of additional error details related to the scheduling error. </param>
        /// <returns> A new <see cref="Batch.BatchJobSchedulingError"/> instance for mocking. </returns>
        public static BatchJobSchedulingError BatchJobSchedulingError(ErrorCategory category = default, string code = null, string message = null, IEnumerable<NameValuePair> details = null)
        {
            details ??= new List<NameValuePair>();

            return new BatchJobSchedulingError(category, code, message, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobStatistics"/>. </summary>
        /// <param name="url"> The URL of the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="userCpuTime"> The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by all Tasks in the Job. </param>
        /// <param name="kernelCpuTime"> The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by all Tasks in the Job. </param>
        /// <param name="wallClockTime"> The total wall clock time of all Tasks in the Job.  The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If a Task was retried, this includes the wall clock time of all the Task retries. </param>
        /// <param name="readIOps"> The total number of disk read operations made by all Tasks in the Job. </param>
        /// <param name="writeIOps"> The total number of disk write operations made by all Tasks in the Job. </param>
        /// <param name="readIOGiB"> The total amount of data in GiB read from disk by all Tasks in the Job. </param>
        /// <param name="writeIOGiB"> The total amount of data in GiB written to disk by all Tasks in the Job. </param>
        /// <param name="numSucceededTasks"> The total number of Tasks successfully completed in the Job during the given time range. A Task completes successfully if it returns exit code 0. </param>
        /// <param name="numFailedTasks"> The total number of Tasks in the Job that failed during the given time range. A Task fails if it exhausts its maximum retry count without returning exit code 0. </param>
        /// <param name="numTaskRetries"> The total number of retries on all the Tasks in the Job during the given time range. </param>
        /// <param name="waitTime"> The total wait time of all Tasks in the Job. The wait time for a Task is defined as the elapsed time between the creation of the Task and the start of Task execution. (If the Task is retried due to failures, the wait time is the time to the most recent Task execution.) This value is only reported in the Account lifetime statistics; it is not included in the Job statistics. </param>
        /// <returns> A new <see cref="Batch.BatchJobStatistics"/> instance for mocking. </returns>
        public static BatchJobStatistics BatchJobStatistics(string url = null, DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, TimeSpan userCpuTime = default, TimeSpan kernelCpuTime = default, TimeSpan wallClockTime = default, long readIOps = default, long writeIOps = default, float readIOGiB = default, float writeIOGiB = default, long numSucceededTasks = default, long numFailedTasks = default, long numTaskRetries = default, TimeSpan waitTime = default)
        {
            return new BatchJobStatistics(
                url,
                startTime,
                lastUpdateTime,
                userCpuTime,
                kernelCpuTime,
                wallClockTime,
                readIOps,
                writeIOps,
                readIOGiB,
                writeIOGiB,
                numSucceededTasks,
                numFailedTasks,
                numTaskRetries,
                waitTime,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobCreateContent"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Job within the Account. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case). </param>
        /// <param name="displayName"> The display name for the Job. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="usesTaskDependencies"> Whether Tasks in the Job can define dependencies on each other. The default is false. </param>
        /// <param name="priority"> The priority of the Job. Priority values can range from -1000 to 1000, with -1000 being the lowest priority and 1000 being the highest priority. The default value is 0. </param>
        /// <param name="allowTaskPreemption"> Whether Tasks in this job can be preempted by other high priority jobs. If the value is set to True, other high priority jobs submitted to the system will take precedence and will be able requeue tasks from this job. You can update a job's allowTaskPreemption after it has been created using the update job API. </param>
        /// <param name="maxParallelTasks"> The maximum number of tasks that can be executed in parallel for the job. The value of maxParallelTasks must be -1 or greater than 0 if specified. If not specified, the default value is -1, which means there's no limit to the number of tasks that can be run at once. You can update a job's maxParallelTasks after it has been created using the update job API. </param>
        /// <param name="constraints"> The execution constraints for the Job. </param>
        /// <param name="jobManagerTask"> Details of a Job Manager Task to be launched when the Job is started. If the Job does not specify a Job Manager Task, the user must explicitly add Tasks to the Job. If the Job does specify a Job Manager Task, the Batch service creates the Job Manager Task when the Job is created, and will try to schedule the Job Manager Task before scheduling other Tasks in the Job. The Job Manager Task's typical purpose is to control and/or monitor Job execution, for example by deciding what additional Tasks to run, determining when the work is complete, etc. (However, a Job Manager Task is not restricted to these activities - it is a fully-fledged Task in the system and perform whatever actions are required for the Job.) For example, a Job Manager Task might download a file specified as a parameter, analyze the contents of that file and submit additional Tasks based on those contents. </param>
        /// <param name="jobPreparationTask"> The Job Preparation Task. If a Job has a Job Preparation Task, the Batch service will run the Job Preparation Task on a Node before starting any Tasks of that Job on that Compute Node. </param>
        /// <param name="jobReleaseTask"> The Job Release Task. A Job Release Task cannot be specified without also specifying a Job Preparation Task for the Job. The Batch service runs the Job Release Task on the Nodes that have run the Job Preparation Task. The primary purpose of the Job Release Task is to undo changes to Compute Nodes made by the Job Preparation Task. Example activities include deleting local files, or shutting down services that were started as part of Job preparation. </param>
        /// <param name="commonEnvironmentSettings"> The list of common environment variable settings. These environment variables are set for all Tasks in the Job (including the Job Manager, Job Preparation and Job Release Tasks). Individual Tasks can override an environment setting specified here by specifying the same setting name with a different value. </param>
        /// <param name="poolInfo"> The Pool on which the Batch service runs the Job's Tasks. </param>
        /// <param name="onAllTasksComplete"> The action the Batch service should take when all Tasks in the Job are in the completed state. Note that if a Job contains no Tasks, then all Tasks are considered complete. This option is therefore most commonly used with a Job Manager task; if you want to use automatic Job termination without a Job Manager, you should initially set onAllTasksComplete to noaction and update the Job properties to set onAllTasksComplete to terminatejob once you have finished adding Tasks. The default is noaction. </param>
        /// <param name="onTaskFailure"> The action the Batch service should take when any Task in the Job fails. A Task is considered to have failed if has a failureInfo. A failureInfo is set if the Task completes with a non-zero exit code after exhausting its retry count, or if there was an error starting the Task, for example due to a resource file download error. The default is noaction. </param>
        /// <param name="networkConfiguration"> The network configuration for the Job. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the Job as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <returns> A new <see cref="Batch.BatchJobCreateContent"/> instance for mocking. </returns>
        public static BatchJobCreateContent BatchJobCreateContent(string id = null, string displayName = null, bool? usesTaskDependencies = null, int? priority = null, bool? allowTaskPreemption = null, int? maxParallelTasks = null, BatchJobConstraints constraints = null, BatchJobManagerTask jobManagerTask = null, BatchJobPreparationTask jobPreparationTask = null, BatchJobReleaseTask jobReleaseTask = null, IEnumerable<EnvironmentSetting> commonEnvironmentSettings = null, BatchPoolInfo poolInfo = null, OnAllBatchTasksComplete? onAllTasksComplete = null, OnBatchTaskFailure? onTaskFailure = null, BatchJobNetworkConfiguration networkConfiguration = null, IEnumerable<MetadataItem> metadata = null)
        {
            commonEnvironmentSettings ??= new List<EnvironmentSetting>();
            metadata ??= new List<MetadataItem>();

            return new BatchJobCreateContent(
                id,
                displayName,
                usesTaskDependencies,
                priority,
                allowTaskPreemption,
                maxParallelTasks,
                constraints,
                jobManagerTask,
                jobPreparationTask,
                jobReleaseTask,
                commonEnvironmentSettings?.ToList(),
                poolInfo,
                onAllTasksComplete,
                onTaskFailure,
                networkConfiguration,
                metadata?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobPreparationAndReleaseTaskStatus"/>. </summary>
        /// <param name="poolId"> The ID of the Pool containing the Compute Node to which this entry refers. </param>
        /// <param name="nodeId"> The ID of the Compute Node to which this entry refers. </param>
        /// <param name="nodeUrl"> The URL of the Compute Node to which this entry refers. </param>
        /// <param name="jobPreparationTaskExecutionInfo"> Information about the execution status of the Job Preparation Task on this Compute Node. </param>
        /// <param name="jobReleaseTaskExecutionInfo"> Information about the execution status of the Job Release Task on this Compute Node. This property is set only if the Job Release Task has run on the Compute Node. </param>
        /// <returns> A new <see cref="Batch.BatchJobPreparationAndReleaseTaskStatus"/> instance for mocking. </returns>
        public static BatchJobPreparationAndReleaseTaskStatus BatchJobPreparationAndReleaseTaskStatus(string poolId = null, string nodeId = null, string nodeUrl = null, BatchJobPreparationTaskExecutionInfo jobPreparationTaskExecutionInfo = null, BatchJobReleaseTaskExecutionInfo jobReleaseTaskExecutionInfo = null)
        {
            return new BatchJobPreparationAndReleaseTaskStatus(
                poolId,
                nodeId,
                nodeUrl,
                jobPreparationTaskExecutionInfo,
                jobReleaseTaskExecutionInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobPreparationTaskExecutionInfo"/>. </summary>
        /// <param name="startTime"> The time at which the Task started running. If the Task has been restarted or retried, this is the most recent time at which the Task started running. </param>
        /// <param name="endTime"> The time at which the Job Preparation Task completed. This property is set only if the Task is in the Completed state. </param>
        /// <param name="state"> The current state of the Job Preparation Task on the Compute Node. </param>
        /// <param name="taskRootDirectory"> The root directory of the Job Preparation Task on the Compute Node. You can use this path to retrieve files created by the Task, such as log files. </param>
        /// <param name="taskRootDirectoryUrl"> The URL to the root directory of the Job Preparation Task on the Compute Node. </param>
        /// <param name="exitCode"> The exit code of the program specified on the Task command line. This parameter is returned only if the Task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the Compute Node operating system, such as when a process is forcibly terminated. </param>
        /// <param name="containerInfo"> Information about the container under which the Task is executing. This property is set only if the Task runs in a container context. </param>
        /// <param name="failureInfo"> Information describing the Task failure, if any. This property is set only if the Task is in the completed state and encountered a failure. </param>
        /// <param name="retryCount"> The number of times the Task has been retried by the Batch service. Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints. Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints. </param>
        /// <param name="lastRetryTime"> The most recent time at which a retry of the Job Preparation Task started running. This property is set only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not. </param>
        /// <param name="result"> The result of the Task execution. If the value is 'failed', then the details of the failure can be found in the failureInfo property. </param>
        /// <returns> A new <see cref="Batch.BatchJobPreparationTaskExecutionInfo"/> instance for mocking. </returns>
        public static BatchJobPreparationTaskExecutionInfo BatchJobPreparationTaskExecutionInfo(DateTimeOffset startTime = default, DateTimeOffset? endTime = null, BatchJobPreparationTaskState state = default, string taskRootDirectory = null, string taskRootDirectoryUrl = null, int? exitCode = null, BatchTaskContainerExecutionInfo containerInfo = null, BatchTaskFailureInfo failureInfo = null, int retryCount = default, DateTimeOffset? lastRetryTime = null, BatchTaskExecutionResult? result = null)
        {
            return new BatchJobPreparationTaskExecutionInfo(
                startTime,
                endTime,
                state,
                taskRootDirectory,
                taskRootDirectoryUrl,
                exitCode,
                containerInfo,
                failureInfo,
                retryCount,
                lastRetryTime,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskContainerExecutionInfo"/>. </summary>
        /// <param name="containerId"> The ID of the container. </param>
        /// <param name="state"> The state of the container. This is the state of the container according to the Docker service. It is equivalent to the status field returned by "docker inspect". </param>
        /// <param name="error"> Detailed error information about the container. This is the detailed error string from the Docker service, if available. It is equivalent to the error field returned by "docker inspect". </param>
        /// <returns> A new <see cref="Batch.BatchTaskContainerExecutionInfo"/> instance for mocking. </returns>
        public static BatchTaskContainerExecutionInfo BatchTaskContainerExecutionInfo(string containerId = null, string state = null, string error = null)
        {
            return new BatchTaskContainerExecutionInfo(containerId, state, error, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskFailureInfo"/>. </summary>
        /// <param name="category"> The category of the Task error. </param>
        /// <param name="code"> An identifier for the Task error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the Task error, intended to be suitable for display in a user interface. </param>
        /// <param name="details"> A list of additional details related to the error. </param>
        /// <returns> A new <see cref="Batch.BatchTaskFailureInfo"/> instance for mocking. </returns>
        public static BatchTaskFailureInfo BatchTaskFailureInfo(ErrorCategory category = default, string code = null, string message = null, IEnumerable<NameValuePair> details = null)
        {
            details ??= new List<NameValuePair>();

            return new BatchTaskFailureInfo(category, code, message, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobReleaseTaskExecutionInfo"/>. </summary>
        /// <param name="startTime"> The time at which the Task started running. If the Task has been restarted or retried, this is the most recent time at which the Task started running. </param>
        /// <param name="endTime"> The time at which the Job Release Task completed. This property is set only if the Task is in the Completed state. </param>
        /// <param name="state"> The current state of the Job Release Task on the Compute Node. </param>
        /// <param name="taskRootDirectory"> The root directory of the Job Release Task on the Compute Node. You can use this path to retrieve files created by the Task, such as log files. </param>
        /// <param name="taskRootDirectoryUrl"> The URL to the root directory of the Job Release Task on the Compute Node. </param>
        /// <param name="exitCode"> The exit code of the program specified on the Task command line. This parameter is returned only if the Task is in the completed state. The exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. Note that the exit code may also be generated by the Compute Node operating system, such as when a process is forcibly terminated. </param>
        /// <param name="containerInfo"> Information about the container under which the Task is executing. This property is set only if the Task runs in a container context. </param>
        /// <param name="failureInfo"> Information describing the Task failure, if any. This property is set only if the Task is in the completed state and encountered a failure. </param>
        /// <param name="result"> The result of the Task execution. If the value is 'failed', then the details of the failure can be found in the failureInfo property. </param>
        /// <returns> A new <see cref="Batch.BatchJobReleaseTaskExecutionInfo"/> instance for mocking. </returns>
        public static BatchJobReleaseTaskExecutionInfo BatchJobReleaseTaskExecutionInfo(DateTimeOffset startTime = default, DateTimeOffset? endTime = null, BatchJobReleaseTaskState state = default, string taskRootDirectory = null, string taskRootDirectoryUrl = null, int? exitCode = null, BatchTaskContainerExecutionInfo containerInfo = null, BatchTaskFailureInfo failureInfo = null, BatchTaskExecutionResult? result = null)
        {
            return new BatchJobReleaseTaskExecutionInfo(
                startTime,
                endTime,
                state,
                taskRootDirectory,
                taskRootDirectoryUrl,
                exitCode,
                containerInfo,
                failureInfo,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskCountsResult"/>. </summary>
        /// <param name="taskCounts"> The number of Tasks per state. </param>
        /// <param name="taskSlotCounts"> The number of TaskSlots required by Tasks per state. </param>
        /// <returns> A new <see cref="Batch.BatchTaskCountsResult"/> instance for mocking. </returns>
        public static BatchTaskCountsResult BatchTaskCountsResult(BatchTaskCounts taskCounts = null, BatchTaskSlotCounts taskSlotCounts = null)
        {
            return new BatchTaskCountsResult(taskCounts, taskSlotCounts, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskCounts"/>. </summary>
        /// <param name="active"> The number of Tasks in the active state. </param>
        /// <param name="running"> The number of Tasks in the running or preparing state. </param>
        /// <param name="completed"> The number of Tasks in the completed state. </param>
        /// <param name="succeeded"> The number of Tasks which succeeded. A Task succeeds if its result (found in the executionInfo property) is 'success'. </param>
        /// <param name="failed"> The number of Tasks which failed. A Task fails if its result (found in the executionInfo property) is 'failure'. </param>
        /// <returns> A new <see cref="Batch.BatchTaskCounts"/> instance for mocking. </returns>
        public static BatchTaskCounts BatchTaskCounts(int active = default, int running = default, int completed = default, int succeeded = default, int failed = default)
        {
            return new BatchTaskCounts(
                active,
                running,
                completed,
                succeeded,
                failed,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskSlotCounts"/>. </summary>
        /// <param name="active"> The number of TaskSlots for active Tasks. </param>
        /// <param name="running"> The number of TaskSlots for running Tasks. </param>
        /// <param name="completed"> The number of TaskSlots for completed Tasks. </param>
        /// <param name="succeeded"> The number of TaskSlots for succeeded Tasks. </param>
        /// <param name="failed"> The number of TaskSlots for failed Tasks. </param>
        /// <returns> A new <see cref="Batch.BatchTaskSlotCounts"/> instance for mocking. </returns>
        public static BatchTaskSlotCounts BatchTaskSlotCounts(int active = default, int running = default, int completed = default, int succeeded = default, int failed = default)
        {
            return new BatchTaskSlotCounts(
                active,
                running,
                completed,
                succeeded,
                failed,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobSchedule"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the schedule within the Account. </param>
        /// <param name="displayName"> The display name for the schedule. </param>
        /// <param name="url"> The URL of the Job Schedule. </param>
        /// <param name="eTag"> The ETag of the Job Schedule. This is an opaque string. You can use it to detect whether the Job Schedule has changed between requests. In particular, you can be pass the ETag with an Update Job Schedule request to specify that your changes should take effect only if nobody else has modified the schedule in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Job Schedule. This is the last time at which the schedule level data, such as the Job specification or recurrence information, changed. It does not factor in job-level changes such as new Jobs being created or Jobs changing state. </param>
        /// <param name="creationTime"> The creation time of the Job Schedule. </param>
        /// <param name="state"> The current state of the Job Schedule. </param>
        /// <param name="stateTransitionTime"> The time at which the Job Schedule entered the current state. </param>
        /// <param name="previousState"> The previous state of the Job Schedule. This property is not present if the Job Schedule is in its initial active state. </param>
        /// <param name="previousStateTransitionTime"> The time at which the Job Schedule entered its previous state. This property is not present if the Job Schedule is in its initial active state. </param>
        /// <param name="schedule"> The schedule according to which Jobs will be created. All times are fixed respective to UTC and are not impacted by daylight saving time. </param>
        /// <param name="jobSpecification"> The details of the Jobs to be created on this schedule. </param>
        /// <param name="executionInfo"> Information about Jobs that have been and will be run under this schedule. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the schedule as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <param name="stats"> The lifetime resource usage statistics for the Job Schedule. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes. </param>
        /// <returns> A new <see cref="Batch.BatchJobSchedule"/> instance for mocking. </returns>
        public static BatchJobSchedule BatchJobSchedule(string id = null, string displayName = null, string url = null, string eTag = null, DateTimeOffset? lastModified = null, DateTimeOffset? creationTime = null, BatchJobScheduleState? state = null, DateTimeOffset? stateTransitionTime = null, BatchJobScheduleState? previousState = null, DateTimeOffset? previousStateTransitionTime = null, BatchJobScheduleConfiguration schedule = null, BatchJobSpecification jobSpecification = null, BatchJobScheduleExecutionInfo executionInfo = null, IEnumerable<MetadataItem> metadata = null, BatchJobScheduleStatistics stats = null)
        {
            metadata ??= new List<MetadataItem>();

            return new BatchJobSchedule(
                id,
                displayName,
                url,
                eTag,
                lastModified,
                creationTime,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                schedule,
                jobSpecification,
                executionInfo,
                metadata?.ToList(),
                stats,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobScheduleExecutionInfo"/>. </summary>
        /// <param name="nextRunTime"> The next time at which a Job will be created under this schedule. This property is meaningful only if the schedule is in the active state when the time comes around. For example, if the schedule is disabled, no Job will be created at nextRunTime unless the Job is enabled before then. </param>
        /// <param name="recentJob"> Information about the most recent Job under the Job Schedule. This property is present only if the at least one Job has run under the schedule. </param>
        /// <param name="endTime"> The time at which the schedule ended. This property is set only if the Job Schedule is in the completed state. </param>
        /// <returns> A new <see cref="Batch.BatchJobScheduleExecutionInfo"/> instance for mocking. </returns>
        public static BatchJobScheduleExecutionInfo BatchJobScheduleExecutionInfo(DateTimeOffset? nextRunTime = null, RecentBatchJob recentJob = null, DateTimeOffset? endTime = null)
        {
            return new BatchJobScheduleExecutionInfo(nextRunTime, recentJob, endTime, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.RecentBatchJob"/>. </summary>
        /// <param name="id"> The ID of the Job. </param>
        /// <param name="url"> The URL of the Job. </param>
        /// <returns> A new <see cref="Batch.RecentBatchJob"/> instance for mocking. </returns>
        public static RecentBatchJob RecentBatchJob(string id = null, string url = null)
        {
            return new RecentBatchJob(id, url, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobScheduleStatistics"/>. </summary>
        /// <param name="url"> The URL of the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="userCpuTime"> The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="kernelCpuTime"> The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="wallClockTime"> The total wall clock time of all the Tasks in all the Jobs created under the schedule. The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If a Task was retried, this includes the wall clock time of all the Task retries. </param>
        /// <param name="readIOps"> The total number of disk read operations made by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="writeIOps"> The total number of disk write operations made by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="readIOGiB"> The total gibibytes read from disk by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="writeIOGiB"> The total gibibytes written to disk by all Tasks in all Jobs created under the schedule. </param>
        /// <param name="numSucceededTasks"> The total number of Tasks successfully completed during the given time range in Jobs created under the schedule. A Task completes successfully if it returns exit code 0. </param>
        /// <param name="numFailedTasks"> The total number of Tasks that failed during the given time range in Jobs created under the schedule. A Task fails if it exhausts its maximum retry count without returning exit code 0. </param>
        /// <param name="numTaskRetries"> The total number of retries during the given time range on all Tasks in all Jobs created under the schedule. </param>
        /// <param name="waitTime"> The total wait time of all Tasks in all Jobs created under the schedule. The wait time for a Task is defined as the elapsed time between the creation of the Task and the start of Task execution. (If the Task is retried due to failures, the wait time is the time to the most recent Task execution.). This value is only reported in the Account lifetime statistics; it is not included in the Job statistics. </param>
        /// <returns> A new <see cref="Batch.BatchJobScheduleStatistics"/> instance for mocking. </returns>
        public static BatchJobScheduleStatistics BatchJobScheduleStatistics(string url = null, DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, TimeSpan userCpuTime = default, TimeSpan kernelCpuTime = default, TimeSpan wallClockTime = default, long readIOps = default, long writeIOps = default, float readIOGiB = default, float writeIOGiB = default, long numSucceededTasks = default, long numFailedTasks = default, long numTaskRetries = default, TimeSpan waitTime = default)
        {
            return new BatchJobScheduleStatistics(
                url,
                startTime,
                lastUpdateTime,
                userCpuTime,
                kernelCpuTime,
                wallClockTime,
                readIOps,
                writeIOps,
                readIOGiB,
                writeIOGiB,
                numSucceededTasks,
                numFailedTasks,
                numTaskRetries,
                waitTime,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchJobScheduleCreateContent"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the schedule within the Account. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within an Account that differ only by case). </param>
        /// <param name="displayName"> The display name for the schedule. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="schedule"> The schedule according to which Jobs will be created. All times are fixed respective to UTC and are not impacted by daylight saving time. </param>
        /// <param name="jobSpecification"> The details of the Jobs to be created on this schedule. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the schedule as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <returns> A new <see cref="Batch.BatchJobScheduleCreateContent"/> instance for mocking. </returns>
        public static BatchJobScheduleCreateContent BatchJobScheduleCreateContent(string id = null, string displayName = null, BatchJobScheduleConfiguration schedule = null, BatchJobSpecification jobSpecification = null, IEnumerable<MetadataItem> metadata = null)
        {
            metadata ??= new List<MetadataItem>();

            return new BatchJobScheduleCreateContent(
                id,
                displayName,
                schedule,
                jobSpecification,
                metadata?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskCreateContent"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Task within the Job. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. The ID is case-preserving and case-insensitive (that is, you may not have two IDs within a Job that differ only by case). </param>
        /// <param name="displayName"> A display name for the Task. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="exitConditions"> How the Batch service should respond when the Task completes. </param>
        /// <param name="commandLine"> The command line of the Task. For multi-instance Tasks, the command line is executed as the primary Task, after the primary Task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables). </param>
        /// <param name="containerSettings"> The settings for the container under which the Task runs. If the Pool that will run this Task has containerConfiguration set, this must be set as well. If the Pool that will run this Task doesn't have containerConfiguration set, this must not be set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files. </param>
        /// <param name="resourceFiles"> A list of files that the Batch service will download to the Compute Node before running the command line. For multi-instance Tasks, the resource files will only be downloaded to the Compute Node on which the primary Task is executed. There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers. </param>
        /// <param name="outputFiles"> A list of files that the Batch service will upload from the Compute Node after running the command line. For multi-instance Tasks, the files will only be uploaded from the Compute Node on which the primary Task is executed. </param>
        /// <param name="environmentSettings"> A list of environment variable settings for the Task. </param>
        /// <param name="affinityInfo"> A locality hint that can be used by the Batch service to select a Compute Node on which to start the new Task. </param>
        /// <param name="constraints"> The execution constraints that apply to this Task. If you do not specify constraints, the maxTaskRetryCount is the maxTaskRetryCount specified for the Job, the maxWallClockTime is infinite, and the retentionTime is 7 days. </param>
        /// <param name="requiredSlots"> The number of scheduling slots that the Task required to run. The default is 1. A Task can only be scheduled to run on a compute node if the node has enough free scheduling slots available. For multi-instance Tasks, this must be 1. </param>
        /// <param name="userIdentity"> The user identity under which the Task runs. If omitted, the Task runs as a non-administrative user unique to the Task. </param>
        /// <param name="multiInstanceSettings"> An object that indicates that the Task is a multi-instance Task, and contains information about how to run the multi-instance Task. </param>
        /// <param name="dependsOn"> The Tasks that this Task depends on. This Task will not be scheduled until all Tasks that it depends on have completed successfully. If any of those Tasks fail and exhaust their retry counts, this Task will never be scheduled. If the Job does not have usesTaskDependencies set to true, and this element is present, the request fails with error code TaskDependenciesNotSpecifiedOnJob. </param>
        /// <param name="applicationPackageReferences"> A list of Packages that the Batch service will deploy to the Compute Node before running the command line. Application packages are downloaded and deployed to a shared directory, not the Task working directory. Therefore, if a referenced package is already on the Node, and is up to date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a referenced Package cannot be installed, for example because the package has been deleted or because download failed, the Task fails. </param>
        /// <param name="authenticationTokenSettings"> The settings for an authentication token that the Task can use to perform Batch service operations. If this property is set, the Batch service provides the Task with an authentication token which can be used to authenticate Batch service operations without requiring an Account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out using the token depend on the settings. For example, a Task can request Job permissions in order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the Job. </param>
        /// <returns> A new <see cref="Batch.BatchTaskCreateContent"/> instance for mocking. </returns>
        public static BatchTaskCreateContent BatchTaskCreateContent(string id = null, string displayName = null, ExitConditions exitConditions = null, string commandLine = null, BatchTaskContainerSettings containerSettings = null, IEnumerable<ResourceFile> resourceFiles = null, IEnumerable<OutputFile> outputFiles = null, IEnumerable<EnvironmentSetting> environmentSettings = null, AffinityInfo affinityInfo = null, BatchTaskConstraints constraints = null, int? requiredSlots = null, UserIdentity userIdentity = null, MultiInstanceSettings multiInstanceSettings = null, BatchTaskDependencies dependsOn = null, IEnumerable<BatchApplicationPackageReference> applicationPackageReferences = null, AuthenticationTokenSettings authenticationTokenSettings = null)
        {
            resourceFiles ??= new List<ResourceFile>();
            outputFiles ??= new List<OutputFile>();
            environmentSettings ??= new List<EnvironmentSetting>();
            applicationPackageReferences ??= new List<BatchApplicationPackageReference>();

            return new BatchTaskCreateContent(
                id,
                displayName,
                exitConditions,
                commandLine,
                containerSettings,
                resourceFiles?.ToList(),
                outputFiles?.ToList(),
                environmentSettings?.ToList(),
                affinityInfo,
                constraints,
                requiredSlots,
                userIdentity,
                multiInstanceSettings,
                dependsOn,
                applicationPackageReferences?.ToList(),
                authenticationTokenSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTask"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the Task within the Job. The ID can contain any combination of alphanumeric characters including hyphens and underscores, and cannot contain more than 64 characters. </param>
        /// <param name="displayName"> A display name for the Task. The display name need not be unique and can contain any Unicode characters up to a maximum length of 1024. </param>
        /// <param name="url"> The URL of the Task. </param>
        /// <param name="eTag"> The ETag of the Task. This is an opaque string. You can use it to detect whether the Task has changed between requests. In particular, you can be pass the ETag when updating a Task to specify that your changes should take effect only if nobody else has modified the Task in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Task. </param>
        /// <param name="creationTime"> The creation time of the Task. </param>
        /// <param name="exitConditions"> How the Batch service should respond when the Task completes. </param>
        /// <param name="state"> The current state of the Task. </param>
        /// <param name="stateTransitionTime"> The time at which the Task entered its current state. </param>
        /// <param name="previousState"> The previous state of the Task. This property is not set if the Task is in its initial Active state. </param>
        /// <param name="previousStateTransitionTime"> The time at which the Task entered its previous state. This property is not set if the Task is in its initial Active state. </param>
        /// <param name="commandLine"> The command line of the Task. For multi-instance Tasks, the command line is executed as the primary Task, after the primary Task and all subtasks have finished executing the coordination command line. The command line does not run under a shell, and therefore cannot take advantage of shell features such as environment variable expansion. If you want to take advantage of such features, you should invoke the shell in the command line, for example using "cmd /c MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths, it should use a relative path (relative to the Task working directory), or use the Batch provided environment variable (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables). </param>
        /// <param name="containerSettings"> The settings for the container under which the Task runs. If the Pool that will run this Task has containerConfiguration set, this must be set as well. If the Pool that will run this Task doesn't have containerConfiguration set, this must not be set. When this is specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node) are mapped into the container, all Task environment variables are mapped into the container, and the Task command line is executed in the container. Files produced in the container outside of AZ_BATCH_NODE_ROOT_DIR might not be reflected to the host disk, meaning that Batch file APIs will not be able to access those files. </param>
        /// <param name="resourceFiles"> A list of files that the Batch service will download to the Compute Node before running the command line. For multi-instance Tasks, the resource files will only be downloaded to the Compute Node on which the primary Task is executed. There is a maximum size for the list of resource files.  When the max size is exceeded, the request will fail and the response error code will be RequestEntityTooLarge. If this occurs, the collection of ResourceFiles must be reduced in size. This can be achieved using .zip files, Application Packages, or Docker Containers. </param>
        /// <param name="outputFiles"> A list of files that the Batch service will upload from the Compute Node after running the command line. For multi-instance Tasks, the files will only be uploaded from the Compute Node on which the primary Task is executed. </param>
        /// <param name="environmentSettings"> A list of environment variable settings for the Task. </param>
        /// <param name="affinityInfo"> A locality hint that can be used by the Batch service to select a Compute Node on which to start the new Task. </param>
        /// <param name="constraints"> The execution constraints that apply to this Task. </param>
        /// <param name="requiredSlots"> The number of scheduling slots that the Task requires to run. The default is 1. A Task can only be scheduled to run on a compute node if the node has enough free scheduling slots available. For multi-instance Tasks, this must be 1. </param>
        /// <param name="userIdentity"> The user identity under which the Task runs. If omitted, the Task runs as a non-administrative user unique to the Task. </param>
        /// <param name="executionInfo"> Information about the execution of the Task. </param>
        /// <param name="nodeInfo"> Information about the Compute Node on which the Task ran. </param>
        /// <param name="multiInstanceSettings"> An object that indicates that the Task is a multi-instance Task, and contains information about how to run the multi-instance Task. </param>
        /// <param name="stats"> Resource usage statistics for the Task. </param>
        /// <param name="dependsOn"> The Tasks that this Task depends on. This Task will not be scheduled until all Tasks that it depends on have completed successfully. If any of those Tasks fail and exhaust their retry counts, this Task will never be scheduled. </param>
        /// <param name="applicationPackageReferences"> A list of Packages that the Batch service will deploy to the Compute Node before running the command line. Application packages are downloaded and deployed to a shared directory, not the Task working directory. Therefore, if a referenced package is already on the Node, and is up to date, then it is not re-downloaded; the existing copy on the Compute Node is used. If a referenced Package cannot be installed, for example because the package has been deleted or because download failed, the Task fails. </param>
        /// <param name="authenticationTokenSettings"> The settings for an authentication token that the Task can use to perform Batch service operations. If this property is set, the Batch service provides the Task with an authentication token which can be used to authenticate Batch service operations without requiring an Account access key. The token is provided via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations that the Task can carry out using the token depend on the settings. For example, a Task can request Job permissions in order to add other Tasks to the Job, or check the status of the Job or of other Tasks under the Job. </param>
        /// <returns> A new <see cref="Batch.BatchTask"/> instance for mocking. </returns>
        public static BatchTask BatchTask(string id = null, string displayName = null, string url = null, string eTag = null, DateTimeOffset? lastModified = null, DateTimeOffset? creationTime = null, ExitConditions exitConditions = null, BatchTaskState? state = null, DateTimeOffset? stateTransitionTime = null, BatchTaskState? previousState = null, DateTimeOffset? previousStateTransitionTime = null, string commandLine = null, BatchTaskContainerSettings containerSettings = null, IEnumerable<ResourceFile> resourceFiles = null, IEnumerable<OutputFile> outputFiles = null, IEnumerable<EnvironmentSetting> environmentSettings = null, AffinityInfo affinityInfo = null, BatchTaskConstraints constraints = null, int? requiredSlots = null, UserIdentity userIdentity = null, BatchTaskExecutionInfo executionInfo = null, BatchNodeInfo nodeInfo = null, MultiInstanceSettings multiInstanceSettings = null, BatchTaskStatistics stats = null, BatchTaskDependencies dependsOn = null, IEnumerable<BatchApplicationPackageReference> applicationPackageReferences = null, AuthenticationTokenSettings authenticationTokenSettings = null)
        {
            resourceFiles ??= new List<ResourceFile>();
            outputFiles ??= new List<OutputFile>();
            environmentSettings ??= new List<EnvironmentSetting>();
            applicationPackageReferences ??= new List<BatchApplicationPackageReference>();

            return new BatchTask(
                id,
                displayName,
                url,
                eTag,
                lastModified,
                creationTime,
                exitConditions,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                commandLine,
                containerSettings,
                resourceFiles?.ToList(),
                outputFiles?.ToList(),
                environmentSettings?.ToList(),
                affinityInfo,
                constraints,
                requiredSlots,
                userIdentity,
                executionInfo,
                nodeInfo,
                multiInstanceSettings,
                stats,
                dependsOn,
                applicationPackageReferences?.ToList(),
                authenticationTokenSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskExecutionInfo"/>. </summary>
        /// <param name="startTime"> The time at which the Task started running. 'Running' corresponds to the running state, so if the Task specifies resource files or Packages, then the start time reflects the time at which the Task started downloading or deploying these. If the Task has been restarted or retried, this is the most recent time at which the Task started running. This property is present only for Tasks that are in the running or completed state. </param>
        /// <param name="endTime"> The time at which the Task completed. This property is set only if the Task is in the Completed state. </param>
        /// <param name="exitCode"> The exit code of the program specified on the Task command line. This property is set only if the Task is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the Task (due to timeout, or user termination via the API) you may see an operating system-defined exit code. </param>
        /// <param name="containerInfo"> Information about the container under which the Task is executing. This property is set only if the Task runs in a container context. </param>
        /// <param name="failureInfo"> Information describing the Task failure, if any. This property is set only if the Task is in the completed state and encountered a failure. </param>
        /// <param name="retryCount"> The number of times the Task has been retried by the Batch service. Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints. </param>
        /// <param name="lastRetryTime"> The most recent time at which a retry of the Task started running. This element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not. </param>
        /// <param name="requeueCount"> The number of times the Task has been requeued by the Batch service as the result of a user request. When the user removes Compute Nodes from a Pool (by resizing/shrinking the pool) or when the Job is being disabled, the user can specify that running Tasks on the Compute Nodes be requeued for execution. This count tracks how many times the Task has been requeued for these reasons. </param>
        /// <param name="lastRequeueTime"> The most recent time at which the Task has been requeued by the Batch service as the result of a user request. This property is set only if the requeueCount is nonzero. </param>
        /// <param name="result"> The result of the Task execution. If the value is 'failed', then the details of the failure can be found in the failureInfo property. </param>
        /// <returns> A new <see cref="Batch.BatchTaskExecutionInfo"/> instance for mocking. </returns>
        public static BatchTaskExecutionInfo BatchTaskExecutionInfo(DateTimeOffset? startTime = null, DateTimeOffset? endTime = null, int? exitCode = null, BatchTaskContainerExecutionInfo containerInfo = null, BatchTaskFailureInfo failureInfo = null, int retryCount = default, DateTimeOffset? lastRetryTime = null, int requeueCount = default, DateTimeOffset? lastRequeueTime = null, BatchTaskExecutionResult? result = null)
        {
            return new BatchTaskExecutionInfo(
                startTime,
                endTime,
                exitCode,
                containerInfo,
                failureInfo,
                retryCount,
                lastRetryTime,
                requeueCount,
                lastRequeueTime,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeInfo"/>. </summary>
        /// <param name="affinityId"> An identifier for the Node on which the Task ran, which can be passed when adding a Task to request that the Task be scheduled on this Compute Node. </param>
        /// <param name="nodeUrl"> The URL of the Compute Node on which the Task ran. </param>
        /// <param name="poolId"> The ID of the Pool on which the Task ran. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which the Task ran. </param>
        /// <param name="taskRootDirectory"> The root directory of the Task on the Compute Node. </param>
        /// <param name="taskRootDirectoryUrl"> The URL to the root directory of the Task on the Compute Node. </param>
        /// <returns> A new <see cref="Batch.BatchNodeInfo"/> instance for mocking. </returns>
        public static BatchNodeInfo BatchNodeInfo(string affinityId = null, string nodeUrl = null, string poolId = null, string nodeId = null, string taskRootDirectory = null, string taskRootDirectoryUrl = null)
        {
            return new BatchNodeInfo(
                affinityId,
                nodeUrl,
                poolId,
                nodeId,
                taskRootDirectory,
                taskRootDirectoryUrl,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskStatistics"/>. </summary>
        /// <param name="url"> The URL of the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="userCpuTime"> The total user mode CPU time (summed across all cores and all Compute Nodes) consumed by the Task. </param>
        /// <param name="kernelCpuTime"> The total kernel mode CPU time (summed across all cores and all Compute Nodes) consumed by the Task. </param>
        /// <param name="wallClockTime"> The total wall clock time of the Task. The wall clock time is the elapsed time from when the Task started running on a Compute Node to when it finished (or to the last time the statistics were updated, if the Task had not finished by then). If the Task was retried, this includes the wall clock time of all the Task retries. </param>
        /// <param name="readIOps"> The total number of disk read operations made by the Task. </param>
        /// <param name="writeIOps"> The total number of disk write operations made by the Task. </param>
        /// <param name="readIOGiB"> The total gibibytes read from disk by the Task. </param>
        /// <param name="writeIOGiB"> The total gibibytes written to disk by the Task. </param>
        /// <param name="waitTime"> The total wait time of the Task. The wait time for a Task is defined as the elapsed time between the creation of the Task and the start of Task execution. (If the Task is retried due to failures, the wait time is the time to the most recent Task execution.). </param>
        /// <returns> A new <see cref="Batch.BatchTaskStatistics"/> instance for mocking. </returns>
        public static BatchTaskStatistics BatchTaskStatistics(string url = null, DateTimeOffset startTime = default, DateTimeOffset lastUpdateTime = default, TimeSpan userCpuTime = default, TimeSpan kernelCpuTime = default, TimeSpan wallClockTime = default, long readIOps = default, long writeIOps = default, float readIOGiB = default, float writeIOGiB = default, TimeSpan waitTime = default)
        {
            return new BatchTaskStatistics(
                url,
                startTime,
                lastUpdateTime,
                userCpuTime,
                kernelCpuTime,
                wallClockTime,
                readIOps,
                writeIOps,
                readIOGiB,
                writeIOGiB,
                waitTime,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskAddCollectionResult"/>. </summary>
        /// <param name="value"> The results of the add Task collection operation. </param>
        /// <returns> A new <see cref="Batch.BatchTaskAddCollectionResult"/> instance for mocking. </returns>
        public static BatchTaskAddCollectionResult BatchTaskAddCollectionResult(IEnumerable<BatchTaskAddResult> value = null)
        {
            value ??= new List<BatchTaskAddResult>();

            return new BatchTaskAddCollectionResult(value?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskAddResult"/>. </summary>
        /// <param name="status"> The status of the add Task request. </param>
        /// <param name="taskId"> The ID of the Task for which this is the result. </param>
        /// <param name="eTag"> The ETag of the Task, if the Task was successfully added. You can use this to detect whether the Task has changed between requests. In particular, you can be pass the ETag with an Update Task request to specify that your changes should take effect only if nobody else has modified the Job in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Task. </param>
        /// <param name="location"> The URL of the Task, if the Task was successfully added. </param>
        /// <param name="error"> The error encountered while attempting to add the Task. </param>
        /// <returns> A new <see cref="Batch.BatchTaskAddResult"/> instance for mocking. </returns>
        public static BatchTaskAddResult BatchTaskAddResult(BatchTaskAddStatus status = default, string taskId = null, string eTag = null, DateTimeOffset? lastModified = null, string location = null, BatchError error = null)
        {
            return new BatchTaskAddResult(
                status,
                taskId,
                eTag,
                lastModified,
                location,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchSubtask"/>. </summary>
        /// <param name="id"> The ID of the subtask. </param>
        /// <param name="nodeInfo"> Information about the Compute Node on which the subtask ran. </param>
        /// <param name="startTime"> The time at which the subtask started running. If the subtask has been restarted or retried, this is the most recent time at which the subtask started running. </param>
        /// <param name="endTime"> The time at which the subtask completed. This property is set only if the subtask is in the Completed state. </param>
        /// <param name="exitCode"> The exit code of the program specified on the subtask command line. This property is set only if the subtask is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the subtask (due to timeout, or user termination via the API) you may see an operating system-defined exit code. </param>
        /// <param name="containerInfo"> Information about the container under which the Task is executing. This property is set only if the Task runs in a container context. </param>
        /// <param name="failureInfo"> Information describing the Task failure, if any. This property is set only if the Task is in the completed state and encountered a failure. </param>
        /// <param name="state"> The current state of the subtask. </param>
        /// <param name="stateTransitionTime"> The time at which the subtask entered its current state. </param>
        /// <param name="previousState"> The previous state of the subtask. This property is not set if the subtask is in its initial running state. </param>
        /// <param name="previousStateTransitionTime"> The time at which the subtask entered its previous state. This property is not set if the subtask is in its initial running state. </param>
        /// <param name="result"> The result of the Task execution. If the value is 'failed', then the details of the failure can be found in the failureInfo property. </param>
        /// <returns> A new <see cref="Batch.BatchSubtask"/> instance for mocking. </returns>
        public static BatchSubtask BatchSubtask(int? id = null, BatchNodeInfo nodeInfo = null, DateTimeOffset? startTime = null, DateTimeOffset? endTime = null, int? exitCode = null, BatchTaskContainerExecutionInfo containerInfo = null, BatchTaskFailureInfo failureInfo = null, BatchSubtaskState? state = null, DateTimeOffset? stateTransitionTime = null, BatchSubtaskState? previousState = null, DateTimeOffset? previousStateTransitionTime = null, BatchTaskExecutionResult? result = null)
        {
            return new BatchSubtask(
                id,
                nodeInfo,
                startTime,
                endTime,
                exitCode,
                containerInfo,
                failureInfo,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeFile"/>. </summary>
        /// <param name="name"> The file path. </param>
        /// <param name="url"> The URL of the file. </param>
        /// <param name="isDirectory"> Whether the object represents a directory. </param>
        /// <param name="properties"> The file properties. </param>
        /// <returns> A new <see cref="Batch.BatchNodeFile"/> instance for mocking. </returns>
        public static BatchNodeFile BatchNodeFile(string name = null, string url = null, bool? isDirectory = null, FileProperties properties = null)
        {
            return new BatchNodeFile(name, url, isDirectory, properties, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.FileProperties"/>. </summary>
        /// <param name="creationTime"> The file creation time. The creation time is not returned for files on Linux Compute Nodes. </param>
        /// <param name="lastModified"> The time at which the file was last modified. </param>
        /// <param name="contentLength"> The length of the file. </param>
        /// <param name="contentType"> The content type of the file. </param>
        /// <param name="fileMode"> The file mode attribute in octal format. The file mode is returned only for files on Linux Compute Nodes. </param>
        /// <returns> A new <see cref="Batch.FileProperties"/> instance for mocking. </returns>
        public static FileProperties FileProperties(DateTimeOffset? creationTime = null, DateTimeOffset lastModified = default, long contentLength = default, string contentType = null, string fileMode = null)
        {
            return new FileProperties(
                creationTime,
                lastModified,
                contentLength,
                contentType,
                fileMode,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeUserCreateContent"/>. </summary>
        /// <param name="name"> The user name of the Account. </param>
        /// <param name="isAdmin"> Whether the Account should be an administrator on the Compute Node. The default value is false. </param>
        /// <param name="expiryTime"> The time at which the Account should expire. If omitted, the default is 1 day from the current time. For Linux Compute Nodes, the expiryTime has a precision up to a day. </param>
        /// <param name="password"> The password of the Account. The password is required for Windows Compute Nodes (those created with 'virtualMachineConfiguration' using a Windows Image reference). For Linux Compute Nodes, the password can optionally be specified along with the sshPublicKey property. </param>
        /// <param name="sshPublicKey"> The SSH public key that can be used for remote login to the Compute Node. The public key should be compatible with OpenSSH encoding and should be base 64 encoded. This property can be specified only for Linux Compute Nodes. If this is specified for a Windows Compute Node, then the Batch service rejects the request; if you are calling the REST API directly, the HTTP status code is 400 (Bad Request). </param>
        /// <returns> A new <see cref="Batch.BatchNodeUserCreateContent"/> instance for mocking. </returns>
        public static BatchNodeUserCreateContent BatchNodeUserCreateContent(string name = null, bool? isAdmin = null, DateTimeOffset? expiryTime = null, string password = null, string sshPublicKey = null)
        {
            return new BatchNodeUserCreateContent(
                name,
                isAdmin,
                expiryTime,
                password,
                sshPublicKey,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNode"/>. </summary>
        /// <param name="id"> The ID of the Compute Node. Every Compute Node that is added to a Pool is assigned a unique ID. Whenever a Compute Node is removed from a Pool, all of its local files are deleted, and the ID is reclaimed and could be reused for new Compute Nodes. </param>
        /// <param name="url"> The URL of the Compute Node. </param>
        /// <param name="state"> The current state of the Compute Node. The Spot/Low-priority Compute Node has been preempted. Tasks which were running on the Compute Node when it was preempted will be rescheduled when another Compute Node becomes available. </param>
        /// <param name="schedulingState"> Whether the Compute Node is available for Task scheduling. </param>
        /// <param name="stateTransitionTime"> The time at which the Compute Node entered its current state. </param>
        /// <param name="lastBootTime"> The last time at which the Compute Node was started. This property may not be present if the Compute Node state is unusable. </param>
        /// <param name="allocationTime"> The time at which this Compute Node was allocated to the Pool. This is the time when the Compute Node was initially allocated and doesn't change once set. It is not updated when the Compute Node is service healed or preempted. </param>
        /// <param name="ipAddress"> The IP address that other Nodes can use to communicate with this Compute Node. Every Compute Node that is added to a Pool is assigned a unique IP address. Whenever a Compute Node is removed from a Pool, all of its local files are deleted, and the IP address is reclaimed and could be reused for new Compute Nodes. </param>
        /// <param name="affinityId"> An identifier which can be passed when adding a Task to request that the Task be scheduled on this Compute Node. Note that this is just a soft affinity. If the target Compute Node is busy or unavailable at the time the Task is scheduled, then the Task will be scheduled elsewhere. </param>
        /// <param name="vmSize"> The size of the virtual machine hosting the Compute Node. For information about available sizes of virtual machines in Pools, see Choose a VM size for Compute Nodes in an Azure Batch Pool (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes). </param>
        /// <param name="totalTasksRun"> The total number of Job Tasks completed on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start Tasks. </param>
        /// <param name="runningTasksCount"> The total number of currently running Job Tasks on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start Tasks. </param>
        /// <param name="runningTaskSlotsCount"> The total number of scheduling slots used by currently running Job Tasks on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start Tasks. </param>
        /// <param name="totalTasksSucceeded"> The total number of Job Tasks which completed successfully (with exitCode 0) on the Compute Node. This includes Job Manager Tasks and normal Tasks, but not Job Preparation, Job Release or Start Tasks. </param>
        /// <param name="recentTasks"> A list of Tasks whose state has recently changed. This property is present only if at least one Task has run on this Compute Node since it was assigned to the Pool. </param>
        /// <param name="startTask"> The Task specified to run on the Compute Node as it joins the Pool. </param>
        /// <param name="startTaskInfo"> Runtime information about the execution of the StartTask on the Compute Node. </param>
        /// <param name="errors"> The list of errors that are currently being encountered by the Compute Node. </param>
        /// <param name="isDedicated"> Whether this Compute Node is a dedicated Compute Node. If false, the Compute Node is a Spot/Low-priority Compute Node. </param>
        /// <param name="endpointConfiguration"> The endpoint configuration for the Compute Node. </param>
        /// <param name="nodeAgentInfo"> Information about the Compute Node agent version and the time the Compute Node upgraded to a new version. </param>
        /// <param name="virtualMachineInfo"> Info about the current state of the virtual machine. </param>
        /// <returns> A new <see cref="Batch.BatchNode"/> instance for mocking. </returns>
        public static BatchNode BatchNode(string id = null, string url = null, BatchNodeState? state = null, SchedulingState? schedulingState = null, DateTimeOffset? stateTransitionTime = null, DateTimeOffset? lastBootTime = null, DateTimeOffset? allocationTime = null, string ipAddress = null, string affinityId = null, string vmSize = null, int? totalTasksRun = null, int? runningTasksCount = null, int? runningTaskSlotsCount = null, int? totalTasksSucceeded = null, IEnumerable<BatchTaskInfo> recentTasks = null, BatchStartTask startTask = null, BatchStartTaskInfo startTaskInfo = null, IEnumerable<BatchNodeError> errors = null, bool? isDedicated = null, BatchNodeEndpointConfiguration endpointConfiguration = null, BatchNodeAgentInfo nodeAgentInfo = null, VirtualMachineInfo virtualMachineInfo = null)
        {
            recentTasks ??= new List<BatchTaskInfo>();
            errors ??= new List<BatchNodeError>();

            return new BatchNode(
                id,
                url,
                state,
                schedulingState,
                stateTransitionTime,
                lastBootTime,
                allocationTime,
                ipAddress,
                affinityId,
                vmSize,
                totalTasksRun,
                runningTasksCount,
                runningTaskSlotsCount,
                totalTasksSucceeded,
                recentTasks?.ToList(),
                startTask,
                startTaskInfo,
                errors?.ToList(),
                isDedicated,
                endpointConfiguration,
                nodeAgentInfo,
                virtualMachineInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchTaskInfo"/>. </summary>
        /// <param name="taskUrl"> The URL of the Task. </param>
        /// <param name="jobId"> The ID of the Job to which the Task belongs. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="subtaskId"> The ID of the subtask if the Task is a multi-instance Task. </param>
        /// <param name="taskState"> The current state of the Task. </param>
        /// <param name="executionInfo"> Information about the execution of the Task. </param>
        /// <returns> A new <see cref="Batch.BatchTaskInfo"/> instance for mocking. </returns>
        public static BatchTaskInfo BatchTaskInfo(string taskUrl = null, string jobId = null, string taskId = null, int? subtaskId = null, BatchTaskState taskState = default, BatchTaskExecutionInfo executionInfo = null)
        {
            return new BatchTaskInfo(
                taskUrl,
                jobId,
                taskId,
                subtaskId,
                taskState,
                executionInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchStartTaskInfo"/>. </summary>
        /// <param name="state"> The state of the StartTask on the Compute Node. </param>
        /// <param name="startTime"> The time at which the StartTask started running. This value is reset every time the Task is restarted or retried (that is, this is the most recent time at which the StartTask started running). </param>
        /// <param name="endTime"> The time at which the StartTask stopped running. This is the end time of the most recent run of the StartTask, if that run has completed (even if that run failed and a retry is pending). This element is not present if the StartTask is currently running. </param>
        /// <param name="exitCode"> The exit code of the program specified on the StartTask command line. This property is set only if the StartTask is in the completed state. In general, the exit code for a process reflects the specific convention implemented by the application developer for that process. If you use the exit code value to make decisions in your code, be sure that you know the exit code convention used by the application process. However, if the Batch service terminates the StartTask (due to timeout, or user termination via the API) you may see an operating system-defined exit code. </param>
        /// <param name="containerInfo"> Information about the container under which the Task is executing. This property is set only if the Task runs in a container context. </param>
        /// <param name="failureInfo"> Information describing the Task failure, if any. This property is set only if the Task is in the completed state and encountered a failure. </param>
        /// <param name="retryCount"> The number of times the Task has been retried by the Batch service. Task application failures (non-zero exit code) are retried, pre-processing errors (the Task could not be run) and file upload errors are not retried. The Batch service will retry the Task up to the limit specified by the constraints. </param>
        /// <param name="lastRetryTime"> The most recent time at which a retry of the Task started running. This element is present only if the Task was retried (i.e. retryCount is nonzero). If present, this is typically the same as startTime, but may be different if the Task has been restarted for reasons other than retry; for example, if the Compute Node was rebooted during a retry, then the startTime is updated but the lastRetryTime is not. </param>
        /// <param name="result"> The result of the Task execution. If the value is 'failed', then the details of the failure can be found in the failureInfo property. </param>
        /// <returns> A new <see cref="Batch.BatchStartTaskInfo"/> instance for mocking. </returns>
        public static BatchStartTaskInfo BatchStartTaskInfo(BatchStartTaskState state = default, DateTimeOffset startTime = default, DateTimeOffset? endTime = null, int? exitCode = null, BatchTaskContainerExecutionInfo containerInfo = null, BatchTaskFailureInfo failureInfo = null, int retryCount = default, DateTimeOffset? lastRetryTime = null, BatchTaskExecutionResult? result = null)
        {
            return new BatchStartTaskInfo(
                state,
                startTime,
                endTime,
                exitCode,
                containerInfo,
                failureInfo,
                retryCount,
                lastRetryTime,
                result,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeError"/>. </summary>
        /// <param name="code"> An identifier for the Compute Node error. Codes are invariant and are intended to be consumed programmatically. </param>
        /// <param name="message"> A message describing the Compute Node error, intended to be suitable for display in a user interface. </param>
        /// <param name="errorDetails"> The list of additional error details related to the Compute Node error. </param>
        /// <returns> A new <see cref="Batch.BatchNodeError"/> instance for mocking. </returns>
        public static BatchNodeError BatchNodeError(string code = null, string message = null, IEnumerable<NameValuePair> errorDetails = null)
        {
            errorDetails ??= new List<NameValuePair>();

            return new BatchNodeError(code, message, errorDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeEndpointConfiguration"/>. </summary>
        /// <param name="inboundEndpoints"> The list of inbound endpoints that are accessible on the Compute Node. </param>
        /// <returns> A new <see cref="Batch.BatchNodeEndpointConfiguration"/> instance for mocking. </returns>
        public static BatchNodeEndpointConfiguration BatchNodeEndpointConfiguration(IEnumerable<InboundEndpoint> inboundEndpoints = null)
        {
            inboundEndpoints ??= new List<InboundEndpoint>();

            return new BatchNodeEndpointConfiguration(inboundEndpoints?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.InboundEndpoint"/>. </summary>
        /// <param name="name"> The name of the endpoint. </param>
        /// <param name="protocol"> The protocol of the endpoint. </param>
        /// <param name="publicIpAddress"> The public IP address of the Compute Node. </param>
        /// <param name="publicFQDN"> The public fully qualified domain name for the Compute Node. </param>
        /// <param name="frontendPort"> The public port number of the endpoint. </param>
        /// <param name="backendPort"> The backend port number of the endpoint. </param>
        /// <returns> A new <see cref="Batch.InboundEndpoint"/> instance for mocking. </returns>
        public static InboundEndpoint InboundEndpoint(string name = null, InboundEndpointProtocol protocol = default, string publicIpAddress = null, string publicFQDN = null, int frontendPort = default, int backendPort = default)
        {
            return new InboundEndpoint(
                name,
                protocol,
                publicIpAddress,
                publicFQDN,
                frontendPort,
                backendPort,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeAgentInfo"/>. </summary>
        /// <param name="version"> The version of the Batch Compute Node agent running on the Compute Node. This version number can be checked against the Compute Node agent release notes located at https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md. </param>
        /// <param name="lastUpdateTime"> The time when the Compute Node agent was updated on the Compute Node. This is the most recent time that the Compute Node agent was updated to a new version. </param>
        /// <returns> A new <see cref="Batch.BatchNodeAgentInfo"/> instance for mocking. </returns>
        public static BatchNodeAgentInfo BatchNodeAgentInfo(string version = null, DateTimeOffset lastUpdateTime = default)
        {
            return new BatchNodeAgentInfo(version, lastUpdateTime, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.VirtualMachineInfo"/>. </summary>
        /// <param name="imageReference"> The reference to the Azure Virtual Machine's Marketplace Image. </param>
        /// <param name="scaleSetVmResourceId"> The resource ID of the Compute Node's current Virtual Machine Scale Set VM. Only defined if the Batch Account was created with its poolAllocationMode property set to 'UserSubscription'. </param>
        /// <returns> A new <see cref="Batch.VirtualMachineInfo"/> instance for mocking. </returns>
        public static VirtualMachineInfo VirtualMachineInfo(ImageReference imageReference = null, string scaleSetVmResourceId = null)
        {
            return new VirtualMachineInfo(imageReference, scaleSetVmResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeRemoteLoginSettings"/>. </summary>
        /// <param name="remoteLoginIpAddress"> The IP address used for remote login to the Compute Node. </param>
        /// <param name="remoteLoginPort"> The port used for remote login to the Compute Node. </param>
        /// <returns> A new <see cref="Batch.BatchNodeRemoteLoginSettings"/> instance for mocking. </returns>
        public static BatchNodeRemoteLoginSettings BatchNodeRemoteLoginSettings(string remoteLoginIpAddress = null, int remoteLoginPort = default)
        {
            return new BatchNodeRemoteLoginSettings(remoteLoginIpAddress, remoteLoginPort, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.UploadBatchServiceLogsContent"/>. </summary>
        /// <param name="containerUrl"> The URL of the container within Azure Blob Storage to which to upload the Batch Service log file(s). If a user assigned managed identity is not being used, the URL must include a Shared Access Signature (SAS) granting write permissions to the container. The SAS duration must allow enough time for the upload to finish. The start time for SAS is optional and recommended to not be specified. </param>
        /// <param name="startTime"> The start of the time range from which to upload Batch Service log file(s). Any log file containing a log message in the time range will be uploaded. This means that the operation might retrieve more logs than have been requested since the entire log file is always uploaded, but the operation should not retrieve fewer logs than have been requested. </param>
        /// <param name="endTime"> The end of the time range from which to upload Batch Service log file(s). Any log file containing a log message in the time range will be uploaded. This means that the operation might retrieve more logs than have been requested since the entire log file is always uploaded, but the operation should not retrieve fewer logs than have been requested. If omitted, the default is to upload all logs available after the startTime. </param>
        /// <param name="identityReference"> The reference to the user assigned identity to use to access Azure Blob Storage specified by containerUrl. The identity must have write access to the Azure Blob Storage container. </param>
        /// <returns> A new <see cref="Batch.UploadBatchServiceLogsContent"/> instance for mocking. </returns>
        public static UploadBatchServiceLogsContent UploadBatchServiceLogsContent(string containerUrl = null, DateTimeOffset startTime = default, DateTimeOffset? endTime = null, BatchNodeIdentityReference identityReference = null)
        {
            return new UploadBatchServiceLogsContent(containerUrl, startTime, endTime, identityReference, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.UploadBatchServiceLogsResult"/>. </summary>
        /// <param name="virtualDirectoryName"> The virtual directory within Azure Blob Storage container to which the Batch Service log file(s) will be uploaded. The virtual directory name is part of the blob name for each log file uploaded, and it is built based poolId, nodeId and a unique identifier. </param>
        /// <param name="numberOfFilesUploaded"> The number of log files which will be uploaded. </param>
        /// <returns> A new <see cref="Batch.UploadBatchServiceLogsResult"/> instance for mocking. </returns>
        public static UploadBatchServiceLogsResult UploadBatchServiceLogsResult(string virtualDirectoryName = null, int numberOfFilesUploaded = default)
        {
            return new UploadBatchServiceLogsResult(virtualDirectoryName, numberOfFilesUploaded, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.BatchNodeVMExtension"/>. </summary>
        /// <param name="provisioningState"> The provisioning state of the virtual machine extension. </param>
        /// <param name="vmExtension"> The virtual machine extension. </param>
        /// <param name="instanceView"> The vm extension instance view. </param>
        /// <returns> A new <see cref="Batch.BatchNodeVMExtension"/> instance for mocking. </returns>
        public static BatchNodeVMExtension BatchNodeVMExtension(string provisioningState = null, VMExtension vmExtension = null, VMExtensionInstanceView instanceView = null)
        {
            return new BatchNodeVMExtension(provisioningState, vmExtension, instanceView, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.VMExtensionInstanceView"/>. </summary>
        /// <param name="name"> The name of the vm extension instance view. </param>
        /// <param name="statuses"> The resource status information. </param>
        /// <param name="subStatuses"> The resource status information. </param>
        /// <returns> A new <see cref="Batch.VMExtensionInstanceView"/> instance for mocking. </returns>
        public static VMExtensionInstanceView VMExtensionInstanceView(string name = null, IEnumerable<InstanceViewStatus> statuses = null, IEnumerable<InstanceViewStatus> subStatuses = null)
        {
            statuses ??= new List<InstanceViewStatus>();
            subStatuses ??= new List<InstanceViewStatus>();

            return new VMExtensionInstanceView(name, statuses?.ToList(), subStatuses?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Batch.InstanceViewStatus"/>. </summary>
        /// <param name="code"> The status code. </param>
        /// <param name="displayStatus"> The localized label for the status. </param>
        /// <param name="level"> Level code. </param>
        /// <param name="message"> The detailed status message. </param>
        /// <param name="time"> The time of the status. </param>
        /// <returns> A new <see cref="Batch.InstanceViewStatus"/> instance for mocking. </returns>
        public static InstanceViewStatus InstanceViewStatus(string code = null, string displayStatus = null, StatusLevelTypes? level = null, string message = null, DateTimeOffset? time = null)
        {
            return new InstanceViewStatus(
                code,
                displayStatus,
                level,
                message,
                time,
                serializedAdditionalRawData: null);
        }
    }
}
