// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> CachingType enums. </summary>
    public readonly partial struct CachingType : IEquatable<CachingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CachingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CachingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string ReadOnlyValue = "readonly";
        private const string ReadWriteValue = "readwrite";

        /// <summary> The caching mode for the disk is not enabled. </summary>
        public static CachingType None { get; } = new CachingType(NoneValue);
        /// <summary> The caching mode for the disk is read only. </summary>
        public static CachingType ReadOnly { get; } = new CachingType(ReadOnlyValue);
        /// <summary> The caching mode for the disk is read and write. </summary>
        public static CachingType ReadWrite { get; } = new CachingType(ReadWriteValue);
        /// <summary> Determines if two <see cref="CachingType"/> values are the same. </summary>
        public static bool operator ==(CachingType left, CachingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CachingType"/> values are not the same. </summary>
        public static bool operator !=(CachingType left, CachingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CachingType"/>. </summary>
        public static implicit operator CachingType(string value) => new CachingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CachingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CachingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
