// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchTaskStatistics : IUtf8JsonSerializable, IJsonModel<BatchTaskStatistics>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchTaskStatistics>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchTaskStatistics>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTaskStatistics>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchTaskStatistics)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("url"u8);
            writer.WriteStringValue(Url);
            writer.WritePropertyName("startTime"u8);
            writer.WriteStringValue(StartTime, "O");
            writer.WritePropertyName("lastUpdateTime"u8);
            writer.WriteStringValue(LastUpdateTime, "O");
            writer.WritePropertyName("userCPUTime"u8);
            writer.WriteStringValue(UserCpuTime, "P");
            writer.WritePropertyName("kernelCPUTime"u8);
            writer.WriteStringValue(KernelCpuTime, "P");
            writer.WritePropertyName("wallClockTime"u8);
            writer.WriteStringValue(WallClockTime, "P");
            writer.WritePropertyName("readIOps"u8);
            writer.WriteNumberValue(ReadIOps);
            writer.WritePropertyName("writeIOps"u8);
            writer.WriteNumberValue(WriteIOps);
            writer.WritePropertyName("readIOGiB"u8);
            writer.WriteNumberValue(ReadIOGiB);
            writer.WritePropertyName("writeIOGiB"u8);
            writer.WriteNumberValue(WriteIOGiB);
            writer.WritePropertyName("waitTime"u8);
            writer.WriteStringValue(WaitTime, "P");
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchTaskStatistics IJsonModel<BatchTaskStatistics>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTaskStatistics>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchTaskStatistics)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchTaskStatistics(document.RootElement, options);
        }

        internal static BatchTaskStatistics DeserializeBatchTaskStatistics(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string url = default;
            DateTimeOffset startTime = default;
            DateTimeOffset lastUpdateTime = default;
            TimeSpan userCPUTime = default;
            TimeSpan kernelCPUTime = default;
            TimeSpan wallClockTime = default;
            long readIOps = default;
            long writeIOps = default;
            float readIOGiB = default;
            float writeIOGiB = default;
            TimeSpan waitTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("url"u8))
                {
                    url = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastUpdateTime"u8))
                {
                    lastUpdateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("userCPUTime"u8))
                {
                    userCPUTime = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("kernelCPUTime"u8))
                {
                    kernelCPUTime = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("wallClockTime"u8))
                {
                    wallClockTime = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("readIOps"u8))
                {
                    readIOps = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("writeIOps"u8))
                {
                    writeIOps = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("readIOGiB"u8))
                {
                    readIOGiB = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("writeIOGiB"u8))
                {
                    writeIOGiB = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("waitTime"u8))
                {
                    waitTime = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchTaskStatistics(
                url,
                startTime,
                lastUpdateTime,
                userCPUTime,
                kernelCPUTime,
                wallClockTime,
                readIOps,
                writeIOps,
                readIOGiB,
                writeIOGiB,
                waitTime,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchTaskStatistics>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTaskStatistics>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchTaskStatistics)} does not support writing '{options.Format}' format.");
            }
        }

        BatchTaskStatistics IPersistableModel<BatchTaskStatistics>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTaskStatistics>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchTaskStatistics(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchTaskStatistics)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchTaskStatistics>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchTaskStatistics FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchTaskStatistics(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
