// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Information about a Task running on a Compute Node. </summary>
    public partial class BatchTaskInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchTaskInfo"/>. </summary>
        /// <param name="taskState"> The current state of the Task. </param>
        internal BatchTaskInfo(BatchTaskState taskState)
        {
            TaskState = taskState;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskInfo"/>. </summary>
        /// <param name="taskUrl"> The URL of the Task. </param>
        /// <param name="jobId"> The ID of the Job to which the Task belongs. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="subtaskId"> The ID of the subtask if the Task is a multi-instance Task. </param>
        /// <param name="taskState"> The current state of the Task. </param>
        /// <param name="executionInfo"> Information about the execution of the Task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchTaskInfo(string taskUrl, string jobId, string taskId, int? subtaskId, BatchTaskState taskState, BatchTaskExecutionInfo executionInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskUrl = taskUrl;
            JobId = jobId;
            TaskId = taskId;
            SubtaskId = subtaskId;
            TaskState = taskState;
            ExecutionInfo = executionInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskInfo"/> for deserialization. </summary>
        internal BatchTaskInfo()
        {
        }

        /// <summary> The URL of the Task. </summary>
        public string TaskUrl { get; }
        /// <summary> The ID of the Job to which the Task belongs. </summary>
        public string JobId { get; }
        /// <summary> The ID of the Task. </summary>
        public string TaskId { get; }
        /// <summary> The ID of the subtask if the Task is a multi-instance Task. </summary>
        public int? SubtaskId { get; }
        /// <summary> The current state of the Task. </summary>
        public BatchTaskState TaskState { get; }
        /// <summary> Information about the execution of the Task. </summary>
        public BatchTaskExecutionInfo ExecutionInfo { get; }
    }
}
