// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The Task and TaskSlot counts for a Job. </summary>
    public partial class BatchTaskCountsResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchTaskCountsResult"/>. </summary>
        /// <param name="taskCounts"> The number of Tasks per state. </param>
        /// <param name="taskSlotCounts"> The number of TaskSlots required by Tasks per state. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="taskCounts"/> or <paramref name="taskSlotCounts"/> is null. </exception>
        internal BatchTaskCountsResult(BatchTaskCounts taskCounts, BatchTaskSlotCounts taskSlotCounts)
        {
            Argument.AssertNotNull(taskCounts, nameof(taskCounts));
            Argument.AssertNotNull(taskSlotCounts, nameof(taskSlotCounts));

            TaskCounts = taskCounts;
            TaskSlotCounts = taskSlotCounts;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskCountsResult"/>. </summary>
        /// <param name="taskCounts"> The number of Tasks per state. </param>
        /// <param name="taskSlotCounts"> The number of TaskSlots required by Tasks per state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchTaskCountsResult(BatchTaskCounts taskCounts, BatchTaskSlotCounts taskSlotCounts, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TaskCounts = taskCounts;
            TaskSlotCounts = taskSlotCounts;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskCountsResult"/> for deserialization. </summary>
        internal BatchTaskCountsResult()
        {
        }

        /// <summary> The number of Tasks per state. </summary>
        public BatchTaskCounts TaskCounts { get; }
        /// <summary> The number of TaskSlots required by Tasks per state. </summary>
        public BatchTaskSlotCounts TaskSlotCounts { get; }
    }
}
