// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The container settings for a Task. </summary>
    public partial class BatchTaskContainerSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchTaskContainerSettings"/>. </summary>
        /// <param name="imageName"> The Image to use to create the container in which the Task will run. This is the full Image reference, as would be specified to "docker pull". If no tag is provided as part of the Image name, the tag ":latest" is used as a default. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="imageName"/> is null. </exception>
        public BatchTaskContainerSettings(string imageName)
        {
            Argument.AssertNotNull(imageName, nameof(imageName));

            ImageName = imageName;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskContainerSettings"/>. </summary>
        /// <param name="containerRunOptions"> Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service. </param>
        /// <param name="imageName"> The Image to use to create the container in which the Task will run. This is the full Image reference, as would be specified to "docker pull". If no tag is provided as part of the Image name, the tag ":latest" is used as a default. </param>
        /// <param name="registry"> The private registry which contains the container Image. This setting can be omitted if was already provided at Pool creation. </param>
        /// <param name="workingDirectory"> The location of the container Task working directory. The default is 'taskWorkingDirectory'. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchTaskContainerSettings(string containerRunOptions, string imageName, ContainerRegistryReference registry, ContainerWorkingDirectory? workingDirectory, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ContainerRunOptions = containerRunOptions;
            ImageName = imageName;
            Registry = registry;
            WorkingDirectory = workingDirectory;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskContainerSettings"/> for deserialization. </summary>
        internal BatchTaskContainerSettings()
        {
        }

        /// <summary> Additional options to the container create command. These additional options are supplied as arguments to the "docker create" command, in addition to those controlled by the Batch Service. </summary>
        public string ContainerRunOptions { get; set; }
        /// <summary> The Image to use to create the container in which the Task will run. This is the full Image reference, as would be specified to "docker pull". If no tag is provided as part of the Image name, the tag ":latest" is used as a default. </summary>
        public string ImageName { get; set; }
        /// <summary> The private registry which contains the container Image. This setting can be omitted if was already provided at Pool creation. </summary>
        public ContainerRegistryReference Registry { get; set; }
        /// <summary> The location of the container Task working directory. The default is 'taskWorkingDirectory'. </summary>
        public ContainerWorkingDirectory? WorkingDirectory { get; set; }
    }
}
