// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchTaskAddStatus enums. </summary>
    public readonly partial struct BatchTaskAddStatus : IEquatable<BatchTaskAddStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchTaskAddStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchTaskAddStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "success";
        private const string ClientErrorValue = "clienterror";
        private const string ServerErrorValue = "servererror";

        /// <summary> The Task was added successfully. </summary>
        public static BatchTaskAddStatus Success { get; } = new BatchTaskAddStatus(SuccessValue);
        /// <summary> The Task failed to add due to a client error and should not be retried without modifying the request as appropriate. </summary>
        public static BatchTaskAddStatus ClientError { get; } = new BatchTaskAddStatus(ClientErrorValue);
        /// <summary> Task failed to add due to a server error and can be retried without modification. </summary>
        public static BatchTaskAddStatus ServerError { get; } = new BatchTaskAddStatus(ServerErrorValue);
        /// <summary> Determines if two <see cref="BatchTaskAddStatus"/> values are the same. </summary>
        public static bool operator ==(BatchTaskAddStatus left, BatchTaskAddStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchTaskAddStatus"/> values are not the same. </summary>
        public static bool operator !=(BatchTaskAddStatus left, BatchTaskAddStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchTaskAddStatus"/>. </summary>
        public static implicit operator BatchTaskAddStatus(string value) => new BatchTaskAddStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchTaskAddStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchTaskAddStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
