// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Result for a single Task added as part of an add Task collection operation. </summary>
    public partial class BatchTaskAddResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchTaskAddResult"/>. </summary>
        /// <param name="status"> The status of the add Task request. </param>
        /// <param name="taskId"> The ID of the Task for which this is the result. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="taskId"/> is null. </exception>
        internal BatchTaskAddResult(BatchTaskAddStatus status, string taskId)
        {
            Argument.AssertNotNull(taskId, nameof(taskId));

            Status = status;
            TaskId = taskId;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskAddResult"/>. </summary>
        /// <param name="status"> The status of the add Task request. </param>
        /// <param name="taskId"> The ID of the Task for which this is the result. </param>
        /// <param name="eTag"> The ETag of the Task, if the Task was successfully added. You can use this to detect whether the Task has changed between requests. In particular, you can be pass the ETag with an Update Task request to specify that your changes should take effect only if nobody else has modified the Job in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Task. </param>
        /// <param name="location"> The URL of the Task, if the Task was successfully added. </param>
        /// <param name="error"> The error encountered while attempting to add the Task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchTaskAddResult(BatchTaskAddStatus status, string taskId, string eTag, DateTimeOffset? lastModified, string location, BatchError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            TaskId = taskId;
            ETag = eTag;
            LastModified = lastModified;
            Location = location;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchTaskAddResult"/> for deserialization. </summary>
        internal BatchTaskAddResult()
        {
        }

        /// <summary> The status of the add Task request. </summary>
        public BatchTaskAddStatus Status { get; }
        /// <summary> The ID of the Task for which this is the result. </summary>
        public string TaskId { get; }
        /// <summary> The ETag of the Task, if the Task was successfully added. You can use this to detect whether the Task has changed between requests. In particular, you can be pass the ETag with an Update Task request to specify that your changes should take effect only if nobody else has modified the Job in the meantime. </summary>
        public string ETag { get; }
        /// <summary> The last modified time of the Task. </summary>
        public DateTimeOffset? LastModified { get; }
        /// <summary> The URL of the Task, if the Task was successfully added. </summary>
        public string Location { get; }
        /// <summary> The error encountered while attempting to add the Task. </summary>
        public BatchError Error { get; }
    }
}
