// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchTask : IUtf8JsonSerializable, IJsonModel<BatchTask>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchTask>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchTask>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTask>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchTask)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url);
            }
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("eTag"u8);
                writer.WriteStringValue(ETag);
            }
            if (options.Format != "W" && Optional.IsDefined(LastModified))
            {
                writer.WritePropertyName("lastModified"u8);
                writer.WriteStringValue(LastModified.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CreationTime))
            {
                writer.WritePropertyName("creationTime"u8);
                writer.WriteStringValue(CreationTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ExitConditions))
            {
                writer.WritePropertyName("exitConditions"u8);
                writer.WriteObjectValue(ExitConditions, options);
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StateTransitionTime))
            {
                writer.WritePropertyName("stateTransitionTime"u8);
                writer.WriteStringValue(StateTransitionTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(PreviousState))
            {
                writer.WritePropertyName("previousState"u8);
                writer.WriteStringValue(PreviousState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PreviousStateTransitionTime))
            {
                writer.WritePropertyName("previousStateTransitionTime"u8);
                writer.WriteStringValue(PreviousStateTransitionTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CommandLine))
            {
                writer.WritePropertyName("commandLine"u8);
                writer.WriteStringValue(CommandLine);
            }
            if (options.Format != "W" && Optional.IsDefined(ContainerSettings))
            {
                writer.WritePropertyName("containerSettings"u8);
                writer.WriteObjectValue(ContainerSettings, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceFiles))
            {
                writer.WritePropertyName("resourceFiles"u8);
                writer.WriteStartArray();
                foreach (var item in ResourceFiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(OutputFiles))
            {
                writer.WritePropertyName("outputFiles"u8);
                writer.WriteStartArray();
                foreach (var item in OutputFiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(EnvironmentSettings))
            {
                writer.WritePropertyName("environmentSettings"u8);
                writer.WriteStartArray();
                foreach (var item in EnvironmentSettings)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(AffinityInfo))
            {
                writer.WritePropertyName("affinityInfo"u8);
                writer.WriteObjectValue(AffinityInfo, options);
            }
            if (Optional.IsDefined(Constraints))
            {
                writer.WritePropertyName("constraints"u8);
                writer.WriteObjectValue(Constraints, options);
            }
            if (options.Format != "W" && Optional.IsDefined(RequiredSlots))
            {
                writer.WritePropertyName("requiredSlots"u8);
                writer.WriteNumberValue(RequiredSlots.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(UserIdentity))
            {
                writer.WritePropertyName("userIdentity"u8);
                writer.WriteObjectValue(UserIdentity, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ExecutionInfo))
            {
                writer.WritePropertyName("executionInfo"u8);
                writer.WriteObjectValue(ExecutionInfo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(NodeInfo))
            {
                writer.WritePropertyName("nodeInfo"u8);
                writer.WriteObjectValue(NodeInfo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(MultiInstanceSettings))
            {
                writer.WritePropertyName("multiInstanceSettings"u8);
                writer.WriteObjectValue(MultiInstanceSettings, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Stats))
            {
                writer.WritePropertyName("stats"u8);
                writer.WriteObjectValue(Stats, options);
            }
            if (options.Format != "W" && Optional.IsDefined(DependsOn))
            {
                writer.WritePropertyName("dependsOn"u8);
                writer.WriteObjectValue(DependsOn, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ApplicationPackageReferences))
            {
                writer.WritePropertyName("applicationPackageReferences"u8);
                writer.WriteStartArray();
                foreach (var item in ApplicationPackageReferences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(AuthenticationTokenSettings))
            {
                writer.WritePropertyName("authenticationTokenSettings"u8);
                writer.WriteObjectValue(AuthenticationTokenSettings, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchTask IJsonModel<BatchTask>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTask>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchTask)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchTask(document.RootElement, options);
        }

        internal static BatchTask DeserializeBatchTask(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string displayName = default;
            string url = default;
            string eTag = default;
            DateTimeOffset? lastModified = default;
            DateTimeOffset? creationTime = default;
            ExitConditions exitConditions = default;
            BatchTaskState? state = default;
            DateTimeOffset? stateTransitionTime = default;
            BatchTaskState? previousState = default;
            DateTimeOffset? previousStateTransitionTime = default;
            string commandLine = default;
            BatchTaskContainerSettings containerSettings = default;
            IReadOnlyList<ResourceFile> resourceFiles = default;
            IReadOnlyList<OutputFile> outputFiles = default;
            IReadOnlyList<EnvironmentSetting> environmentSettings = default;
            AffinityInfo affinityInfo = default;
            BatchTaskConstraints constraints = default;
            int? requiredSlots = default;
            UserIdentity userIdentity = default;
            BatchTaskExecutionInfo executionInfo = default;
            BatchNodeInfo nodeInfo = default;
            MultiInstanceSettings multiInstanceSettings = default;
            BatchTaskStatistics stats = default;
            BatchTaskDependencies dependsOn = default;
            IReadOnlyList<BatchApplicationPackageReference> applicationPackageReferences = default;
            AuthenticationTokenSettings authenticationTokenSettings = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    url = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eTag"u8))
                {
                    eTag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastModified"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastModified = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("creationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("exitConditions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    exitConditions = ExitConditions.DeserializeExitConditions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new BatchTaskState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("previousState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    previousState = new BatchTaskState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("previousStateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    previousStateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("commandLine"u8))
                {
                    commandLine = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("containerSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    containerSettings = BatchTaskContainerSettings.DeserializeBatchTaskContainerSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("resourceFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResourceFile> array = new List<ResourceFile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResourceFile.DeserializeResourceFile(item, options));
                    }
                    resourceFiles = array;
                    continue;
                }
                if (property.NameEquals("outputFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<OutputFile> array = new List<OutputFile>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(OutputFile.DeserializeOutputFile(item, options));
                    }
                    outputFiles = array;
                    continue;
                }
                if (property.NameEquals("environmentSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EnvironmentSetting> array = new List<EnvironmentSetting>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EnvironmentSetting.DeserializeEnvironmentSetting(item, options));
                    }
                    environmentSettings = array;
                    continue;
                }
                if (property.NameEquals("affinityInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    affinityInfo = AffinityInfo.DeserializeAffinityInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("constraints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    constraints = BatchTaskConstraints.DeserializeBatchTaskConstraints(property.Value, options);
                    continue;
                }
                if (property.NameEquals("requiredSlots"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    requiredSlots = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("userIdentity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    userIdentity = UserIdentity.DeserializeUserIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("executionInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executionInfo = BatchTaskExecutionInfo.DeserializeBatchTaskExecutionInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("nodeInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nodeInfo = BatchNodeInfo.DeserializeBatchNodeInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("multiInstanceSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    multiInstanceSettings = MultiInstanceSettings.DeserializeMultiInstanceSettings(property.Value, options);
                    continue;
                }
                if (property.NameEquals("stats"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stats = BatchTaskStatistics.DeserializeBatchTaskStatistics(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dependsOn"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dependsOn = BatchTaskDependencies.DeserializeBatchTaskDependencies(property.Value, options);
                    continue;
                }
                if (property.NameEquals("applicationPackageReferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchApplicationPackageReference> array = new List<BatchApplicationPackageReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchApplicationPackageReference.DeserializeBatchApplicationPackageReference(item, options));
                    }
                    applicationPackageReferences = array;
                    continue;
                }
                if (property.NameEquals("authenticationTokenSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authenticationTokenSettings = AuthenticationTokenSettings.DeserializeAuthenticationTokenSettings(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchTask(
                id,
                displayName,
                url,
                eTag,
                lastModified,
                creationTime,
                exitConditions,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                commandLine,
                containerSettings,
                resourceFiles ?? new ChangeTrackingList<ResourceFile>(),
                outputFiles ?? new ChangeTrackingList<OutputFile>(),
                environmentSettings ?? new ChangeTrackingList<EnvironmentSetting>(),
                affinityInfo,
                constraints,
                requiredSlots,
                userIdentity,
                executionInfo,
                nodeInfo,
                multiInstanceSettings,
                stats,
                dependsOn,
                applicationPackageReferences ?? new ChangeTrackingList<BatchApplicationPackageReference>(),
                authenticationTokenSettings,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchTask>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTask>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchTask)} does not support writing '{options.Format}' format.");
            }
        }

        BatchTask IPersistableModel<BatchTask>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchTask>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchTask(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchTask)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchTask>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchTask FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchTask(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
