// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// A reference to the Azure Virtual Machines Marketplace Image and additional
    /// information about the Image.
    /// </summary>
    public partial class BatchSupportedImage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchSupportedImage"/>. </summary>
        /// <param name="nodeAgentSkuId"> The ID of the Compute Node agent SKU which the Image supports. </param>
        /// <param name="imageReference"> The reference to the Azure Virtual Machine's Marketplace Image. </param>
        /// <param name="osType"> The type of operating system (e.g. Windows or Linux) of the Image. </param>
        /// <param name="verificationType"> Whether the Azure Batch service actively verifies that the Image is compatible with the associated Compute Node agent SKU. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nodeAgentSkuId"/> or <paramref name="imageReference"/> is null. </exception>
        internal BatchSupportedImage(string nodeAgentSkuId, ImageReference imageReference, OSType osType, ImageVerificationType verificationType)
        {
            Argument.AssertNotNull(nodeAgentSkuId, nameof(nodeAgentSkuId));
            Argument.AssertNotNull(imageReference, nameof(imageReference));

            NodeAgentSkuId = nodeAgentSkuId;
            ImageReference = imageReference;
            OsType = osType;
            Capabilities = new ChangeTrackingList<string>();
            VerificationType = verificationType;
        }

        /// <summary> Initializes a new instance of <see cref="BatchSupportedImage"/>. </summary>
        /// <param name="nodeAgentSkuId"> The ID of the Compute Node agent SKU which the Image supports. </param>
        /// <param name="imageReference"> The reference to the Azure Virtual Machine's Marketplace Image. </param>
        /// <param name="osType"> The type of operating system (e.g. Windows or Linux) of the Image. </param>
        /// <param name="capabilities"> The capabilities or features which the Image supports. Not every capability of the Image is listed. Capabilities in this list are considered of special interest and are generally related to integration with other features in the Azure Batch service. </param>
        /// <param name="batchSupportEndOfLife"> The time when the Azure Batch service will stop accepting create Pool requests for the Image. </param>
        /// <param name="verificationType"> Whether the Azure Batch service actively verifies that the Image is compatible with the associated Compute Node agent SKU. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchSupportedImage(string nodeAgentSkuId, ImageReference imageReference, OSType osType, IReadOnlyList<string> capabilities, DateTimeOffset? batchSupportEndOfLife, ImageVerificationType verificationType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NodeAgentSkuId = nodeAgentSkuId;
            ImageReference = imageReference;
            OsType = osType;
            Capabilities = capabilities;
            BatchSupportEndOfLife = batchSupportEndOfLife;
            VerificationType = verificationType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchSupportedImage"/> for deserialization. </summary>
        internal BatchSupportedImage()
        {
        }

        /// <summary> The ID of the Compute Node agent SKU which the Image supports. </summary>
        public string NodeAgentSkuId { get; }
        /// <summary> The reference to the Azure Virtual Machine's Marketplace Image. </summary>
        public ImageReference ImageReference { get; }
        /// <summary> The type of operating system (e.g. Windows or Linux) of the Image. </summary>
        public OSType OsType { get; }
        /// <summary> The capabilities or features which the Image supports. Not every capability of the Image is listed. Capabilities in this list are considered of special interest and are generally related to integration with other features in the Azure Batch service. </summary>
        public IReadOnlyList<string> Capabilities { get; }
        /// <summary> The time when the Azure Batch service will stop accepting create Pool requests for the Image. </summary>
        public DateTimeOffset? BatchSupportEndOfLife { get; }
        /// <summary> Whether the Azure Batch service actively verifies that the Image is compatible with the associated Compute Node agent SKU. </summary>
        public ImageVerificationType VerificationType { get; }
    }
}
