// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchSupportedImage : IUtf8JsonSerializable, IJsonModel<BatchSupportedImage>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchSupportedImage>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchSupportedImage>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchSupportedImage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchSupportedImage)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("nodeAgentSKUId"u8);
            writer.WriteStringValue(NodeAgentSkuId);
            writer.WritePropertyName("imageReference"u8);
            writer.WriteObjectValue(ImageReference, options);
            writer.WritePropertyName("osType"u8);
            writer.WriteStringValue(OsType.ToString());
            if (Optional.IsCollectionDefined(Capabilities))
            {
                writer.WritePropertyName("capabilities"u8);
                writer.WriteStartArray();
                foreach (var item in Capabilities)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(BatchSupportEndOfLife))
            {
                writer.WritePropertyName("batchSupportEndOfLife"u8);
                writer.WriteStringValue(BatchSupportEndOfLife.Value, "O");
            }
            writer.WritePropertyName("verificationType"u8);
            writer.WriteStringValue(VerificationType.ToString());
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchSupportedImage IJsonModel<BatchSupportedImage>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchSupportedImage>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchSupportedImage)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchSupportedImage(document.RootElement, options);
        }

        internal static BatchSupportedImage DeserializeBatchSupportedImage(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string nodeAgentSKUId = default;
            ImageReference imageReference = default;
            OSType osType = default;
            IReadOnlyList<string> capabilities = default;
            DateTimeOffset? batchSupportEndOfLife = default;
            ImageVerificationType verificationType = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("nodeAgentSKUId"u8))
                {
                    nodeAgentSKUId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("imageReference"u8))
                {
                    imageReference = ImageReference.DeserializeImageReference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("osType"u8))
                {
                    osType = new OSType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("capabilities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    capabilities = array;
                    continue;
                }
                if (property.NameEquals("batchSupportEndOfLife"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    batchSupportEndOfLife = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("verificationType"u8))
                {
                    verificationType = new ImageVerificationType(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchSupportedImage(
                nodeAgentSKUId,
                imageReference,
                osType,
                capabilities ?? new ChangeTrackingList<string>(),
                batchSupportEndOfLife,
                verificationType,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchSupportedImage>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchSupportedImage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchSupportedImage)} does not support writing '{options.Format}' format.");
            }
        }

        BatchSupportedImage IPersistableModel<BatchSupportedImage>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchSupportedImage>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchSupportedImage(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchSupportedImage)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchSupportedImage>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchSupportedImage FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchSupportedImage(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
