// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchSubtaskState enums. </summary>
    public readonly partial struct BatchSubtaskState : IEquatable<BatchSubtaskState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchSubtaskState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchSubtaskState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PreparingValue = "preparing";
        private const string RunningValue = "running";
        private const string CompletedValue = "completed";

        /// <summary> The Task has been assigned to a Compute Node, but is waiting for a required Job Preparation Task to complete on the Compute Node. If the Job Preparation Task succeeds, the Task will move to running. If the Job Preparation Task fails, the Task will return to active and will be eligible to be assigned to a different Compute Node. </summary>
        public static BatchSubtaskState Preparing { get; } = new BatchSubtaskState(PreparingValue);
        /// <summary> The Task is running on a Compute Node. This includes task-level preparation such as downloading resource files or deploying Packages specified on the Task - it does not necessarily mean that the Task command line has started executing. </summary>
        public static BatchSubtaskState Running { get; } = new BatchSubtaskState(RunningValue);
        /// <summary> The Task is no longer eligible to run, usually because the Task has finished successfully, or the Task has finished unsuccessfully and has exhausted its retry limit. A Task is also marked as completed if an error occurred launching the Task, or when the Task has been terminated. </summary>
        public static BatchSubtaskState Completed { get; } = new BatchSubtaskState(CompletedValue);
        /// <summary> Determines if two <see cref="BatchSubtaskState"/> values are the same. </summary>
        public static bool operator ==(BatchSubtaskState left, BatchSubtaskState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchSubtaskState"/> values are not the same. </summary>
        public static bool operator !=(BatchSubtaskState left, BatchSubtaskState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchSubtaskState"/>. </summary>
        public static implicit operator BatchSubtaskState(string value) => new BatchSubtaskState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchSubtaskState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchSubtaskState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
