// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchStartTaskState enums. </summary>
    public readonly partial struct BatchStartTaskState : IEquatable<BatchStartTaskState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchStartTaskState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchStartTaskState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "running";
        private const string CompletedValue = "completed";

        /// <summary> The StartTask is currently running. </summary>
        public static BatchStartTaskState Running { get; } = new BatchStartTaskState(RunningValue);
        /// <summary> The StartTask has exited with exit code 0, or the StartTask has failed and the retry limit has reached, or the StartTask process did not run due to Task preparation errors (such as resource file download failures). </summary>
        public static BatchStartTaskState Completed { get; } = new BatchStartTaskState(CompletedValue);
        /// <summary> Determines if two <see cref="BatchStartTaskState"/> values are the same. </summary>
        public static bool operator ==(BatchStartTaskState left, BatchStartTaskState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchStartTaskState"/> values are not the same. </summary>
        public static bool operator !=(BatchStartTaskState left, BatchStartTaskState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchStartTaskState"/>. </summary>
        public static implicit operator BatchStartTaskState(string value) => new BatchStartTaskState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchStartTaskState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchStartTaskState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
