// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Contains utilization and resource usage statistics for the lifetime of a Pool. </summary>
    public partial class BatchPoolStatistics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchPoolStatistics"/>. </summary>
        /// <param name="url"> The URL for the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/> is null. </exception>
        internal BatchPoolStatistics(string url, DateTimeOffset startTime, DateTimeOffset lastUpdateTime)
        {
            Argument.AssertNotNull(url, nameof(url));

            Url = url;
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
        }

        /// <summary> Initializes a new instance of <see cref="BatchPoolStatistics"/>. </summary>
        /// <param name="url"> The URL for the statistics. </param>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="usageStats"> Statistics related to Pool usage, such as the amount of core-time used. </param>
        /// <param name="resourceStats"> Statistics related to resource consumption by Compute Nodes in the Pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchPoolStatistics(string url, DateTimeOffset startTime, DateTimeOffset lastUpdateTime, BatchPoolUsageStatistics usageStats, BatchPoolResourceStatistics resourceStats, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Url = url;
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
            UsageStats = usageStats;
            ResourceStats = resourceStats;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchPoolStatistics"/> for deserialization. </summary>
        internal BatchPoolStatistics()
        {
        }

        /// <summary> The URL for the statistics. </summary>
        public string Url { get; }
        /// <summary> The start time of the time range covered by the statistics. </summary>
        public DateTimeOffset StartTime { get; }
        /// <summary> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </summary>
        public DateTimeOffset LastUpdateTime { get; }
        /// <summary> Statistics related to Pool usage, such as the amount of core-time used. </summary>
        public BatchPoolUsageStatistics UsageStats { get; }
        /// <summary> Statistics related to resource consumption by Compute Nodes in the Pool. </summary>
        public BatchPoolResourceStatistics ResourceStats { get; }
    }
}
