// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchPoolState enums. </summary>
    public readonly partial struct BatchPoolState : IEquatable<BatchPoolState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchPoolState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchPoolState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "active";
        private const string DeletingValue = "deleting";

        /// <summary> The Pool is available to run Tasks subject to the availability of Compute Nodes. </summary>
        public static BatchPoolState Active { get; } = new BatchPoolState(ActiveValue);
        /// <summary> The user has requested that the Pool be deleted, but the delete operation has not yet completed. </summary>
        public static BatchPoolState Deleting { get; } = new BatchPoolState(DeletingValue);
        /// <summary> Determines if two <see cref="BatchPoolState"/> values are the same. </summary>
        public static bool operator ==(BatchPoolState left, BatchPoolState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchPoolState"/> values are not the same. </summary>
        public static bool operator !=(BatchPoolState left, BatchPoolState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchPoolState"/>. </summary>
        public static implicit operator BatchPoolState(string value) => new BatchPoolState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchPoolState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchPoolState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
