// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Statistics related to resource consumption by Compute Nodes in a Pool. </summary>
    public partial class BatchPoolResourceStatistics
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchPoolResourceStatistics"/>. </summary>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="avgCpuPercentage"> The average CPU usage across all Compute Nodes in the Pool (percentage per node). </param>
        /// <param name="avgMemoryGiB"> The average memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakMemoryGiB"> The peak memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="avgDiskGiB"> The average used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakDiskGiB"> The peak used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadIOps"> The total number of disk read operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteIOps"> The total number of disk write operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadGiB"> The total amount of data in GiB of disk reads across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteGiB"> The total amount of data in GiB of disk writes across all Compute Nodes in the Pool. </param>
        /// <param name="networkReadGiB"> The total amount of data in GiB of network reads across all Compute Nodes in the Pool. </param>
        /// <param name="networkWriteGiB"> The total amount of data in GiB of network writes across all Compute Nodes in the Pool. </param>
        internal BatchPoolResourceStatistics(DateTimeOffset startTime, DateTimeOffset lastUpdateTime, float avgCpuPercentage, float avgMemoryGiB, float peakMemoryGiB, float avgDiskGiB, float peakDiskGiB, long diskReadIOps, long diskWriteIOps, float diskReadGiB, float diskWriteGiB, float networkReadGiB, float networkWriteGiB)
        {
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
            AvgCpuPercentage = avgCpuPercentage;
            AvgMemoryGiB = avgMemoryGiB;
            PeakMemoryGiB = peakMemoryGiB;
            AvgDiskGiB = avgDiskGiB;
            PeakDiskGiB = peakDiskGiB;
            DiskReadIOps = diskReadIOps;
            DiskWriteIOps = diskWriteIOps;
            DiskReadGiB = diskReadGiB;
            DiskWriteGiB = diskWriteGiB;
            NetworkReadGiB = networkReadGiB;
            NetworkWriteGiB = networkWriteGiB;
        }

        /// <summary> Initializes a new instance of <see cref="BatchPoolResourceStatistics"/>. </summary>
        /// <param name="startTime"> The start time of the time range covered by the statistics. </param>
        /// <param name="lastUpdateTime"> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </param>
        /// <param name="avgCpuPercentage"> The average CPU usage across all Compute Nodes in the Pool (percentage per node). </param>
        /// <param name="avgMemoryGiB"> The average memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakMemoryGiB"> The peak memory usage in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="avgDiskGiB"> The average used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="peakDiskGiB"> The peak used disk space in GiB across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadIOps"> The total number of disk read operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteIOps"> The total number of disk write operations across all Compute Nodes in the Pool. </param>
        /// <param name="diskReadGiB"> The total amount of data in GiB of disk reads across all Compute Nodes in the Pool. </param>
        /// <param name="diskWriteGiB"> The total amount of data in GiB of disk writes across all Compute Nodes in the Pool. </param>
        /// <param name="networkReadGiB"> The total amount of data in GiB of network reads across all Compute Nodes in the Pool. </param>
        /// <param name="networkWriteGiB"> The total amount of data in GiB of network writes across all Compute Nodes in the Pool. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchPoolResourceStatistics(DateTimeOffset startTime, DateTimeOffset lastUpdateTime, float avgCpuPercentage, float avgMemoryGiB, float peakMemoryGiB, float avgDiskGiB, float peakDiskGiB, long diskReadIOps, long diskWriteIOps, float diskReadGiB, float diskWriteGiB, float networkReadGiB, float networkWriteGiB, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartTime = startTime;
            LastUpdateTime = lastUpdateTime;
            AvgCpuPercentage = avgCpuPercentage;
            AvgMemoryGiB = avgMemoryGiB;
            PeakMemoryGiB = peakMemoryGiB;
            AvgDiskGiB = avgDiskGiB;
            PeakDiskGiB = peakDiskGiB;
            DiskReadIOps = diskReadIOps;
            DiskWriteIOps = diskWriteIOps;
            DiskReadGiB = diskReadGiB;
            DiskWriteGiB = diskWriteGiB;
            NetworkReadGiB = networkReadGiB;
            NetworkWriteGiB = networkWriteGiB;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchPoolResourceStatistics"/> for deserialization. </summary>
        internal BatchPoolResourceStatistics()
        {
        }

        /// <summary> The start time of the time range covered by the statistics. </summary>
        public DateTimeOffset StartTime { get; }
        /// <summary> The time at which the statistics were last updated. All statistics are limited to the range between startTime and lastUpdateTime. </summary>
        public DateTimeOffset LastUpdateTime { get; }
        /// <summary> The average CPU usage across all Compute Nodes in the Pool (percentage per node). </summary>
        public float AvgCpuPercentage { get; }
        /// <summary> The average memory usage in GiB across all Compute Nodes in the Pool. </summary>
        public float AvgMemoryGiB { get; }
        /// <summary> The peak memory usage in GiB across all Compute Nodes in the Pool. </summary>
        public float PeakMemoryGiB { get; }
        /// <summary> The average used disk space in GiB across all Compute Nodes in the Pool. </summary>
        public float AvgDiskGiB { get; }
        /// <summary> The peak used disk space in GiB across all Compute Nodes in the Pool. </summary>
        public float PeakDiskGiB { get; }
        /// <summary> The total number of disk read operations across all Compute Nodes in the Pool. </summary>
        public long DiskReadIOps { get; }
        /// <summary> The total number of disk write operations across all Compute Nodes in the Pool. </summary>
        public long DiskWriteIOps { get; }
        /// <summary> The total amount of data in GiB of disk reads across all Compute Nodes in the Pool. </summary>
        public float DiskReadGiB { get; }
        /// <summary> The total amount of data in GiB of disk writes across all Compute Nodes in the Pool. </summary>
        public float DiskWriteGiB { get; }
        /// <summary> The total amount of data in GiB of network reads across all Compute Nodes in the Pool. </summary>
        public float NetworkReadGiB { get; }
        /// <summary> The total amount of data in GiB of network writes across all Compute Nodes in the Pool. </summary>
        public float NetworkWriteGiB { get; }
    }
}
