// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchPoolLifetimeOption enums. </summary>
    public readonly partial struct BatchPoolLifetimeOption : IEquatable<BatchPoolLifetimeOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchPoolLifetimeOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchPoolLifetimeOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string JobScheduleValue = "jobschedule";
        private const string JobValue = "job";

        /// <summary> The Pool exists for the lifetime of the Job Schedule. The Batch Service creates the Pool when it creates the first Job on the schedule. You may apply this option only to Job Schedules, not to Jobs. </summary>
        public static BatchPoolLifetimeOption JobSchedule { get; } = new BatchPoolLifetimeOption(JobScheduleValue);
        /// <summary> The Pool exists for the lifetime of the Job to which it is dedicated. The Batch service creates the Pool when it creates the Job. If the 'job' option is applied to a Job Schedule, the Batch service creates a new auto Pool for every Job created on the schedule. </summary>
        public static BatchPoolLifetimeOption Job { get; } = new BatchPoolLifetimeOption(JobValue);
        /// <summary> Determines if two <see cref="BatchPoolLifetimeOption"/> values are the same. </summary>
        public static bool operator ==(BatchPoolLifetimeOption left, BatchPoolLifetimeOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchPoolLifetimeOption"/> values are not the same. </summary>
        public static bool operator !=(BatchPoolLifetimeOption left, BatchPoolLifetimeOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchPoolLifetimeOption"/>. </summary>
        public static implicit operator BatchPoolLifetimeOption(string value) => new BatchPoolLifetimeOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchPoolLifetimeOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchPoolLifetimeOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
