// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchPoolIdentityType enums. </summary>
    public readonly partial struct BatchPoolIdentityType : IEquatable<BatchPoolIdentityType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchPoolIdentityType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchPoolIdentityType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserAssignedValue = "UserAssigned";
        private const string NoneValue = "None";

        /// <summary> Batch pool has user assigned identities with it. </summary>
        public static BatchPoolIdentityType UserAssigned { get; } = new BatchPoolIdentityType(UserAssignedValue);
        /// <summary> Batch pool has no identity associated with it. Setting `None` in update pool will remove existing identities. </summary>
        public static BatchPoolIdentityType None { get; } = new BatchPoolIdentityType(NoneValue);
        /// <summary> Determines if two <see cref="BatchPoolIdentityType"/> values are the same. </summary>
        public static bool operator ==(BatchPoolIdentityType left, BatchPoolIdentityType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchPoolIdentityType"/> values are not the same. </summary>
        public static bool operator !=(BatchPoolIdentityType left, BatchPoolIdentityType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchPoolIdentityType"/>. </summary>
        public static implicit operator BatchPoolIdentityType(string value) => new BatchPoolIdentityType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchPoolIdentityType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchPoolIdentityType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
