// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchPool : IUtf8JsonSerializable, IJsonModel<BatchPool>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchPool>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchPool>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchPool>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchPool)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url);
            }
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("eTag"u8);
                writer.WriteStringValue(ETag);
            }
            if (options.Format != "W" && Optional.IsDefined(LastModified))
            {
                writer.WritePropertyName("lastModified"u8);
                writer.WriteStringValue(LastModified.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CreationTime))
            {
                writer.WritePropertyName("creationTime"u8);
                writer.WriteStringValue(CreationTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StateTransitionTime))
            {
                writer.WritePropertyName("stateTransitionTime"u8);
                writer.WriteStringValue(StateTransitionTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(AllocationState))
            {
                writer.WritePropertyName("allocationState"u8);
                writer.WriteStringValue(AllocationState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(AllocationStateTransitionTime))
            {
                writer.WritePropertyName("allocationStateTransitionTime"u8);
                writer.WriteStringValue(AllocationStateTransitionTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(VmSize))
            {
                writer.WritePropertyName("vmSize"u8);
                writer.WriteStringValue(VmSize);
            }
            if (options.Format != "W" && Optional.IsDefined(VirtualMachineConfiguration))
            {
                writer.WritePropertyName("virtualMachineConfiguration"u8);
                writer.WriteObjectValue(VirtualMachineConfiguration, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ResizeTimeout))
            {
                writer.WritePropertyName("resizeTimeout"u8);
                writer.WriteStringValue(ResizeTimeout.Value, "P");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResizeErrors))
            {
                writer.WritePropertyName("resizeErrors"u8);
                writer.WriteStartArray();
                foreach (var item in ResizeErrors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ResourceTags))
            {
                writer.WritePropertyName("resourceTags"u8);
                writer.WriteStartObject();
                foreach (var item in ResourceTags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentDedicatedNodes))
            {
                writer.WritePropertyName("currentDedicatedNodes"u8);
                writer.WriteNumberValue(CurrentDedicatedNodes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentLowPriorityNodes))
            {
                writer.WritePropertyName("currentLowPriorityNodes"u8);
                writer.WriteNumberValue(CurrentLowPriorityNodes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetDedicatedNodes))
            {
                writer.WritePropertyName("targetDedicatedNodes"u8);
                writer.WriteNumberValue(TargetDedicatedNodes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TargetLowPriorityNodes))
            {
                writer.WritePropertyName("targetLowPriorityNodes"u8);
                writer.WriteNumberValue(TargetLowPriorityNodes.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(EnableAutoScale))
            {
                writer.WritePropertyName("enableAutoScale"u8);
                writer.WriteBooleanValue(EnableAutoScale.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AutoScaleFormula))
            {
                writer.WritePropertyName("autoScaleFormula"u8);
                writer.WriteStringValue(AutoScaleFormula);
            }
            if (options.Format != "W" && Optional.IsDefined(AutoScaleEvaluationInterval))
            {
                writer.WritePropertyName("autoScaleEvaluationInterval"u8);
                writer.WriteStringValue(AutoScaleEvaluationInterval.Value, "P");
            }
            if (options.Format != "W" && Optional.IsDefined(AutoScaleRun))
            {
                writer.WritePropertyName("autoScaleRun"u8);
                writer.WriteObjectValue(AutoScaleRun, options);
            }
            if (options.Format != "W" && Optional.IsDefined(EnableInterNodeCommunication))
            {
                writer.WritePropertyName("enableInterNodeCommunication"u8);
                writer.WriteBooleanValue(EnableInterNodeCommunication.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(NetworkConfiguration))
            {
                writer.WritePropertyName("networkConfiguration"u8);
                writer.WriteObjectValue(NetworkConfiguration, options);
            }
            if (Optional.IsDefined(StartTask))
            {
                writer.WritePropertyName("startTask"u8);
                writer.WriteObjectValue(StartTask, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ApplicationPackageReferences))
            {
                writer.WritePropertyName("applicationPackageReferences"u8);
                writer.WriteStartArray();
                foreach (var item in ApplicationPackageReferences)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(TaskSlotsPerNode))
            {
                writer.WritePropertyName("taskSlotsPerNode"u8);
                writer.WriteNumberValue(TaskSlotsPerNode.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TaskSchedulingPolicy))
            {
                writer.WritePropertyName("taskSchedulingPolicy"u8);
                writer.WriteObjectValue(TaskSchedulingPolicy, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(UserAccounts))
            {
                writer.WritePropertyName("userAccounts"u8);
                writer.WriteStartArray();
                foreach (var item in UserAccounts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Metadata))
            {
                writer.WritePropertyName("metadata"u8);
                writer.WriteStartArray();
                foreach (var item in Metadata)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Stats))
            {
                writer.WritePropertyName("stats"u8);
                writer.WriteObjectValue(Stats, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(MountConfiguration))
            {
                writer.WritePropertyName("mountConfiguration"u8);
                writer.WriteStartArray();
                foreach (var item in MountConfiguration)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Identity))
            {
                writer.WritePropertyName("identity"u8);
                writer.WriteObjectValue(Identity, options);
            }
            if (Optional.IsDefined(TargetNodeCommunicationMode))
            {
                writer.WritePropertyName("targetNodeCommunicationMode"u8);
                writer.WriteStringValue(TargetNodeCommunicationMode.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CurrentNodeCommunicationMode))
            {
                writer.WritePropertyName("currentNodeCommunicationMode"u8);
                writer.WriteStringValue(CurrentNodeCommunicationMode.Value.ToString());
            }
            if (Optional.IsDefined(UpgradePolicy))
            {
                writer.WritePropertyName("upgradePolicy"u8);
                writer.WriteObjectValue(UpgradePolicy, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchPool IJsonModel<BatchPool>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchPool>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchPool)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchPool(document.RootElement, options);
        }

        internal static BatchPool DeserializeBatchPool(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string displayName = default;
            string url = default;
            string eTag = default;
            DateTimeOffset? lastModified = default;
            DateTimeOffset? creationTime = default;
            BatchPoolState? state = default;
            DateTimeOffset? stateTransitionTime = default;
            AllocationState? allocationState = default;
            DateTimeOffset? allocationStateTransitionTime = default;
            string vmSize = default;
            VirtualMachineConfiguration virtualMachineConfiguration = default;
            TimeSpan? resizeTimeout = default;
            IReadOnlyList<ResizeError> resizeErrors = default;
            IReadOnlyDictionary<string, string> resourceTags = default;
            int? currentDedicatedNodes = default;
            int? currentLowPriorityNodes = default;
            int? targetDedicatedNodes = default;
            int? targetLowPriorityNodes = default;
            bool? enableAutoScale = default;
            string autoScaleFormula = default;
            TimeSpan? autoScaleEvaluationInterval = default;
            AutoScaleRun autoScaleRun = default;
            bool? enableInterNodeCommunication = default;
            NetworkConfiguration networkConfiguration = default;
            BatchStartTask startTask = default;
            IReadOnlyList<BatchApplicationPackageReference> applicationPackageReferences = default;
            int? taskSlotsPerNode = default;
            BatchTaskSchedulingPolicy taskSchedulingPolicy = default;
            IReadOnlyList<UserAccount> userAccounts = default;
            IReadOnlyList<MetadataItem> metadata = default;
            BatchPoolStatistics stats = default;
            IReadOnlyList<MountConfiguration> mountConfiguration = default;
            BatchPoolIdentity identity = default;
            BatchNodeCommunicationMode? targetNodeCommunicationMode = default;
            BatchNodeCommunicationMode? currentNodeCommunicationMode = default;
            UpgradePolicy upgradePolicy = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    url = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eTag"u8))
                {
                    eTag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastModified"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastModified = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("creationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new BatchPoolState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("allocationState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationState = new AllocationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("allocationStateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationStateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("vmSize"u8))
                {
                    vmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("virtualMachineConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    virtualMachineConfiguration = VirtualMachineConfiguration.DeserializeVirtualMachineConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("resizeTimeout"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    resizeTimeout = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("resizeErrors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ResizeError> array = new List<ResizeError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ResizeError.DeserializeResizeError(item, options));
                    }
                    resizeErrors = array;
                    continue;
                }
                if (property.NameEquals("resourceTags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    resourceTags = dictionary;
                    continue;
                }
                if (property.NameEquals("currentDedicatedNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentDedicatedNodes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("currentLowPriorityNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentLowPriorityNodes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("targetDedicatedNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetDedicatedNodes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("targetLowPriorityNodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetLowPriorityNodes = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("enableAutoScale"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableAutoScale = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("autoScaleFormula"u8))
                {
                    autoScaleFormula = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("autoScaleEvaluationInterval"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoScaleEvaluationInterval = property.Value.GetTimeSpan("P");
                    continue;
                }
                if (property.NameEquals("autoScaleRun"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    autoScaleRun = AutoScaleRun.DeserializeAutoScaleRun(property.Value, options);
                    continue;
                }
                if (property.NameEquals("enableInterNodeCommunication"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableInterNodeCommunication = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("networkConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    networkConfiguration = NetworkConfiguration.DeserializeNetworkConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("startTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTask = BatchStartTask.DeserializeBatchStartTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("applicationPackageReferences"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchApplicationPackageReference> array = new List<BatchApplicationPackageReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchApplicationPackageReference.DeserializeBatchApplicationPackageReference(item, options));
                    }
                    applicationPackageReferences = array;
                    continue;
                }
                if (property.NameEquals("taskSlotsPerNode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    taskSlotsPerNode = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("taskSchedulingPolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    taskSchedulingPolicy = BatchTaskSchedulingPolicy.DeserializeBatchTaskSchedulingPolicy(property.Value, options);
                    continue;
                }
                if (property.NameEquals("userAccounts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<UserAccount> array = new List<UserAccount>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(UserAccount.DeserializeUserAccount(item, options));
                    }
                    userAccounts = array;
                    continue;
                }
                if (property.NameEquals("metadata"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetadataItem> array = new List<MetadataItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetadataItem.DeserializeMetadataItem(item, options));
                    }
                    metadata = array;
                    continue;
                }
                if (property.NameEquals("stats"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stats = BatchPoolStatistics.DeserializeBatchPoolStatistics(property.Value, options);
                    continue;
                }
                if (property.NameEquals("mountConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MountConfiguration> array = new List<MountConfiguration>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Batch.MountConfiguration.DeserializeMountConfiguration(item, options));
                    }
                    mountConfiguration = array;
                    continue;
                }
                if (property.NameEquals("identity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    identity = BatchPoolIdentity.DeserializeBatchPoolIdentity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("targetNodeCommunicationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetNodeCommunicationMode = new BatchNodeCommunicationMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("currentNodeCommunicationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    currentNodeCommunicationMode = new BatchNodeCommunicationMode(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("upgradePolicy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    upgradePolicy = UpgradePolicy.DeserializeUpgradePolicy(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchPool(
                id,
                displayName,
                url,
                eTag,
                lastModified,
                creationTime,
                state,
                stateTransitionTime,
                allocationState,
                allocationStateTransitionTime,
                vmSize,
                virtualMachineConfiguration,
                resizeTimeout,
                resizeErrors ?? new ChangeTrackingList<ResizeError>(),
                resourceTags ?? new ChangeTrackingDictionary<string, string>(),
                currentDedicatedNodes,
                currentLowPriorityNodes,
                targetDedicatedNodes,
                targetLowPriorityNodes,
                enableAutoScale,
                autoScaleFormula,
                autoScaleEvaluationInterval,
                autoScaleRun,
                enableInterNodeCommunication,
                networkConfiguration,
                startTask,
                applicationPackageReferences ?? new ChangeTrackingList<BatchApplicationPackageReference>(),
                taskSlotsPerNode,
                taskSchedulingPolicy,
                userAccounts ?? new ChangeTrackingList<UserAccount>(),
                metadata ?? new ChangeTrackingList<MetadataItem>(),
                stats,
                mountConfiguration ?? new ChangeTrackingList<MountConfiguration>(),
                identity,
                targetNodeCommunicationMode,
                currentNodeCommunicationMode,
                upgradePolicy,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchPool>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchPool>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchPool)} does not support writing '{options.Format}' format.");
            }
        }

        BatchPool IPersistableModel<BatchPool>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchPool>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchPool(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchPool)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchPool>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchPool FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchPool(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
