// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchNodeInfo : IUtf8JsonSerializable, IJsonModel<BatchNodeInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchNodeInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchNodeInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNodeInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchNodeInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AffinityId))
            {
                writer.WritePropertyName("affinityId"u8);
                writer.WriteStringValue(AffinityId);
            }
            if (Optional.IsDefined(NodeUrl))
            {
                writer.WritePropertyName("nodeUrl"u8);
                writer.WriteStringValue(NodeUrl);
            }
            if (Optional.IsDefined(PoolId))
            {
                writer.WritePropertyName("poolId"u8);
                writer.WriteStringValue(PoolId);
            }
            if (Optional.IsDefined(NodeId))
            {
                writer.WritePropertyName("nodeId"u8);
                writer.WriteStringValue(NodeId);
            }
            if (Optional.IsDefined(TaskRootDirectory))
            {
                writer.WritePropertyName("taskRootDirectory"u8);
                writer.WriteStringValue(TaskRootDirectory);
            }
            if (Optional.IsDefined(TaskRootDirectoryUrl))
            {
                writer.WritePropertyName("taskRootDirectoryUrl"u8);
                writer.WriteStringValue(TaskRootDirectoryUrl);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchNodeInfo IJsonModel<BatchNodeInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNodeInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchNodeInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchNodeInfo(document.RootElement, options);
        }

        internal static BatchNodeInfo DeserializeBatchNodeInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string affinityId = default;
            string nodeUrl = default;
            string poolId = default;
            string nodeId = default;
            string taskRootDirectory = default;
            string taskRootDirectoryUrl = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("affinityId"u8))
                {
                    affinityId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nodeUrl"u8))
                {
                    nodeUrl = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("poolId"u8))
                {
                    poolId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nodeId"u8))
                {
                    nodeId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("taskRootDirectory"u8))
                {
                    taskRootDirectory = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("taskRootDirectoryUrl"u8))
                {
                    taskRootDirectoryUrl = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchNodeInfo(
                affinityId,
                nodeUrl,
                poolId,
                nodeId,
                taskRootDirectory,
                taskRootDirectoryUrl,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchNodeInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNodeInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchNodeInfo)} does not support writing '{options.Format}' format.");
            }
        }

        BatchNodeInfo IPersistableModel<BatchNodeInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNodeInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchNodeInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchNodeInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchNodeInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchNodeInfo FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchNodeInfo(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
