// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchNodeFillType enums. </summary>
    public readonly partial struct BatchNodeFillType : IEquatable<BatchNodeFillType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchNodeFillType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchNodeFillType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SpreadValue = "spread";
        private const string PackValue = "pack";

        /// <summary> Tasks should be assigned evenly across all Compute Nodes in the Pool. </summary>
        public static BatchNodeFillType Spread { get; } = new BatchNodeFillType(SpreadValue);
        /// <summary> As many Tasks as possible (taskSlotsPerNode) should be assigned to each Compute Node in the Pool before any Tasks are assigned to the next Compute Node in the Pool. </summary>
        public static BatchNodeFillType Pack { get; } = new BatchNodeFillType(PackValue);
        /// <summary> Determines if two <see cref="BatchNodeFillType"/> values are the same. </summary>
        public static bool operator ==(BatchNodeFillType left, BatchNodeFillType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchNodeFillType"/> values are not the same. </summary>
        public static bool operator !=(BatchNodeFillType left, BatchNodeFillType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchNodeFillType"/>. </summary>
        public static implicit operator BatchNodeFillType(string value) => new BatchNodeFillType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchNodeFillType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchNodeFillType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
