// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Information about a file or directory on a Compute Node. </summary>
    public partial class BatchNodeFile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchNodeFile"/>. </summary>
        internal BatchNodeFile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchNodeFile"/>. </summary>
        /// <param name="name"> The file path. </param>
        /// <param name="url"> The URL of the file. </param>
        /// <param name="isDirectory"> Whether the object represents a directory. </param>
        /// <param name="properties"> The file properties. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchNodeFile(string name, string url, bool? isDirectory, FileProperties properties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Url = url;
            IsDirectory = isDirectory;
            Properties = properties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The file path. </summary>
        public string Name { get; }
        /// <summary> The URL of the file. </summary>
        public string Url { get; }
        /// <summary> Whether the object represents a directory. </summary>
        public bool? IsDirectory { get; }
        /// <summary> The file properties. </summary>
        public FileProperties Properties { get; }
    }
}
