// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchNodeDisableSchedulingOption enums. </summary>
    public readonly partial struct BatchNodeDisableSchedulingOption : IEquatable<BatchNodeDisableSchedulingOption>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchNodeDisableSchedulingOption"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchNodeDisableSchedulingOption(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RequeueValue = "requeue";
        private const string TerminateValue = "terminate";
        private const string TaskCompletionValue = "taskcompletion";

        /// <summary> Terminate running Task processes and requeue the Tasks. The Tasks may run again on other Compute Nodes, or when Task scheduling is re-enabled on this Compute Node. Enter offline state as soon as Tasks have been terminated. </summary>
        public static BatchNodeDisableSchedulingOption Requeue { get; } = new BatchNodeDisableSchedulingOption(RequeueValue);
        /// <summary> Terminate running Tasks. The Tasks will be completed with failureInfo indicating that they were terminated, and will not run again. Enter offline state as soon as Tasks have been terminated. </summary>
        public static BatchNodeDisableSchedulingOption Terminate { get; } = new BatchNodeDisableSchedulingOption(TerminateValue);
        /// <summary> Allow currently running Tasks to complete. Schedule no new Tasks while waiting. Enter offline state when all Tasks have completed. </summary>
        public static BatchNodeDisableSchedulingOption TaskCompletion { get; } = new BatchNodeDisableSchedulingOption(TaskCompletionValue);
        /// <summary> Determines if two <see cref="BatchNodeDisableSchedulingOption"/> values are the same. </summary>
        public static bool operator ==(BatchNodeDisableSchedulingOption left, BatchNodeDisableSchedulingOption right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchNodeDisableSchedulingOption"/> values are not the same. </summary>
        public static bool operator !=(BatchNodeDisableSchedulingOption left, BatchNodeDisableSchedulingOption right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchNodeDisableSchedulingOption"/>. </summary>
        public static implicit operator BatchNodeDisableSchedulingOption(string value) => new BatchNodeDisableSchedulingOption(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchNodeDisableSchedulingOption other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchNodeDisableSchedulingOption other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
