// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchNode : IUtf8JsonSerializable, IJsonModel<BatchNode>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchNode>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchNode>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchNode)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url);
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (Optional.IsDefined(SchedulingState))
            {
                writer.WritePropertyName("schedulingState"u8);
                writer.WriteStringValue(SchedulingState.Value.ToString());
            }
            if (Optional.IsDefined(StateTransitionTime))
            {
                writer.WritePropertyName("stateTransitionTime"u8);
                writer.WriteStringValue(StateTransitionTime.Value, "O");
            }
            if (Optional.IsDefined(LastBootTime))
            {
                writer.WritePropertyName("lastBootTime"u8);
                writer.WriteStringValue(LastBootTime.Value, "O");
            }
            if (Optional.IsDefined(AllocationTime))
            {
                writer.WritePropertyName("allocationTime"u8);
                writer.WriteStringValue(AllocationTime.Value, "O");
            }
            if (Optional.IsDefined(IpAddress))
            {
                writer.WritePropertyName("ipAddress"u8);
                writer.WriteStringValue(IpAddress);
            }
            if (Optional.IsDefined(AffinityId))
            {
                writer.WritePropertyName("affinityId"u8);
                writer.WriteStringValue(AffinityId);
            }
            if (Optional.IsDefined(VmSize))
            {
                writer.WritePropertyName("vmSize"u8);
                writer.WriteStringValue(VmSize);
            }
            if (Optional.IsDefined(TotalTasksRun))
            {
                writer.WritePropertyName("totalTasksRun"u8);
                writer.WriteNumberValue(TotalTasksRun.Value);
            }
            if (Optional.IsDefined(RunningTasksCount))
            {
                writer.WritePropertyName("runningTasksCount"u8);
                writer.WriteNumberValue(RunningTasksCount.Value);
            }
            if (Optional.IsDefined(RunningTaskSlotsCount))
            {
                writer.WritePropertyName("runningTaskSlotsCount"u8);
                writer.WriteNumberValue(RunningTaskSlotsCount.Value);
            }
            if (Optional.IsDefined(TotalTasksSucceeded))
            {
                writer.WritePropertyName("totalTasksSucceeded"u8);
                writer.WriteNumberValue(TotalTasksSucceeded.Value);
            }
            if (Optional.IsCollectionDefined(RecentTasks))
            {
                writer.WritePropertyName("recentTasks"u8);
                writer.WriteStartArray();
                foreach (var item in RecentTasks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(StartTask))
            {
                writer.WritePropertyName("startTask"u8);
                writer.WriteObjectValue(StartTask, options);
            }
            if (Optional.IsDefined(StartTaskInfo))
            {
                writer.WritePropertyName("startTaskInfo"u8);
                writer.WriteObjectValue(StartTaskInfo, options);
            }
            if (Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(IsDedicated))
            {
                writer.WritePropertyName("isDedicated"u8);
                writer.WriteBooleanValue(IsDedicated.Value);
            }
            if (Optional.IsDefined(EndpointConfiguration))
            {
                writer.WritePropertyName("endpointConfiguration"u8);
                writer.WriteObjectValue(EndpointConfiguration, options);
            }
            if (Optional.IsDefined(NodeAgentInfo))
            {
                writer.WritePropertyName("nodeAgentInfo"u8);
                writer.WriteObjectValue(NodeAgentInfo, options);
            }
            if (Optional.IsDefined(VirtualMachineInfo))
            {
                writer.WritePropertyName("virtualMachineInfo"u8);
                writer.WriteObjectValue(VirtualMachineInfo, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchNode IJsonModel<BatchNode>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNode>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchNode)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchNode(document.RootElement, options);
        }

        internal static BatchNode DeserializeBatchNode(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string url = default;
            BatchNodeState? state = default;
            SchedulingState? schedulingState = default;
            DateTimeOffset? stateTransitionTime = default;
            DateTimeOffset? lastBootTime = default;
            DateTimeOffset? allocationTime = default;
            string ipAddress = default;
            string affinityId = default;
            string vmSize = default;
            int? totalTasksRun = default;
            int? runningTasksCount = default;
            int? runningTaskSlotsCount = default;
            int? totalTasksSucceeded = default;
            IReadOnlyList<BatchTaskInfo> recentTasks = default;
            BatchStartTask startTask = default;
            BatchStartTaskInfo startTaskInfo = default;
            IReadOnlyList<BatchNodeError> errors = default;
            bool? isDedicated = default;
            BatchNodeEndpointConfiguration endpointConfiguration = default;
            BatchNodeAgentInfo nodeAgentInfo = default;
            VirtualMachineInfo virtualMachineInfo = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    url = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new BatchNodeState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("schedulingState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    schedulingState = new SchedulingState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastBootTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastBootTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("allocationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allocationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("ipAddress"u8))
                {
                    ipAddress = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("affinityId"u8))
                {
                    affinityId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("vmSize"u8))
                {
                    vmSize = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("totalTasksRun"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalTasksRun = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("runningTasksCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    runningTasksCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("runningTaskSlotsCount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    runningTaskSlotsCount = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalTasksSucceeded"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalTasksSucceeded = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("recentTasks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchTaskInfo> array = new List<BatchTaskInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchTaskInfo.DeserializeBatchTaskInfo(item, options));
                    }
                    recentTasks = array;
                    continue;
                }
                if (property.NameEquals("startTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTask = BatchStartTask.DeserializeBatchStartTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("startTaskInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTaskInfo = BatchStartTaskInfo.DeserializeBatchStartTaskInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("errors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BatchNodeError> array = new List<BatchNodeError>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchNodeError.DeserializeBatchNodeError(item, options));
                    }
                    errors = array;
                    continue;
                }
                if (property.NameEquals("isDedicated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDedicated = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("endpointConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endpointConfiguration = BatchNodeEndpointConfiguration.DeserializeBatchNodeEndpointConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("nodeAgentInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    nodeAgentInfo = BatchNodeAgentInfo.DeserializeBatchNodeAgentInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("virtualMachineInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    virtualMachineInfo = VirtualMachineInfo.DeserializeVirtualMachineInfo(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchNode(
                id,
                url,
                state,
                schedulingState,
                stateTransitionTime,
                lastBootTime,
                allocationTime,
                ipAddress,
                affinityId,
                vmSize,
                totalTasksRun,
                runningTasksCount,
                runningTaskSlotsCount,
                totalTasksSucceeded,
                recentTasks ?? new ChangeTrackingList<BatchTaskInfo>(),
                startTask,
                startTaskInfo,
                errors ?? new ChangeTrackingList<BatchNodeError>(),
                isDedicated,
                endpointConfiguration,
                nodeAgentInfo,
                virtualMachineInfo,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchNode>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchNode)} does not support writing '{options.Format}' format.");
            }
        }

        BatchNode IPersistableModel<BatchNode>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchNode>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchNode(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchNode)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchNode>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchNode FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchNode(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
