// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// Contains information about Jobs that have been and will be run under a Job
    /// Schedule.
    /// </summary>
    public partial class BatchJobScheduleExecutionInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchJobScheduleExecutionInfo"/>. </summary>
        internal BatchJobScheduleExecutionInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BatchJobScheduleExecutionInfo"/>. </summary>
        /// <param name="nextRunTime"> The next time at which a Job will be created under this schedule. This property is meaningful only if the schedule is in the active state when the time comes around. For example, if the schedule is disabled, no Job will be created at nextRunTime unless the Job is enabled before then. </param>
        /// <param name="recentJob"> Information about the most recent Job under the Job Schedule. This property is present only if the at least one Job has run under the schedule. </param>
        /// <param name="endTime"> The time at which the schedule ended. This property is set only if the Job Schedule is in the completed state. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchJobScheduleExecutionInfo(DateTimeOffset? nextRunTime, RecentBatchJob recentJob, DateTimeOffset? endTime, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NextRunTime = nextRunTime;
            RecentJob = recentJob;
            EndTime = endTime;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The next time at which a Job will be created under this schedule. This property is meaningful only if the schedule is in the active state when the time comes around. For example, if the schedule is disabled, no Job will be created at nextRunTime unless the Job is enabled before then. </summary>
        public DateTimeOffset? NextRunTime { get; }
        /// <summary> Information about the most recent Job under the Job Schedule. This property is present only if the at least one Job has run under the schedule. </summary>
        public RecentBatchJob RecentJob { get; }
        /// <summary> The time at which the schedule ended. This property is set only if the Job Schedule is in the completed state. </summary>
        public DateTimeOffset? EndTime { get; }
    }
}
