// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// A Job Schedule that allows recurring Jobs by specifying when to run Jobs and a
    /// specification used to create each Job.
    /// </summary>
    public partial class BatchJobSchedule
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchJobSchedule"/>. </summary>
        /// <param name="jobSpecification"> The details of the Jobs to be created on this schedule. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobSpecification"/> is null. </exception>
        public BatchJobSchedule(BatchJobSpecification jobSpecification)
        {
            Argument.AssertNotNull(jobSpecification, nameof(jobSpecification));

            JobSpecification = jobSpecification;
            Metadata = new ChangeTrackingList<MetadataItem>();
        }

        /// <summary> Initializes a new instance of <see cref="BatchJobSchedule"/>. </summary>
        /// <param name="id"> A string that uniquely identifies the schedule within the Account. </param>
        /// <param name="displayName"> The display name for the schedule. </param>
        /// <param name="url"> The URL of the Job Schedule. </param>
        /// <param name="eTag"> The ETag of the Job Schedule. This is an opaque string. You can use it to detect whether the Job Schedule has changed between requests. In particular, you can be pass the ETag with an Update Job Schedule request to specify that your changes should take effect only if nobody else has modified the schedule in the meantime. </param>
        /// <param name="lastModified"> The last modified time of the Job Schedule. This is the last time at which the schedule level data, such as the Job specification or recurrence information, changed. It does not factor in job-level changes such as new Jobs being created or Jobs changing state. </param>
        /// <param name="creationTime"> The creation time of the Job Schedule. </param>
        /// <param name="state"> The current state of the Job Schedule. </param>
        /// <param name="stateTransitionTime"> The time at which the Job Schedule entered the current state. </param>
        /// <param name="previousState"> The previous state of the Job Schedule. This property is not present if the Job Schedule is in its initial active state. </param>
        /// <param name="previousStateTransitionTime"> The time at which the Job Schedule entered its previous state. This property is not present if the Job Schedule is in its initial active state. </param>
        /// <param name="schedule"> The schedule according to which Jobs will be created. All times are fixed respective to UTC and are not impacted by daylight saving time. </param>
        /// <param name="jobSpecification"> The details of the Jobs to be created on this schedule. </param>
        /// <param name="executionInfo"> Information about Jobs that have been and will be run under this schedule. </param>
        /// <param name="metadata"> A list of name-value pairs associated with the schedule as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </param>
        /// <param name="stats"> The lifetime resource usage statistics for the Job Schedule. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchJobSchedule(string id, string displayName, string url, string eTag, DateTimeOffset? lastModified, DateTimeOffset? creationTime, BatchJobScheduleState? state, DateTimeOffset? stateTransitionTime, BatchJobScheduleState? previousState, DateTimeOffset? previousStateTransitionTime, BatchJobScheduleConfiguration schedule, BatchJobSpecification jobSpecification, BatchJobScheduleExecutionInfo executionInfo, IList<MetadataItem> metadata, BatchJobScheduleStatistics stats, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            DisplayName = displayName;
            Url = url;
            ETag = eTag;
            LastModified = lastModified;
            CreationTime = creationTime;
            State = state;
            StateTransitionTime = stateTransitionTime;
            PreviousState = previousState;
            PreviousStateTransitionTime = previousStateTransitionTime;
            Schedule = schedule;
            JobSpecification = jobSpecification;
            ExecutionInfo = executionInfo;
            Metadata = metadata;
            Stats = stats;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchJobSchedule"/> for deserialization. </summary>
        internal BatchJobSchedule()
        {
        }

        /// <summary> A string that uniquely identifies the schedule within the Account. </summary>
        public string Id { get; }
        /// <summary> The display name for the schedule. </summary>
        public string DisplayName { get; }
        /// <summary> The URL of the Job Schedule. </summary>
        public string Url { get; }
        /// <summary> The ETag of the Job Schedule. This is an opaque string. You can use it to detect whether the Job Schedule has changed between requests. In particular, you can be pass the ETag with an Update Job Schedule request to specify that your changes should take effect only if nobody else has modified the schedule in the meantime. </summary>
        public string ETag { get; }
        /// <summary> The last modified time of the Job Schedule. This is the last time at which the schedule level data, such as the Job specification or recurrence information, changed. It does not factor in job-level changes such as new Jobs being created or Jobs changing state. </summary>
        public DateTimeOffset? LastModified { get; }
        /// <summary> The creation time of the Job Schedule. </summary>
        public DateTimeOffset? CreationTime { get; }
        /// <summary> The current state of the Job Schedule. </summary>
        public BatchJobScheduleState? State { get; }
        /// <summary> The time at which the Job Schedule entered the current state. </summary>
        public DateTimeOffset? StateTransitionTime { get; }
        /// <summary> The previous state of the Job Schedule. This property is not present if the Job Schedule is in its initial active state. </summary>
        public BatchJobScheduleState? PreviousState { get; }
        /// <summary> The time at which the Job Schedule entered its previous state. This property is not present if the Job Schedule is in its initial active state. </summary>
        public DateTimeOffset? PreviousStateTransitionTime { get; }
        /// <summary> The schedule according to which Jobs will be created. All times are fixed respective to UTC and are not impacted by daylight saving time. </summary>
        public BatchJobScheduleConfiguration Schedule { get; set; }
        /// <summary> The details of the Jobs to be created on this schedule. </summary>
        public BatchJobSpecification JobSpecification { get; set; }
        /// <summary> Information about Jobs that have been and will be run under this schedule. </summary>
        public BatchJobScheduleExecutionInfo ExecutionInfo { get; }
        /// <summary> A list of name-value pairs associated with the schedule as metadata. The Batch service does not assign any meaning to metadata; it is solely for the use of user code. </summary>
        public IList<MetadataItem> Metadata { get; }
        /// <summary> The lifetime resource usage statistics for the Job Schedule. The statistics may not be immediately available. The Batch service performs periodic roll-up of statistics. The typical delay is about 30 minutes. </summary>
        public BatchJobScheduleStatistics Stats { get; }
    }
}
