// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchJobReleaseTaskState enums. </summary>
    public readonly partial struct BatchJobReleaseTaskState : IEquatable<BatchJobReleaseTaskState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchJobReleaseTaskState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchJobReleaseTaskState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RunningValue = "running";
        private const string CompletedValue = "completed";

        /// <summary> The Task is currently running (including retrying). </summary>
        public static BatchJobReleaseTaskState Running { get; } = new BatchJobReleaseTaskState(RunningValue);
        /// <summary> The Task has exited with exit code 0, or the Task has exhausted its retry limit, or the Batch service was unable to start the Task due to Task preparation errors (such as resource file download failures). </summary>
        public static BatchJobReleaseTaskState Completed { get; } = new BatchJobReleaseTaskState(CompletedValue);
        /// <summary> Determines if two <see cref="BatchJobReleaseTaskState"/> values are the same. </summary>
        public static bool operator ==(BatchJobReleaseTaskState left, BatchJobReleaseTaskState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchJobReleaseTaskState"/> values are not the same. </summary>
        public static bool operator !=(BatchJobReleaseTaskState left, BatchJobReleaseTaskState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchJobReleaseTaskState"/>. </summary>
        public static implicit operator BatchJobReleaseTaskState(string value) => new BatchJobReleaseTaskState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchJobReleaseTaskState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchJobReleaseTaskState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
