// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Contains information about the execution of a Job in the Azure Batch service. </summary>
    public partial class BatchJobExecutionInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BatchJobExecutionInfo"/>. </summary>
        /// <param name="startTime"> The start time of the Job. This is the time at which the Job was created. </param>
        internal BatchJobExecutionInfo(DateTimeOffset startTime)
        {
            StartTime = startTime;
        }

        /// <summary> Initializes a new instance of <see cref="BatchJobExecutionInfo"/>. </summary>
        /// <param name="startTime"> The start time of the Job. This is the time at which the Job was created. </param>
        /// <param name="endTime"> The completion time of the Job. This property is set only if the Job is in the completed state. </param>
        /// <param name="poolId"> The ID of the Pool to which this Job is assigned. This element contains the actual Pool where the Job is assigned. When you get Job details from the service, they also contain a poolInfo element, which contains the Pool configuration data from when the Job was added or updated. That poolInfo element may also contain a poolId element. If it does, the two IDs are the same. If it does not, it means the Job ran on an auto Pool, and this property contains the ID of that auto Pool. </param>
        /// <param name="schedulingError"> Details of any error encountered by the service in starting the Job. This property is not set if there was no error starting the Job. </param>
        /// <param name="terminationReason"> A string describing the reason the Job ended. This property is set only if the Job is in the completed state. If the Batch service terminates the Job, it sets the reason as follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion was set to true. MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the Job's onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job are complete. TaskFailed - the Job's onTaskFailure attribute is set to performExitOptionsJobAction, and a Task in the Job failed with an exit condition that specified a jobAction of terminatejob. Any other string is a user-defined reason specified in a call to the 'Terminate a Job' operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BatchJobExecutionInfo(DateTimeOffset startTime, DateTimeOffset? endTime, string poolId, BatchJobSchedulingError schedulingError, string terminationReason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            StartTime = startTime;
            EndTime = endTime;
            PoolId = poolId;
            SchedulingError = schedulingError;
            TerminationReason = terminationReason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="BatchJobExecutionInfo"/> for deserialization. </summary>
        internal BatchJobExecutionInfo()
        {
        }

        /// <summary> The start time of the Job. This is the time at which the Job was created. </summary>
        public DateTimeOffset StartTime { get; }
        /// <summary> The completion time of the Job. This property is set only if the Job is in the completed state. </summary>
        public DateTimeOffset? EndTime { get; }
        /// <summary> The ID of the Pool to which this Job is assigned. This element contains the actual Pool where the Job is assigned. When you get Job details from the service, they also contain a poolInfo element, which contains the Pool configuration data from when the Job was added or updated. That poolInfo element may also contain a poolId element. If it does, the two IDs are the same. If it does not, it means the Job ran on an auto Pool, and this property contains the ID of that auto Pool. </summary>
        public string PoolId { get; }
        /// <summary> Details of any error encountered by the service in starting the Job. This property is not set if there was no error starting the Job. </summary>
        public BatchJobSchedulingError SchedulingError { get; }
        /// <summary> A string describing the reason the Job ended. This property is set only if the Job is in the completed state. If the Batch service terminates the Job, it sets the reason as follows: JMComplete - the Job Manager Task completed, and killJobOnCompletion was set to true. MaxWallClockTimeExpiry - the Job reached its maxWallClockTime constraint. TerminateJobSchedule - the Job ran as part of a schedule, and the schedule terminated. AllTasksComplete - the Job's onAllTasksComplete attribute is set to terminatejob, and all Tasks in the Job are complete. TaskFailed - the Job's onTaskFailure attribute is set to performExitOptionsJobAction, and a Task in the Job failed with an exit condition that specified a jobAction of terminatejob. Any other string is a user-defined reason specified in a call to the 'Terminate a Job' operation. </summary>
        public string TerminationReason { get; }
    }
}
