// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Compute.Batch
{
    /// <summary> BatchJobAction enums. </summary>
    public readonly partial struct BatchJobAction : IEquatable<BatchJobAction>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BatchJobAction"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BatchJobAction(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "none";
        private const string DisableValue = "disable";
        private const string TerminateValue = "terminate";

        /// <summary> Take no action. </summary>
        public static BatchJobAction None { get; } = new BatchJobAction(NoneValue);
        /// <summary> Disable the Job. This is equivalent to calling the disable Job API, with a disableTasks value of requeue. </summary>
        public static BatchJobAction Disable { get; } = new BatchJobAction(DisableValue);
        /// <summary> Terminate the Job. The terminationReason in the Job's executionInfo is set to "TaskFailed". </summary>
        public static BatchJobAction Terminate { get; } = new BatchJobAction(TerminateValue);
        /// <summary> Determines if two <see cref="BatchJobAction"/> values are the same. </summary>
        public static bool operator ==(BatchJobAction left, BatchJobAction right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BatchJobAction"/> values are not the same. </summary>
        public static bool operator !=(BatchJobAction left, BatchJobAction right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BatchJobAction"/>. </summary>
        public static implicit operator BatchJobAction(string value) => new BatchJobAction(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BatchJobAction other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BatchJobAction other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
