// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchJob : IUtf8JsonSerializable, IJsonModel<BatchJob>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchJob>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchJob>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchJob>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchJob)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(Id))
            {
                writer.WritePropertyName("id"u8);
                writer.WriteStringValue(Id);
            }
            if (options.Format != "W" && Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (options.Format != "W" && Optional.IsDefined(UsesTaskDependencies))
            {
                writer.WritePropertyName("usesTaskDependencies"u8);
                writer.WriteBooleanValue(UsesTaskDependencies.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(Url))
            {
                writer.WritePropertyName("url"u8);
                writer.WriteStringValue(Url);
            }
            if (options.Format != "W" && Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("eTag"u8);
                writer.WriteStringValue(ETag);
            }
            if (options.Format != "W" && Optional.IsDefined(LastModified))
            {
                writer.WritePropertyName("lastModified"u8);
                writer.WriteStringValue(LastModified.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CreationTime))
            {
                writer.WritePropertyName("creationTime"u8);
                writer.WriteStringValue(CreationTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StateTransitionTime))
            {
                writer.WritePropertyName("stateTransitionTime"u8);
                writer.WriteStringValue(StateTransitionTime.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(PreviousState))
            {
                writer.WritePropertyName("previousState"u8);
                writer.WriteStringValue(PreviousState.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(PreviousStateTransitionTime))
            {
                writer.WritePropertyName("previousStateTransitionTime"u8);
                writer.WriteStringValue(PreviousStateTransitionTime.Value, "O");
            }
            if (Optional.IsDefined(Priority))
            {
                writer.WritePropertyName("priority"u8);
                writer.WriteNumberValue(Priority.Value);
            }
            if (Optional.IsDefined(AllowTaskPreemption))
            {
                writer.WritePropertyName("allowTaskPreemption"u8);
                writer.WriteBooleanValue(AllowTaskPreemption.Value);
            }
            if (Optional.IsDefined(MaxParallelTasks))
            {
                writer.WritePropertyName("maxParallelTasks"u8);
                writer.WriteNumberValue(MaxParallelTasks.Value);
            }
            if (Optional.IsDefined(Constraints))
            {
                writer.WritePropertyName("constraints"u8);
                writer.WriteObjectValue(Constraints, options);
            }
            if (options.Format != "W" && Optional.IsDefined(JobManagerTask))
            {
                writer.WritePropertyName("jobManagerTask"u8);
                writer.WriteObjectValue(JobManagerTask, options);
            }
            if (options.Format != "W" && Optional.IsDefined(JobPreparationTask))
            {
                writer.WritePropertyName("jobPreparationTask"u8);
                writer.WriteObjectValue(JobPreparationTask, options);
            }
            if (options.Format != "W" && Optional.IsDefined(JobReleaseTask))
            {
                writer.WritePropertyName("jobReleaseTask"u8);
                writer.WriteObjectValue(JobReleaseTask, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(CommonEnvironmentSettings))
            {
                writer.WritePropertyName("commonEnvironmentSettings"u8);
                writer.WriteStartArray();
                foreach (var item in CommonEnvironmentSettings)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WritePropertyName("poolInfo"u8);
            writer.WriteObjectValue(PoolInfo, options);
            if (Optional.IsDefined(OnAllTasksComplete))
            {
                writer.WritePropertyName("onAllTasksComplete"u8);
                writer.WriteStringValue(OnAllTasksComplete.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(OnTaskFailure))
            {
                writer.WritePropertyName("onTaskFailure"u8);
                writer.WriteStringValue(OnTaskFailure.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(NetworkConfiguration))
            {
                writer.WritePropertyName("networkConfiguration"u8);
                writer.WriteObjectValue(NetworkConfiguration, options);
            }
            if (Optional.IsCollectionDefined(Metadata))
            {
                writer.WritePropertyName("metadata"u8);
                writer.WriteStartArray();
                foreach (var item in Metadata)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ExecutionInfo))
            {
                writer.WritePropertyName("executionInfo"u8);
                writer.WriteObjectValue(ExecutionInfo, options);
            }
            if (options.Format != "W" && Optional.IsDefined(Stats))
            {
                writer.WritePropertyName("stats"u8);
                writer.WriteObjectValue(Stats, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchJob IJsonModel<BatchJob>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchJob>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchJob)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchJob(document.RootElement, options);
        }

        internal static BatchJob DeserializeBatchJob(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            string displayName = default;
            bool? usesTaskDependencies = default;
            string url = default;
            string eTag = default;
            DateTimeOffset? lastModified = default;
            DateTimeOffset? creationTime = default;
            BatchJobState? state = default;
            DateTimeOffset? stateTransitionTime = default;
            BatchJobState? previousState = default;
            DateTimeOffset? previousStateTransitionTime = default;
            int? priority = default;
            bool? allowTaskPreemption = default;
            int? maxParallelTasks = default;
            BatchJobConstraints constraints = default;
            BatchJobManagerTask jobManagerTask = default;
            BatchJobPreparationTask jobPreparationTask = default;
            BatchJobReleaseTask jobReleaseTask = default;
            IReadOnlyList<EnvironmentSetting> commonEnvironmentSettings = default;
            BatchPoolInfo poolInfo = default;
            OnAllBatchTasksComplete? onAllTasksComplete = default;
            OnBatchTaskFailure? onTaskFailure = default;
            BatchJobNetworkConfiguration networkConfiguration = default;
            IList<MetadataItem> metadata = default;
            BatchJobExecutionInfo executionInfo = default;
            BatchJobStatistics stats = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("usesTaskDependencies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usesTaskDependencies = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("url"u8))
                {
                    url = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("eTag"u8))
                {
                    eTag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastModified"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastModified = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("creationTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    creationTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("state"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    state = new BatchJobState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("stateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("previousState"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    previousState = new BatchJobState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("previousStateTransitionTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    previousStateTransitionTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("priority"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    priority = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("allowTaskPreemption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    allowTaskPreemption = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("maxParallelTasks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxParallelTasks = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("constraints"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    constraints = BatchJobConstraints.DeserializeBatchJobConstraints(property.Value, options);
                    continue;
                }
                if (property.NameEquals("jobManagerTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobManagerTask = BatchJobManagerTask.DeserializeBatchJobManagerTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("jobPreparationTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobPreparationTask = BatchJobPreparationTask.DeserializeBatchJobPreparationTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("jobReleaseTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    jobReleaseTask = BatchJobReleaseTask.DeserializeBatchJobReleaseTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("commonEnvironmentSettings"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<EnvironmentSetting> array = new List<EnvironmentSetting>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(EnvironmentSetting.DeserializeEnvironmentSetting(item, options));
                    }
                    commonEnvironmentSettings = array;
                    continue;
                }
                if (property.NameEquals("poolInfo"u8))
                {
                    poolInfo = BatchPoolInfo.DeserializeBatchPoolInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("onAllTasksComplete"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onAllTasksComplete = new OnAllBatchTasksComplete(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("onTaskFailure"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onTaskFailure = new OnBatchTaskFailure(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("networkConfiguration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    networkConfiguration = BatchJobNetworkConfiguration.DeserializeBatchJobNetworkConfiguration(property.Value, options);
                    continue;
                }
                if (property.NameEquals("metadata"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetadataItem> array = new List<MetadataItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetadataItem.DeserializeMetadataItem(item, options));
                    }
                    metadata = array;
                    continue;
                }
                if (property.NameEquals("executionInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    executionInfo = BatchJobExecutionInfo.DeserializeBatchJobExecutionInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("stats"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    stats = BatchJobStatistics.DeserializeBatchJobStatistics(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchJob(
                id,
                displayName,
                usesTaskDependencies,
                url,
                eTag,
                lastModified,
                creationTime,
                state,
                stateTransitionTime,
                previousState,
                previousStateTransitionTime,
                priority,
                allowTaskPreemption,
                maxParallelTasks,
                constraints,
                jobManagerTask,
                jobPreparationTask,
                jobReleaseTask,
                commonEnvironmentSettings ?? new ChangeTrackingList<EnvironmentSetting>(),
                poolInfo,
                onAllTasksComplete,
                onTaskFailure,
                networkConfiguration,
                metadata ?? new ChangeTrackingList<MetadataItem>(),
                executionInfo,
                stats,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchJob>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchJob>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchJob)} does not support writing '{options.Format}' format.");
            }
        }

        BatchJob IPersistableModel<BatchJob>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchJob>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchJob(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchJob)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchJob>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchJob FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchJob(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
