// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Compute.Batch
{
    /// <summary> Client options for BatchClient. </summary>
    public partial class BatchClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2024_02_01_19_0;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2024-02-01.19.0". </summary>
            V2024_02_01_19_0 = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of BatchClientOptions. </summary>
        public BatchClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2024_02_01_19_0 => "2024-02-01.19.0",
                _ => throw new NotSupportedException()
            };
        }
    }
}
