// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Compute.Batch
{
    // Data plane generated client.
    /// <summary> The Batch service client. </summary>
    public partial class BatchClient
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://batch.core.windows.net//.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of BatchClient for mocking. </summary>
        protected BatchClient()
        {
        }

        /// <summary> Initializes a new instance of BatchClient. </summary>
        /// <param name="endpoint"> Batch account endpoint (for example: https://batchaccount.eastus2.batch.azure.com). </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public BatchClient(Uri endpoint, TokenCredential credential) : this(endpoint, credential, new BatchClientOptions())
        {
        }

        /// <summary> Initializes a new instance of BatchClient. </summary>
        /// <param name="endpoint"> Batch account endpoint (for example: https://batchaccount.eastus2.batch.azure.com). </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public BatchClient(Uri endpoint, TokenCredential credential, BatchClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(credential, nameof(credential));
            options ??= new BatchClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _tokenCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new BearerTokenAuthenticationPolicy(_tokenCredential, AuthorizationScopes) }, new ResponseClassifier());
            _endpoint = endpoint;
            _apiVersion = options.Version;
        }

        /// <summary> Gets information about the specified Application. </summary>
        /// <param name="applicationId"> The ID of the Application. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="applicationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="applicationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation returns only Applications and versions that are available for
        /// use on Compute Nodes; that is, that can be used in an Package reference. For
        /// administrator information about Applications and versions that are not yet
        /// available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        /// API.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplicationAsync(string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<BatchApplication>> GetApplicationAsync(string applicationId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(applicationId, nameof(applicationId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetApplicationAsync(applicationId, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(BatchApplication.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Application. </summary>
        /// <param name="applicationId"> The ID of the Application. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="applicationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="applicationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation returns only Applications and versions that are available for
        /// use on Compute Nodes; that is, that can be used in an Package reference. For
        /// administrator information about Applications and versions that are not yet
        /// available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        /// API.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplication(string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<BatchApplication> GetApplication(string applicationId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(applicationId, nameof(applicationId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetApplication(applicationId, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(BatchApplication.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Application.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetApplicationAsync(string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="applicationId"> The ID of the Application. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="applicationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="applicationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplicationAsync(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> GetApplicationAsync(string applicationId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(applicationId, nameof(applicationId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetApplication");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetApplicationRequest(applicationId, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Application.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetApplication(string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="applicationId"> The ID of the Application. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="applicationId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="applicationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplication(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response GetApplication(string applicationId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(applicationId, nameof(applicationId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetApplication");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetApplicationRequest(applicationId, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a Pool to the specified Account. </summary>
        /// <param name="pool"> The Pool to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pool"/> is null. </exception>
        /// <remarks>
        /// When naming Pools, avoid including sensitive information such as user names or
        /// secret project names. This information may appear in telemetry logs accessible
        /// to Microsoft Support engineers.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreatePoolAsync(BatchPoolCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> CreatePoolAsync(BatchPoolCreateContent pool, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(pool, nameof(pool));

            using RequestContent content = pool.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreatePoolAsync(content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Creates a Pool to the specified Account. </summary>
        /// <param name="pool"> The Pool to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pool"/> is null. </exception>
        /// <remarks>
        /// When naming Pools, avoid including sensitive information such as user names or
        /// secret project names. This information may appear in telemetry logs accessible
        /// to Microsoft Support engineers.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreatePool(BatchPoolCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response CreatePool(BatchPoolCreateContent pool, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(pool, nameof(pool));

            using RequestContent content = pool.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreatePool(content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Creates a Pool to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreatePoolAsync(BatchPoolCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreatePoolAsync(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreatePoolAsync(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreatePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreatePoolRequest(content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Creates a Pool to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreatePool(BatchPoolCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreatePool(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreatePool(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreatePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreatePoolRequest(content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Pool from the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeletePoolAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DeletePoolAsync(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeletePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeletePoolRequest(poolId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Pool from the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeletePool(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DeletePool(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeletePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeletePoolRequest(poolId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BatchPool>> GetPoolAsync(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetPoolAsync(poolId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(BatchPool.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPool(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual Response<BatchPool> GetPool(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetPool(poolId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
            return Response.FromValue(BatchPool.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetPoolAsync(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetPool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPoolRequest(poolId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPool(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPool(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual Response GetPool(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetPool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetPoolRequest(poolId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdatePoolAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> UpdatePoolAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdatePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdatePoolRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdatePool(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response UpdatePool(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdatePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdatePoolRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Disables automatic scaling for a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool on which to disable automatic scaling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisablePoolAutoScaleAsync(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> DisablePoolAutoScaleAsync(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisablePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisablePoolAutoScaleRequest(poolId, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Disables automatic scaling for a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool on which to disable automatic scaling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisablePoolAutoScale(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response DisablePoolAutoScale(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisablePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisablePoolAutoScaleRequest(poolId, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Enables automatic scaling for a Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for enabling automatic scaling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You cannot enable automatic scaling on a Pool if a resize operation is in
        /// progress on the Pool. If automatic scaling of the Pool is currently disabled,
        /// you must specify a valid autoscale formula as part of the request. If automatic
        /// scaling of the Pool is already enabled, you may specify a new autoscale formula
        /// and/or a new evaluation interval. You cannot call this API for the same Pool
        /// more than once every 30 seconds.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnablePoolAutoScaleAsync(string,BatchPoolEnableAutoScaleContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> EnablePoolAutoScaleAsync(string poolId, BatchPoolEnableAutoScaleContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await EnablePoolAutoScaleAsync(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Enables automatic scaling for a Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for enabling automatic scaling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You cannot enable automatic scaling on a Pool if a resize operation is in
        /// progress on the Pool. If automatic scaling of the Pool is currently disabled,
        /// you must specify a valid autoscale formula as part of the request. If automatic
        /// scaling of the Pool is already enabled, you may specify a new autoscale formula
        /// and/or a new evaluation interval. You cannot call this API for the same Pool
        /// more than once every 30 seconds.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnablePoolAutoScale(string,BatchPoolEnableAutoScaleContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response EnablePoolAutoScale(string poolId, BatchPoolEnableAutoScaleContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = EnablePoolAutoScale(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Enables automatic scaling for a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="EnablePoolAutoScaleAsync(string,BatchPoolEnableAutoScaleContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnablePoolAutoScaleAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> EnablePoolAutoScaleAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnablePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnablePoolAutoScaleRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Enables automatic scaling for a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="EnablePoolAutoScale(string,BatchPoolEnableAutoScaleContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnablePoolAutoScale(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response EnablePoolAutoScale(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnablePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnablePoolAutoScaleRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets the result of evaluating an automatic scaling formula on the Pool. </summary>
        /// <param name="poolId"> The ID of the Pool on which to evaluate the automatic scaling formula. </param>
        /// <param name="content"> The options to use for evaluating the automatic scaling formula. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This API is primarily for validating an autoscale formula, as it simply returns
        /// the result without applying the formula to the Pool. The Pool must have auto
        /// scaling enabled in order to evaluate a formula.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EvaluatePoolAutoScaleAsync(string,BatchPoolEvaluateAutoScaleContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<AutoScaleRun>> EvaluatePoolAutoScaleAsync(string poolId, BatchPoolEvaluateAutoScaleContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await EvaluatePoolAutoScaleAsync(poolId, content0, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(AutoScaleRun.FromResponse(response), response);
        }

        /// <summary> Gets the result of evaluating an automatic scaling formula on the Pool. </summary>
        /// <param name="poolId"> The ID of the Pool on which to evaluate the automatic scaling formula. </param>
        /// <param name="content"> The options to use for evaluating the automatic scaling formula. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This API is primarily for validating an autoscale formula, as it simply returns
        /// the result without applying the formula to the Pool. The Pool must have auto
        /// scaling enabled in order to evaluate a formula.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EvaluatePoolAutoScale(string,BatchPoolEvaluateAutoScaleContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<AutoScaleRun> EvaluatePoolAutoScale(string poolId, BatchPoolEvaluateAutoScaleContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = EvaluatePoolAutoScale(poolId, content0, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(AutoScaleRun.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets the result of evaluating an automatic scaling formula on the Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="EvaluatePoolAutoScaleAsync(string,BatchPoolEvaluateAutoScaleContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool on which to evaluate the automatic scaling formula. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EvaluatePoolAutoScaleAsync(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> EvaluatePoolAutoScaleAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EvaluatePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEvaluatePoolAutoScaleRequest(poolId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets the result of evaluating an automatic scaling formula on the Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="EvaluatePoolAutoScale(string,BatchPoolEvaluateAutoScaleContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool on which to evaluate the automatic scaling formula. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EvaluatePoolAutoScale(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response EvaluatePoolAutoScale(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EvaluatePoolAutoScale");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEvaluatePoolAutoScaleRequest(poolId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Changes the number of Compute Nodes that are assigned to a Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for resizing the pool. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can only resize a Pool when its allocation state is steady. If the Pool is
        /// already resizing, the request fails with status code 409. When you resize a
        /// Pool, the Pool's allocation state changes from steady to resizing. You cannot
        /// resize Pools which are configured for automatic scaling. If you try to do this,
        /// the Batch service returns an error 409. If you resize a Pool downwards, the
        /// Batch service chooses which Compute Nodes to remove. To remove specific Compute
        /// Nodes, use the Pool remove Compute Nodes API instead.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ResizePoolAsync(string,BatchPoolResizeContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> ResizePoolAsync(string poolId, BatchPoolResizeContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ResizePoolAsync(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Changes the number of Compute Nodes that are assigned to a Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for resizing the pool. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can only resize a Pool when its allocation state is steady. If the Pool is
        /// already resizing, the request fails with status code 409. When you resize a
        /// Pool, the Pool's allocation state changes from steady to resizing. You cannot
        /// resize Pools which are configured for automatic scaling. If you try to do this,
        /// the Batch service returns an error 409. If you resize a Pool downwards, the
        /// Batch service chooses which Compute Nodes to remove. To remove specific Compute
        /// Nodes, use the Pool remove Compute Nodes API instead.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ResizePool(string,BatchPoolResizeContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response ResizePool(string poolId, BatchPoolResizeContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ResizePool(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Changes the number of Compute Nodes that are assigned to a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ResizePoolAsync(string,BatchPoolResizeContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ResizePoolAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> ResizePoolAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ResizePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateResizePoolRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Changes the number of Compute Nodes that are assigned to a Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ResizePool(string,BatchPoolResizeContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ResizePool(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response ResizePool(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ResizePool");
            scope.Start();
            try
            {
                using HttpMessage message = CreateResizePoolRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Stops an ongoing resize operation on the Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='StopPoolResizeAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> StopPoolResizeAsync(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.StopPoolResize");
            scope.Start();
            try
            {
                using HttpMessage message = CreateStopPoolResizeRequest(poolId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Stops an ongoing resize operation on the Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='StopPoolResize(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response StopPoolResize(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.StopPoolResize");
            scope.Start();
            try
            {
                using HttpMessage message = CreateStopPoolResizeRequest(poolId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Updates the properties of the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to update. </param>
        /// <param name="pool"> The options to use for replacing properties on the pool. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="pool"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Pool. For example, if
        /// the Pool has a StartTask associated with it and if StartTask is not specified
        /// with this request, then the Batch service will remove the existing StartTask.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplacePoolPropertiesAsync(string,BatchPoolReplaceContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> ReplacePoolPropertiesAsync(string poolId, BatchPoolReplaceContent pool, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(pool, nameof(pool));

            using RequestContent content = pool.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ReplacePoolPropertiesAsync(poolId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Updates the properties of the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to update. </param>
        /// <param name="pool"> The options to use for replacing properties on the pool. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="pool"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Pool. For example, if
        /// the Pool has a StartTask associated with it and if StartTask is not specified
        /// with this request, then the Batch service will remove the existing StartTask.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplacePoolProperties(string,BatchPoolReplaceContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response ReplacePoolProperties(string poolId, BatchPoolReplaceContent pool, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(pool, nameof(pool));

            using RequestContent content = pool.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ReplacePoolProperties(poolId, content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplacePoolPropertiesAsync(string,BatchPoolReplaceContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplacePoolPropertiesAsync(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> ReplacePoolPropertiesAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplacePoolProperties");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplacePoolPropertiesRequest(poolId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplacePoolProperties(string,BatchPoolReplaceContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplacePoolProperties(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response ReplacePoolProperties(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplacePoolProperties");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplacePoolPropertiesRequest(poolId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Removes Compute Nodes from the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for removing the node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation can only run when the allocation state of the Pool is steady.
        /// When this operation runs, the allocation state changes from steady to resizing.
        /// Each request may remove up to 100 nodes.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RemoveNodesAsync(string,BatchNodeRemoveContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> RemoveNodesAsync(string poolId, BatchNodeRemoveContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await RemoveNodesAsync(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Removes Compute Nodes from the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The options to use for removing the node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation can only run when the allocation state of the Pool is steady.
        /// When this operation runs, the allocation state changes from steady to resizing.
        /// Each request may remove up to 100 nodes.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RemoveNodes(string,BatchNodeRemoveContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response RemoveNodes(string poolId, BatchNodeRemoveContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = RemoveNodes(poolId, content0, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Removes Compute Nodes from the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="RemoveNodesAsync(string,BatchNodeRemoveContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RemoveNodesAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> RemoveNodesAsync(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.RemoveNodes");
            scope.Start();
            try
            {
                using HttpMessage message = CreateRemoveNodesRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Removes Compute Nodes from the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="RemoveNodes(string,BatchNodeRemoveContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool to get. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RemoveNodes(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response RemoveNodes(string poolId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.RemoveNodes");
            scope.Start();
            try
            {
                using HttpMessage message = CreateRemoveNodesRequest(poolId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteJobAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DeleteJobAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteJobRequest(jobId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteJob(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DeleteJob(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteJobRequest(jobId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BatchJob>> GetJobAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetJobAsync(jobId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(BatchJob.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJob(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual Response<BatchJob> GetJob(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetJob(jobId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
            return Response.FromValue(BatchJob.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetJobAsync(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobRequest(jobId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJob(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJob(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual Response GetJob(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobRequest(jobId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdateJobAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> UpdateJobAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdateJob(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response UpdateJob(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Updates the properties of the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="job"> A job with updated properties. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="job"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Job. For example, if
        /// the Job has constraints associated with it and if constraints is not specified
        /// with this request, then the Batch service will remove the existing constraints.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobAsync(string,BatchJob,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> ReplaceJobAsync(string jobId, BatchJob job, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(job, nameof(job));

            using RequestContent content = job.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ReplaceJobAsync(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Updates the properties of the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="job"> A job with updated properties. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="job"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Job. For example, if
        /// the Job has constraints associated with it and if constraints is not specified
        /// with this request, then the Batch service will remove the existing constraints.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJob(string,BatchJob,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response ReplaceJob(string jobId, BatchJob job, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(job, nameof(job));

            using RequestContent content = job.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ReplaceJob(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceJobAsync(string,BatchJob,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> ReplaceJobAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceJob(string,BatchJob,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job whose properties you want to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJob(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response ReplaceJob(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Disables the specified Job, preventing new Tasks from running. </summary>
        /// <param name="jobId"> The ID of the Job to disable. </param>
        /// <param name="content"> The options to use for disabling the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// The Batch Service immediately moves the Job to the disabling state. Batch then
        /// uses the disableTasks parameter to determine what to do with the currently
        /// running Tasks of the Job. The Job remains in the disabling state until the
        /// disable operation is completed and all Tasks have been dealt with according to
        /// the disableTasks option; the Job then moves to the disabled state. No new Tasks
        /// are started under the Job until it moves back to active state. If you try to
        /// disable a Job that is in any state other than active, disabling, or disabled,
        /// the request fails with status code 409.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJobAsync(string,BatchJobDisableContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> DisableJobAsync(string jobId, BatchJobDisableContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await DisableJobAsync(jobId, content0, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Disables the specified Job, preventing new Tasks from running. </summary>
        /// <param name="jobId"> The ID of the Job to disable. </param>
        /// <param name="content"> The options to use for disabling the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// The Batch Service immediately moves the Job to the disabling state. Batch then
        /// uses the disableTasks parameter to determine what to do with the currently
        /// running Tasks of the Job. The Job remains in the disabling state until the
        /// disable operation is completed and all Tasks have been dealt with according to
        /// the disableTasks option; the Job then moves to the disabled state. No new Tasks
        /// are started under the Job until it moves back to active state. If you try to
        /// disable a Job that is in any state other than active, disabling, or disabled,
        /// the request fails with status code 409.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJob(string,BatchJobDisableContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response DisableJob(string jobId, BatchJobDisableContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = DisableJob(jobId, content0, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Disables the specified Job, preventing new Tasks from running.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DisableJobAsync(string,BatchJobDisableContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to disable. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJobAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DisableJobAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Disables the specified Job, preventing new Tasks from running.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DisableJob(string,BatchJobDisableContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to disable. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJob(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DisableJob(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables the specified Job, allowing new Tasks to run.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to enable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableJobAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> EnableJobAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableJobRequest(jobId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables the specified Job, allowing new Tasks to run.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to enable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableJob(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response EnableJob(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableJobRequest(jobId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Terminates the specified Job, marking it as completed. </summary>
        /// <param name="jobId"> The ID of the Job to terminate. </param>
        /// <param name="parameters"> The options to use for terminating the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// When a Terminate Job request is received, the Batch service sets the Job to the
        /// terminating state. The Batch service then terminates any running Tasks
        /// associated with the Job and runs any required Job release Tasks. Then the Job
        /// moves into the completed state. If there are any Tasks in the Job in the active
        /// state, they will remain in the active state. Once a Job is terminated, new
        /// Tasks cannot be added and any remaining active Tasks will not be scheduled.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJobAsync(string,BatchJobTerminateContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> TerminateJobAsync(string jobId, BatchJobTerminateContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await TerminateJobAsync(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Terminates the specified Job, marking it as completed. </summary>
        /// <param name="jobId"> The ID of the Job to terminate. </param>
        /// <param name="parameters"> The options to use for terminating the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// When a Terminate Job request is received, the Batch service sets the Job to the
        /// terminating state. The Batch service then terminates any running Tasks
        /// associated with the Job and runs any required Job release Tasks. Then the Job
        /// moves into the completed state. If there are any Tasks in the Job in the active
        /// state, they will remain in the active state. Once a Job is terminated, new
        /// Tasks cannot be added and any remaining active Tasks will not be scheduled.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJob(string,BatchJobTerminateContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response TerminateJob(string jobId, BatchJobTerminateContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = TerminateJob(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Terminates the specified Job, marking it as completed.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="TerminateJobAsync(string,BatchJobTerminateContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to terminate. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJobAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> TerminateJobAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Terminates the specified Job, marking it as completed.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="TerminateJob(string,BatchJobTerminateContent,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to terminate. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJob(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response TerminateJob(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateJobRequest(jobId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a Job to the specified Account. </summary>
        /// <param name="job"> The Job to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="job"/> is null. </exception>
        /// <remarks>
        /// The Batch service supports two ways to control the work done as part of a Job.
        /// In the first approach, the user specifies a Job Manager Task. The Batch service
        /// launches this Task when it is ready to start the Job. The Job Manager Task
        /// controls all other Tasks that run under this Job, by using the Task APIs. In
        /// the second approach, the user directly controls the execution of Tasks under an
        /// active Job, by using the Task APIs. Also note: when naming Jobs, avoid
        /// including sensitive information such as user names or secret project names.
        /// This information may appear in telemetry logs accessible to Microsoft Support
        /// engineers.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobAsync(BatchJobCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateJobAsync(BatchJobCreateContent job, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(job, nameof(job));

            using RequestContent content = job.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateJobAsync(content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Creates a Job to the specified Account. </summary>
        /// <param name="job"> The Job to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="job"/> is null. </exception>
        /// <remarks>
        /// The Batch service supports two ways to control the work done as part of a Job.
        /// In the first approach, the user specifies a Job Manager Task. The Batch service
        /// launches this Task when it is ready to start the Job. The Job Manager Task
        /// controls all other Tasks that run under this Job, by using the Task APIs. In
        /// the second approach, the user directly controls the execution of Tasks under an
        /// active Job, by using the Task APIs. Also note: when naming Jobs, avoid
        /// including sensitive information such as user names or secret project names.
        /// This information may appear in telemetry logs accessible to Microsoft Support
        /// engineers.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJob(BatchJobCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response CreateJob(BatchJobCreateContent job, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(job, nameof(job));

            using RequestContent content = job.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateJob(content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Creates a Job to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateJobAsync(BatchJobCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobAsync(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreateJobAsync(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateJobRequest(content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Creates a Job to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateJob(BatchJobCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJob(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreateJob(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateJob");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateJobRequest(content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets the Task counts for the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Task counts provide a count of the Tasks by active, running or completed Task
        /// state, and a count of Tasks which succeeded or failed. Tasks in the preparing
        /// state are counted as running. Note that the numbers returned may not always be
        /// up to date. If you need exact task counts, use a list query.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobTaskCountsAsync(string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<BatchTaskCountsResult>> GetJobTaskCountsAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetJobTaskCountsAsync(jobId, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(BatchTaskCountsResult.FromResponse(response), response);
        }

        /// <summary> Gets the Task counts for the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Task counts provide a count of the Tasks by active, running or completed Task
        /// state, and a count of Tasks which succeeded or failed. Tasks in the preparing
        /// state are counted as running. Note that the numbers returned may not always be
        /// up to date. If you need exact task counts, use a list query.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobTaskCounts(string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<BatchTaskCountsResult> GetJobTaskCounts(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetJobTaskCounts(jobId, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(BatchTaskCountsResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets the Task counts for the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobTaskCountsAsync(string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobTaskCountsAsync(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> GetJobTaskCountsAsync(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJobTaskCounts");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobTaskCountsRequest(jobId, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets the Task counts for the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobTaskCounts(string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobTaskCounts(string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response GetJobTaskCounts(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJobTaskCounts");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobTaskCountsRequest(jobId, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Job Schedule from the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteJobScheduleAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DeleteJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Job Schedule from the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteJobSchedule(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DeleteJobSchedule(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobScheduleAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BatchJobSchedule>> GetJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetJobScheduleAsync(jobScheduleId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(BatchJobSchedule.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedule(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual Response<BatchJobSchedule> GetJobSchedule(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetJobSchedule(jobScheduleId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
            return Response.FromValue(BatchJobSchedule.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobScheduleAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobScheduleAsync(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobSchedule(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to get. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedule(string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual Response GetJobSchedule(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdateJobScheduleAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> UpdateJobScheduleAsync(string jobScheduleId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateJobScheduleRequest(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UpdateJobSchedule(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response UpdateJobSchedule(string jobScheduleId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UpdateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUpdateJobScheduleRequest(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Updates the properties of the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="jobSchedule"> A Job Schedule with updated properties. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="jobSchedule"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Job Schedule. For
        /// example, if the schedule property is not specified with this request, then the
        /// Batch service will remove the existing schedule. Changes to a Job Schedule only
        /// impact Jobs created by the schedule after the update has taken place; currently
        /// running Jobs are unaffected.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobScheduleAsync(string,BatchJobSchedule,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> ReplaceJobScheduleAsync(string jobScheduleId, BatchJobSchedule jobSchedule, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(jobSchedule, nameof(jobSchedule));

            using RequestContent content = jobSchedule.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ReplaceJobScheduleAsync(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Updates the properties of the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="jobSchedule"> A Job Schedule with updated properties. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="jobSchedule"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This fully replaces all the updatable properties of the Job Schedule. For
        /// example, if the schedule property is not specified with this request, then the
        /// Batch service will remove the existing schedule. Changes to a Job Schedule only
        /// impact Jobs created by the schedule after the update has taken place; currently
        /// running Jobs are unaffected.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobSchedule(string,BatchJobSchedule,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response ReplaceJobSchedule(string jobScheduleId, BatchJobSchedule jobSchedule, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(jobSchedule, nameof(jobSchedule));

            using RequestContent content = jobSchedule.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ReplaceJobSchedule(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceJobScheduleAsync(string,BatchJobSchedule,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobScheduleAsync(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> ReplaceJobScheduleAsync(string jobScheduleId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceJobScheduleRequest(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceJobSchedule(string,BatchJobSchedule,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceJobSchedule(string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response ReplaceJobSchedule(string jobScheduleId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceJobScheduleRequest(jobScheduleId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Disables a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to disable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJobScheduleAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DisableJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Disables a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to disable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableJobSchedule(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DisableJobSchedule(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to enable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableJobScheduleAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> EnableJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to enable. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableJobSchedule(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response EnableJobSchedule(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Terminates a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to terminates. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJobScheduleAsync(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> TerminateJobScheduleAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Terminates a Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule to terminates. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateJobSchedule(string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response TerminateJobSchedule(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateJobScheduleRequest(jobScheduleId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a Job Schedule to the specified Account. </summary>
        /// <param name="jobSchedule"> The Job Schedule to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobSchedule"/> is null. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobScheduleAsync(BatchJobScheduleCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateJobScheduleAsync(BatchJobScheduleCreateContent jobSchedule, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(jobSchedule, nameof(jobSchedule));

            using RequestContent content = jobSchedule.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateJobScheduleAsync(content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Creates a Job Schedule to the specified Account. </summary>
        /// <param name="jobSchedule"> The Job Schedule to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobSchedule"/> is null. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobSchedule(BatchJobScheduleCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response CreateJobSchedule(BatchJobScheduleCreateContent jobSchedule, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(jobSchedule, nameof(jobSchedule));

            using RequestContent content = jobSchedule.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateJobSchedule(content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Creates a Job Schedule to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateJobScheduleAsync(BatchJobScheduleCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobScheduleAsync(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreateJobScheduleAsync(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateJobScheduleRequest(content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Creates a Job Schedule to the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateJobSchedule(BatchJobScheduleCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateJobSchedule(RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreateJobSchedule(RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateJobSchedule");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateJobScheduleRequest(content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Creates a Task to the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job to which the Task is to be created. </param>
        /// <param name="task"> The Task to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="task"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// The maximum lifetime of a Task from addition to completion is 180 days. If a
        /// Task has not completed within 180 days of being added it will be terminated by
        /// the Batch service and left in whatever state it was in at that time.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskAsync(string,BatchTaskCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateTaskAsync(string jobId, BatchTaskCreateContent task, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(task, nameof(task));

            using RequestContent content = task.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateTaskAsync(jobId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Creates a Task to the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job to which the Task is to be created. </param>
        /// <param name="task"> The Task to be created. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="task"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// The maximum lifetime of a Task from addition to completion is 180 days. If a
        /// Task has not completed within 180 days of being added it will be terminated by
        /// the Batch service and left in whatever state it was in at that time.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTask(string,BatchTaskCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response CreateTask(string jobId, BatchTaskCreateContent task, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(task, nameof(task));

            using RequestContent content = task.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateTask(jobId, content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Creates a Task to the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateTaskAsync(string,BatchTaskCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to which the Task is to be created. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskAsync(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreateTaskAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateTaskRequest(jobId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Creates a Task to the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateTask(string,BatchTaskCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to which the Task is to be created. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTask(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreateTask(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateTaskRequest(jobId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Adds a collection of Tasks to the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job to which the Task collection is to be added. </param>
        /// <param name="taskCollection"> The Tasks to be added. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskCollection"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Note that each Task must have a unique ID. The Batch service may not return the
        /// results for each Task in the same order the Tasks were submitted in this
        /// request. If the server times out or the connection is closed during the
        /// request, the request may have been partially or fully processed, or not at all.
        /// In such cases, the user should re-issue the request. Note that it is up to the
        /// user to correctly handle failures when re-issuing a request. For example, you
        /// should use the same Task IDs during a retry so that if the prior operation
        /// succeeded, the retry will not create extra Tasks unexpectedly. If the response
        /// contains any Tasks which failed to add, a client can retry the request. In a
        /// retry, it is most efficient to resubmit only Tasks that failed to add, and to
        /// omit Tasks that were successfully added on the first attempt. The maximum
        /// lifetime of a Task from addition to completion is 180 days. If a Task has not
        /// completed within 180 days of being added it will be terminated by the Batch
        /// service and left in whatever state it was in at that time.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskCollectionAsync(string,BatchTaskGroup,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<BatchTaskAddCollectionResult>> CreateTaskCollectionAsync(string jobId, BatchTaskGroup taskCollection, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(taskCollection, nameof(taskCollection));

            using RequestContent content = taskCollection.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateTaskCollectionAsync(jobId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(BatchTaskAddCollectionResult.FromResponse(response), response);
        }

        /// <summary> Adds a collection of Tasks to the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job to which the Task collection is to be added. </param>
        /// <param name="taskCollection"> The Tasks to be added. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskCollection"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Note that each Task must have a unique ID. The Batch service may not return the
        /// results for each Task in the same order the Tasks were submitted in this
        /// request. If the server times out or the connection is closed during the
        /// request, the request may have been partially or fully processed, or not at all.
        /// In such cases, the user should re-issue the request. Note that it is up to the
        /// user to correctly handle failures when re-issuing a request. For example, you
        /// should use the same Task IDs during a retry so that if the prior operation
        /// succeeded, the retry will not create extra Tasks unexpectedly. If the response
        /// contains any Tasks which failed to add, a client can retry the request. In a
        /// retry, it is most efficient to resubmit only Tasks that failed to add, and to
        /// omit Tasks that were successfully added on the first attempt. The maximum
        /// lifetime of a Task from addition to completion is 180 days. If a Task has not
        /// completed within 180 days of being added it will be terminated by the Batch
        /// service and left in whatever state it was in at that time.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskCollection(string,BatchTaskGroup,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<BatchTaskAddCollectionResult> CreateTaskCollection(string jobId, BatchTaskGroup taskCollection, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(taskCollection, nameof(taskCollection));

            using RequestContent content = taskCollection.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateTaskCollection(jobId, content, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(BatchTaskAddCollectionResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Adds a collection of Tasks to the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateTaskCollectionAsync(string,BatchTaskGroup,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to which the Task collection is to be added. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskCollectionAsync(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreateTaskCollectionAsync(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateTaskCollection");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateTaskCollectionRequest(jobId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Adds a collection of Tasks to the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateTaskCollection(string,BatchTaskGroup,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job to which the Task collection is to be added. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateTaskCollection(string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreateTaskCollection(string jobId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateTaskCollection");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateTaskCollectionRequest(jobId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Task from the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job from which to delete the Task. </param>
        /// <param name="taskId"> The ID of the Task to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteTaskAsync(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> DeleteTaskAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a Task from the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job from which to delete the Task. </param>
        /// <param name="taskId"> The ID of the Task to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteTask(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response DeleteTask(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Task. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// For multi-instance Tasks, information such as affinityId, executionInfo and
        /// nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        /// information about subtasks.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BatchTask>> GetTaskAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetTaskAsync(jobId, taskId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(BatchTask.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Task. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// For multi-instance Tasks, information such as affinityId, executionInfo and
        /// nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        /// information about subtasks.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTask(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)']/*" />
        public virtual Response<BatchTask> GetTask(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetTask(jobId, taskId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
            return Response.FromValue(BatchTask.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTaskAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetTaskAsync(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTask(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTask(string,string,int?,DateTimeOffset?,IEnumerable{string},IEnumerable{string},RequestConditions,RequestContext)']/*" />
        public virtual Response GetTask(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, expand, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Updates the properties of the specified Task. </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to update. </param>
        /// <param name="task"> The Task to update. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="task"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceTaskAsync(string,string,BatchTask,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response> ReplaceTaskAsync(string jobId, string taskId, BatchTask task, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNull(task, nameof(task));

            using RequestContent content = task.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ReplaceTaskAsync(jobId, taskId, content, timeOutInSeconds, ocpdate, requestConditions, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Updates the properties of the specified Task. </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to update. </param>
        /// <param name="task"> The Task to update. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="task"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceTask(string,string,BatchTask,int?,DateTimeOffset?,RequestConditions,CancellationToken)']/*" />
        public virtual Response ReplaceTask(string jobId, string taskId, BatchTask task, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNull(task, nameof(task));

            using RequestContent content = task.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ReplaceTask(jobId, taskId, content, timeOutInSeconds, ocpdate, requestConditions, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceTaskAsync(string,string,BatchTask,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceTaskAsync(string,string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> ReplaceTaskAsync(string jobId, string taskId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceTaskRequest(jobId, taskId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the properties of the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceTask(string,string,BatchTask,int?,DateTimeOffset?,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceTask(string,string,RequestContent,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response ReplaceTask(string jobId, string taskId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceTaskRequest(jobId, taskId, content, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Terminates the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to terminate. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateTaskAsync(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> TerminateTaskAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Terminates the specified Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to terminate. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='TerminateTask(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response TerminateTask(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.TerminateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateTerminateTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Reactivates a Task, allowing it to run again even if its retry count has been
        /// exhausted.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to reactivate. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReactivateTaskAsync(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> ReactivateTaskAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReactivateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReactivateTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Reactivates a Task, allowing it to run again even if its retry count has been
        /// exhausted.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job containing the Task. </param>
        /// <param name="taskId"> The ID of the Task to reactivate. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReactivateTask(string,string,int?,DateTimeOffset?,RequestConditions,RequestContext)']/*" />
        public virtual Response ReactivateTask(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReactivateTask");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReactivateTaskRequest(jobId, taskId, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes the specified Task file from the Compute Node where the Task ran.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="recursive">
        /// Whether to delete children of a directory. If the filePath parameter represents
        /// a directory instead of a file, you can set recursive to true to delete the
        /// directory and all of the files and subdirectories in it. If recursive is false
        /// then the directory must be empty or deletion will fail.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteTaskFileAsync(string,string,string,int?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> DeleteTaskFileAsync(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, bool? recursive = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteTaskFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteTaskFileRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, recursive, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes the specified Task file from the Compute Node where the Task ran.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="recursive">
        /// Whether to delete children of a directory. If the filePath parameter represents
        /// a directory instead of a file, you can set recursive to true to delete the
        /// directory and all of the files and subdirectories in it. If recursive is false
        /// then the directory must be empty or deletion will fail.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteTaskFile(string,string,string,int?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual Response DeleteTaskFile(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, bool? recursive = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteTaskFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteTaskFileRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, recursive, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Returns the content of the specified Task file. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BinaryData>> GetTaskFileAsync(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, string ocpRange = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetTaskFileAsync(jobId, taskId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(response.Content, response);
        }

        /// <summary> Returns the content of the specified Task file. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)']/*" />
        public virtual Response<BinaryData> GetTaskFile(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, string ocpRange = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetTaskFile(jobId, taskId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
            return Response.FromValue(response.Content, response);
        }

        /// <summary>
        /// [Protocol Method] Returns the content of the specified Task file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTaskFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetTaskFileAsync(string jobId, string taskId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTaskFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskFileRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Returns the content of the specified Task file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTaskFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,RequestContext)']/*" />
        public virtual Response GetTaskFile(string jobId, string taskId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTaskFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskFileRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Gets the properties of the specified Task file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> GetTaskFilePropertiesInternalAsync(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTaskFilePropertiesInternal");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskFilePropertiesInternalRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Gets the properties of the specified Task file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose file you want to retrieve. </param>
        /// <param name="filePath"> The path to the Task file that you want to get the content of. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/>, <paramref name="taskId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response GetTaskFilePropertiesInternal(string jobId, string taskId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetTaskFilePropertiesInternal");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetTaskFilePropertiesInternalRequest(jobId, taskId, filePath, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Adds a user Account to the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to create a user Account. </param>
        /// <param name="user"> The options to use for creating the user. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="user"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can add a user Account to a Compute Node only when it is in the idle or
        /// running state.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateNodeUserAsync(string,string,BatchNodeUserCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> CreateNodeUserAsync(string poolId, string nodeId, BatchNodeUserCreateContent user, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(user, nameof(user));

            using RequestContent content = user.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await CreateNodeUserAsync(poolId, nodeId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Adds a user Account to the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to create a user Account. </param>
        /// <param name="user"> The options to use for creating the user. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="user"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can add a user Account to a Compute Node only when it is in the idle or
        /// running state.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateNodeUser(string,string,BatchNodeUserCreateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response CreateNodeUser(string poolId, string nodeId, BatchNodeUserCreateContent user, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(user, nameof(user));

            using RequestContent content = user.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = CreateNodeUser(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Adds a user Account to the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateNodeUserAsync(string,string,BatchNodeUserCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to create a user Account. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateNodeUserAsync(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> CreateNodeUserAsync(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateNodeUserRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Adds a user Account to the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="CreateNodeUser(string,string,BatchNodeUserCreateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to create a user Account. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='CreateNodeUser(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response CreateNodeUser(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.CreateNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateCreateNodeUserRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a user Account from the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to delete a user Account. </param>
        /// <param name="userName"> The name of the user Account to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteNodeUserAsync(string,string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> DeleteNodeUserAsync(string poolId, string nodeId, string userName, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteNodeUserRequest(poolId, nodeId, userName, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes a user Account from the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to delete a user Account. </param>
        /// <param name="userName"> The name of the user Account to delete. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteNodeUser(string,string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response DeleteNodeUser(string poolId, string nodeId, string userName, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteNodeUserRequest(poolId, nodeId, userName, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Updates the password and expiration time of a user Account on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to update a user Account. </param>
        /// <param name="userName"> The name of the user Account to update. </param>
        /// <param name="content"> The options to use for updating the user. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/>, <paramref name="userName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation replaces of all the updatable properties of the Account. For
        /// example, if the expiryTime element is not specified, the current value is
        /// replaced with the default value, not left unmodified. You can update a user
        /// Account on a Compute Node only when it is in the idle or running state.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceNodeUserAsync(string,string,string,BatchNodeUserUpdateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> ReplaceNodeUserAsync(string poolId, string nodeId, string userName, BatchNodeUserUpdateContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await ReplaceNodeUserAsync(poolId, nodeId, userName, content0, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Updates the password and expiration time of a user Account on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to update a user Account. </param>
        /// <param name="userName"> The name of the user Account to update. </param>
        /// <param name="content"> The options to use for updating the user. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/>, <paramref name="userName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This operation replaces of all the updatable properties of the Account. For
        /// example, if the expiryTime element is not specified, the current value is
        /// replaced with the default value, not left unmodified. You can update a user
        /// Account on a Compute Node only when it is in the idle or running state.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceNodeUser(string,string,string,BatchNodeUserUpdateContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response ReplaceNodeUser(string poolId, string nodeId, string userName, BatchNodeUserUpdateContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = ReplaceNodeUser(poolId, nodeId, userName, content0, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Updates the password and expiration time of a user Account on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceNodeUserAsync(string,string,string,BatchNodeUserUpdateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to update a user Account. </param>
        /// <param name="userName"> The name of the user Account to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/>, <paramref name="userName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceNodeUserAsync(string,string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> ReplaceNodeUserAsync(string poolId, string nodeId, string userName, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceNodeUserRequest(poolId, nodeId, userName, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Updates the password and expiration time of a user Account on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="ReplaceNodeUser(string,string,string,BatchNodeUserUpdateContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the machine on which you want to update a user Account. </param>
        /// <param name="userName"> The name of the user Account to update. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/>, <paramref name="userName"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="userName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='ReplaceNodeUser(string,string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response ReplaceNodeUser(string poolId, string nodeId, string userName, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(userName, nameof(userName));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.ReplaceNodeUser");
            scope.Start();
            try
            {
                using HttpMessage message = CreateReplaceNodeUserRequest(poolId, nodeId, userName, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual async Task<Response<BatchNode>> GetNodeAsync(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetNodeAsync(poolId, nodeId, timeOutInSeconds, ocpdate, select, context).ConfigureAwait(false);
            return Response.FromValue(BatchNode.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNode(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual Response<BatchNode> GetNode(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetNode(poolId, nodeId, timeOutInSeconds, ocpdate, select, context);
            return Response.FromValue(BatchNode.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual async Task<Response> GetNodeAsync(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNode");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeRequest(poolId, nodeId, timeOutInSeconds, ocpdate, select, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNode(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNode(string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual Response GetNode(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNode");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeRequest(poolId, nodeId, timeOutInSeconds, ocpdate, select, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Restarts the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to restart. </param>
        /// <param name="parameters"> The options to use for rebooting the Compute Node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks> You can restart a Compute Node only if it is in an idle or running state. </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RebootNodeAsync(string,string,BatchNodeRebootContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> RebootNodeAsync(string poolId, string nodeId, BatchNodeRebootContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await RebootNodeAsync(poolId, nodeId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Restarts the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to restart. </param>
        /// <param name="parameters"> The options to use for rebooting the Compute Node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks> You can restart a Compute Node only if it is in an idle or running state. </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RebootNode(string,string,BatchNodeRebootContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response RebootNode(string poolId, string nodeId, BatchNodeRebootContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = RebootNode(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Restarts the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="RebootNodeAsync(string,string,BatchNodeRebootContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to restart. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RebootNodeAsync(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> RebootNodeAsync(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.RebootNode");
            scope.Start();
            try
            {
                using HttpMessage message = CreateRebootNodeRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Restarts the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="RebootNode(string,string,BatchNodeRebootContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to restart. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='RebootNode(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response RebootNode(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.RebootNode");
            scope.Start();
            try
            {
                using HttpMessage message = CreateRebootNodeRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Disables Task scheduling on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to disable Task scheduling. </param>
        /// <param name="parameters"> The options to use for disabling scheduling on the Compute Node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can disable Task scheduling on a Compute Node only if its current
        /// scheduling state is enabled.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableNodeSchedulingAsync(string,string,BatchNodeDisableSchedulingContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response> DisableNodeSchedulingAsync(string poolId, string nodeId, BatchNodeDisableSchedulingContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await DisableNodeSchedulingAsync(poolId, nodeId, content, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return response;
        }

        /// <summary> Disables Task scheduling on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to disable Task scheduling. </param>
        /// <param name="parameters"> The options to use for disabling scheduling on the Compute Node. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// You can disable Task scheduling on a Compute Node only if its current
        /// scheduling state is enabled.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableNodeScheduling(string,string,BatchNodeDisableSchedulingContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response DisableNodeScheduling(string poolId, string nodeId, BatchNodeDisableSchedulingContent parameters = null, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using RequestContent content = parameters?.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = DisableNodeScheduling(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
            return response;
        }

        /// <summary>
        /// [Protocol Method] Disables Task scheduling on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DisableNodeSchedulingAsync(string,string,BatchNodeDisableSchedulingContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to disable Task scheduling. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableNodeSchedulingAsync(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> DisableNodeSchedulingAsync(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableNodeScheduling");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableNodeSchedulingRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Disables Task scheduling on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="DisableNodeScheduling(string,string,BatchNodeDisableSchedulingContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to disable Task scheduling. </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DisableNodeScheduling(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response DisableNodeScheduling(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DisableNodeScheduling");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDisableNodeSchedulingRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables Task scheduling on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to enable Task scheduling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableNodeSchedulingAsync(string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> EnableNodeSchedulingAsync(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableNodeScheduling");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableNodeSchedulingRequest(poolId, nodeId, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Enables Task scheduling on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node on which you want to enable Task scheduling. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='EnableNodeScheduling(string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response EnableNodeScheduling(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.EnableNodeScheduling");
            scope.Start();
            try
            {
                using HttpMessage message = CreateEnableNodeSchedulingRequest(poolId, nodeId, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets the settings required for remote login to a Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node for which to obtain the remote login settings. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Before you can remotely login to a Compute Node using the remote login
        /// settings, you must create a user Account on the Compute Node. This API can be
        /// invoked only on Pools created with the virtual machine configuration property.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeRemoteLoginSettingsAsync(string,string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<BatchNodeRemoteLoginSettings>> GetNodeRemoteLoginSettingsAsync(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetNodeRemoteLoginSettingsAsync(poolId, nodeId, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(BatchNodeRemoteLoginSettings.FromResponse(response), response);
        }

        /// <summary> Gets the settings required for remote login to a Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node for which to obtain the remote login settings. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// Before you can remotely login to a Compute Node using the remote login
        /// settings, you must create a user Account on the Compute Node. This API can be
        /// invoked only on Pools created with the virtual machine configuration property.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeRemoteLoginSettings(string,string,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<BatchNodeRemoteLoginSettings> GetNodeRemoteLoginSettings(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetNodeRemoteLoginSettings(poolId, nodeId, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(BatchNodeRemoteLoginSettings.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets the settings required for remote login to a Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeRemoteLoginSettingsAsync(string,string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node for which to obtain the remote login settings. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeRemoteLoginSettingsAsync(string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> GetNodeRemoteLoginSettingsAsync(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeRemoteLoginSettings");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeRemoteLoginSettingsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets the settings required for remote login to a Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeRemoteLoginSettings(string,string,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node for which to obtain the remote login settings. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeRemoteLoginSettings(string,string,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response GetNodeRemoteLoginSettings(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeRemoteLoginSettings");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeRemoteLoginSettingsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Upload Azure Batch service log files from the specified Compute Node to Azure
        /// Blob Storage.
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId">
        /// The ID of the Compute Node for which you want to get the Remote Desktop
        /// Protocol file.
        /// </param>
        /// <param name="content"> The Azure Batch service log files upload options. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This is for gathering Azure Batch service log files in an automated fashion
        /// from Compute Nodes if you are experiencing an error and wish to escalate to
        /// Azure support. The Azure Batch service log files should be shared with Azure
        /// support to aid in debugging issues with the Batch service.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UploadNodeLogsAsync(string,string,UploadBatchServiceLogsContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual async Task<Response<UploadBatchServiceLogsResult>> UploadNodeLogsAsync(string poolId, string nodeId, UploadBatchServiceLogsContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await UploadNodeLogsAsync(poolId, nodeId, content0, timeOutInSeconds, ocpdate, context).ConfigureAwait(false);
            return Response.FromValue(UploadBatchServiceLogsResult.FromResponse(response), response);
        }

        /// <summary>
        /// Upload Azure Batch service log files from the specified Compute Node to Azure
        /// Blob Storage.
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId">
        /// The ID of the Compute Node for which you want to get the Remote Desktop
        /// Protocol file.
        /// </param>
        /// <param name="content"> The Azure Batch service log files upload options. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This is for gathering Azure Batch service log files in an automated fashion
        /// from Compute Nodes if you are experiencing an error and wish to escalate to
        /// Azure support. The Azure Batch service log files should be shared with Azure
        /// support to aid in debugging issues with the Batch service.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UploadNodeLogs(string,string,UploadBatchServiceLogsContent,int?,DateTimeOffset?,CancellationToken)']/*" />
        public virtual Response<UploadBatchServiceLogsResult> UploadNodeLogs(string poolId, string nodeId, UploadBatchServiceLogsContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using RequestContent content0 = content.ToRequestContent();
            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = UploadNodeLogs(poolId, nodeId, content0, timeOutInSeconds, ocpdate, context);
            return Response.FromValue(UploadBatchServiceLogsResult.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Upload Azure Batch service log files from the specified Compute Node to Azure
        /// Blob Storage.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="UploadNodeLogsAsync(string,string,UploadBatchServiceLogsContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId">
        /// The ID of the Compute Node for which you want to get the Remote Desktop
        /// Protocol file.
        /// </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UploadNodeLogsAsync(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual async Task<Response> UploadNodeLogsAsync(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UploadNodeLogs");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUploadNodeLogsRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Upload Azure Batch service log files from the specified Compute Node to Azure
        /// Blob Storage.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="UploadNodeLogs(string,string,UploadBatchServiceLogsContent,int?,DateTimeOffset?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId">
        /// The ID of the Compute Node for which you want to get the Remote Desktop
        /// Protocol file.
        /// </param>
        /// <param name="content"> The content to send as the body of the request. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='UploadNodeLogs(string,string,RequestContent,int?,DateTimeOffset?,RequestContext)']/*" />
        public virtual Response UploadNodeLogs(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.UploadNodeLogs");
            scope.Start();
            try
            {
                using HttpMessage message = CreateUploadNodeLogsRequest(poolId, nodeId, content, timeOutInSeconds, ocpdate, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Gets information about the specified Compute Node Extension. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that contains the extensions. </param>
        /// <param name="extensionName"> The name of the Compute Node Extension that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensionAsync(string,string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual async Task<Response<BatchNodeVMExtension>> GetNodeExtensionAsync(string poolId, string nodeId, string extensionName, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(extensionName, nameof(extensionName));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetNodeExtensionAsync(poolId, nodeId, extensionName, timeOutInSeconds, ocpdate, select, context).ConfigureAwait(false);
            return Response.FromValue(BatchNodeVMExtension.FromResponse(response), response);
        }

        /// <summary> Gets information about the specified Compute Node Extension. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that contains the extensions. </param>
        /// <param name="extensionName"> The name of the Compute Node Extension that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtension(string,string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual Response<BatchNodeVMExtension> GetNodeExtension(string poolId, string nodeId, string extensionName, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(extensionName, nameof(extensionName));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetNodeExtension(poolId, nodeId, extensionName, timeOutInSeconds, ocpdate, select, context);
            return Response.FromValue(BatchNodeVMExtension.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Compute Node Extension.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeExtensionAsync(string,string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that contains the extensions. </param>
        /// <param name="extensionName"> The name of the Compute Node Extension that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensionAsync(string,string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual async Task<Response> GetNodeExtensionAsync(string poolId, string nodeId, string extensionName, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(extensionName, nameof(extensionName));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeExtension");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeExtensionRequest(poolId, nodeId, extensionName, timeOutInSeconds, ocpdate, select, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Gets information about the specified Compute Node Extension.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeExtension(string,string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that contains the extensions. </param>
        /// <param name="extensionName"> The name of the Compute Node Extension that you want to get information about. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="extensionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtension(string,string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual Response GetNodeExtension(string poolId, string nodeId, string extensionName, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(extensionName, nameof(extensionName));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeExtension");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeExtensionRequest(poolId, nodeId, extensionName, timeOutInSeconds, ocpdate, select, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes the specified file from the Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="recursive">
        /// Whether to delete children of a directory. If the filePath parameter represents
        /// a directory instead of a file, you can set recursive to true to delete the
        /// directory and all of the files and subdirectories in it. If recursive is false
        /// then the directory must be empty or deletion will fail.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteNodeFileAsync(string,string,string,int?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual async Task<Response> DeleteNodeFileAsync(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, bool? recursive = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteNodeFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteNodeFileRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, recursive, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Deletes the specified file from the Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="recursive">
        /// Whether to delete children of a directory. If the filePath parameter represents
        /// a directory instead of a file, you can set recursive to true to delete the
        /// directory and all of the files and subdirectories in it. If recursive is false
        /// then the directory must be empty or deletion will fail.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='DeleteNodeFile(string,string,string,int?,DateTimeOffset?,bool?,RequestContext)']/*" />
        public virtual Response DeleteNodeFile(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, bool? recursive = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            using var scope = ClientDiagnostics.CreateScope("BatchClient.DeleteNodeFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateDeleteNodeFileRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, recursive, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Returns the content of the specified Compute Node file. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)']/*" />
        public virtual async Task<Response<BinaryData>> GetNodeFileAsync(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, string ocpRange = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetNodeFileAsync(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context).ConfigureAwait(false);
            return Response.FromValue(response.Content, response);
        }

        /// <summary> Returns the content of the specified Compute Node file. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)']/*" />
        public virtual Response<BinaryData> GetNodeFile(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, string ocpRange = null, RequestConditions requestConditions = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetNodeFile(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
            return Response.FromValue(response.Content, response);
        }

        /// <summary>
        /// [Protocol Method] Returns the content of the specified Compute Node file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFileAsync(string,string,string,int?,DateTimeOffset?,string,RequestConditions,RequestContext)']/*" />
        public virtual async Task<Response> GetNodeFileAsync(string poolId, string nodeId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeFileRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Returns the content of the specified Compute Node file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="ocpRange">
        /// The byte range to be retrieved. The default is to retrieve the entire file. The
        /// format is bytes=startRange-endRange.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFile(string,string,string,int?,DateTimeOffset?,string,RequestConditions,RequestContext)']/*" />
        public virtual Response GetNodeFile(string poolId, string nodeId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeFile");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeFileRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, ocpRange, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Gets the properties of the specified Compute Node file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual async Task<Response> GetNodeFilePropertiesInternalAsync(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeFilePropertiesInternal");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeFilePropertiesInternalRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, requestConditions, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        // The convenience method is omitted here because it has exactly the same parameter list as the corresponding protocol method
        /// <summary>
        /// [Protocol Method] Gets the properties of the specified Compute Node file.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node. </param>
        /// <param name="filePath"> The path to the file or directory. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="requestConditions"> The content to send as the request conditions of the request. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/>, <paramref name="nodeId"/> or <paramref name="filePath"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        internal virtual Response GetNodeFilePropertiesInternal(string poolId, string nodeId, string filePath, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, RequestConditions requestConditions = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));
            Argument.AssertNotNullOrEmpty(filePath, nameof(filePath));

            if (requestConditions?.IfMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-Match header for this operation.");
            }
            if (requestConditions?.IfNoneMatch is not null)
            {
                throw new ArgumentNullException(nameof(requestConditions), "Service does not support the If-None-Match header for this operation.");
            }

            using var scope = ClientDiagnostics.CreateScope("BatchClient.GetNodeFilePropertiesInternal");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNodeFilePropertiesInternalRequest(poolId, nodeId, filePath, timeOutInSeconds, ocpdate, requestConditions, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Lists all of the applications available in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        /// This operation returns only Applications and versions that are available for
        /// use on Compute Nodes; that is, that can be used in an Package reference. For
        /// administrator information about applications and versions that are not yet
        /// available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        /// API.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplicationsAsync(int?,DateTimeOffset?,int?,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchApplication> GetApplicationsAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetApplicationsRequest(timeOutInSeconds, ocpdate, maxresults, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetApplicationsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchApplication.DeserializeBatchApplication(e), ClientDiagnostics, _pipeline, "BatchClient.GetApplications", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the applications available in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        /// This operation returns only Applications and versions that are available for
        /// use on Compute Nodes; that is, that can be used in an Package reference. For
        /// administrator information about applications and versions that are not yet
        /// available to Compute Nodes, use the Azure portal or the Azure Resource Manager
        /// API.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplications(int?,DateTimeOffset?,int?,CancellationToken)']/*" />
        public virtual Pageable<BatchApplication> GetApplications(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetApplicationsRequest(timeOutInSeconds, ocpdate, maxresults, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetApplicationsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchApplication.DeserializeBatchApplication(e), ClientDiagnostics, _pipeline, "BatchClient.GetApplications", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the applications available in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetApplicationsAsync(int?,DateTimeOffset?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplicationsAsync(int?,DateTimeOffset?,int?,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetApplicationsAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetApplicationsRequest(timeOutInSeconds, ocpdate, maxresults, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetApplicationsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetApplications", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the applications available in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetApplications(int?,DateTimeOffset?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetApplications(int?,DateTimeOffset?,int?,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetApplications(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetApplicationsRequest(timeOutInSeconds, ocpdate, maxresults, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetApplicationsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetApplications", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists the usage metrics, aggregated by Pool across individual time intervals,
        /// for the specified Account.
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="starttime">
        /// The earliest time from which to include metrics. This must be at least two and
        /// a half hours before the current time. If not specified this defaults to the
        /// start time of the last aggregation interval currently available.
        /// </param>
        /// <param name="endtime">
        /// The latest time from which to include metrics. This must be at least two hours
        /// before the current time. If not specified this defaults to the end time of the
        /// last aggregation interval currently available.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        /// If you do not specify a $filter clause including a poolId, the response
        /// includes all Pools that existed in the Account in the time range of the
        /// returned aggregation intervals. If you do not specify a $filter clause
        /// including a startTime or endTime these filters default to the start and end
        /// times of the last aggregation interval currently available; that is, only the
        /// last aggregation interval is returned.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolUsageMetricsAsync(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchPoolUsageMetrics> GetPoolUsageMetricsAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, DateTimeOffset? starttime = null, DateTimeOffset? endtime = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolUsageMetricsRequest(timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolUsageMetricsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchPoolUsageMetrics.DeserializeBatchPoolUsageMetrics(e), ClientDiagnostics, _pipeline, "BatchClient.GetPoolUsageMetrics", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists the usage metrics, aggregated by Pool across individual time intervals,
        /// for the specified Account.
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="starttime">
        /// The earliest time from which to include metrics. This must be at least two and
        /// a half hours before the current time. If not specified this defaults to the
        /// start time of the last aggregation interval currently available.
        /// </param>
        /// <param name="endtime">
        /// The latest time from which to include metrics. This must be at least two hours
        /// before the current time. If not specified this defaults to the end time of the
        /// last aggregation interval currently available.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        /// If you do not specify a $filter clause including a poolId, the response
        /// includes all Pools that existed in the Account in the time range of the
        /// returned aggregation intervals. If you do not specify a $filter clause
        /// including a startTime or endTime these filters default to the start and end
        /// times of the last aggregation interval currently available; that is, only the
        /// last aggregation interval is returned.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolUsageMetrics(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,CancellationToken)']/*" />
        public virtual Pageable<BatchPoolUsageMetrics> GetPoolUsageMetrics(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, DateTimeOffset? starttime = null, DateTimeOffset? endtime = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolUsageMetricsRequest(timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolUsageMetricsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchPoolUsageMetrics.DeserializeBatchPoolUsageMetrics(e), ClientDiagnostics, _pipeline, "BatchClient.GetPoolUsageMetrics", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the usage metrics, aggregated by Pool across individual time intervals,
        /// for the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolUsageMetricsAsync(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="starttime">
        /// The earliest time from which to include metrics. This must be at least two and
        /// a half hours before the current time. If not specified this defaults to the
        /// start time of the last aggregation interval currently available.
        /// </param>
        /// <param name="endtime">
        /// The latest time from which to include metrics. This must be at least two hours
        /// before the current time. If not specified this defaults to the end time of the
        /// last aggregation interval currently available.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolUsageMetricsAsync(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetPoolUsageMetricsAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, DateTimeOffset? starttime, DateTimeOffset? endtime, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolUsageMetricsRequest(timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolUsageMetricsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPoolUsageMetrics", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the usage metrics, aggregated by Pool across individual time intervals,
        /// for the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolUsageMetrics(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="starttime">
        /// The earliest time from which to include metrics. This must be at least two and
        /// a half hours before the current time. If not specified this defaults to the
        /// start time of the last aggregation interval currently available.
        /// </param>
        /// <param name="endtime">
        /// The latest time from which to include metrics. This must be at least two hours
        /// before the current time. If not specified this defaults to the end time of the
        /// last aggregation interval currently available.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolUsageMetrics(int?,DateTimeOffset?,int?,DateTimeOffset?,DateTimeOffset?,string,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetPoolUsageMetrics(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, DateTimeOffset? starttime, DateTimeOffset? endtime, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolUsageMetricsRequest(timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolUsageMetricsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, starttime, endtime, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPoolUsageMetrics", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Pools in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchPool> GetPoolsAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchPool.DeserializeBatchPool(e), ClientDiagnostics, _pipeline, "BatchClient.GetPools", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Pools in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPools(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchPool> GetPools(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchPool.DeserializeBatchPool(e), ClientDiagnostics, _pipeline, "BatchClient.GetPools", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Pools in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetPoolsAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPools", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Pools in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPools(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPools(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetPools(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPools", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all Virtual Machine Images supported by the Azure Batch service. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSupportedImagesAsync(int?,DateTimeOffset?,int?,string,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchSupportedImage> GetSupportedImagesAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSupportedImagesRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSupportedImagesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchSupportedImage.DeserializeBatchSupportedImage(e), ClientDiagnostics, _pipeline, "BatchClient.GetSupportedImages", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all Virtual Machine Images supported by the Azure Batch service. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSupportedImages(int?,DateTimeOffset?,int?,string,CancellationToken)']/*" />
        public virtual Pageable<BatchSupportedImage> GetSupportedImages(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSupportedImagesRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSupportedImagesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchSupportedImage.DeserializeBatchSupportedImage(e), ClientDiagnostics, _pipeline, "BatchClient.GetSupportedImages", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all Virtual Machine Images supported by the Azure Batch service.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSupportedImagesAsync(int?,DateTimeOffset?,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSupportedImagesAsync(int?,DateTimeOffset?,int?,string,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetSupportedImagesAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSupportedImagesRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSupportedImagesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetSupportedImages", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all Virtual Machine Images supported by the Azure Batch service.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSupportedImages(int?,DateTimeOffset?,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSupportedImages(int?,DateTimeOffset?,int?,string,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetSupportedImages(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSupportedImagesRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSupportedImagesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetSupportedImages", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        /// numbers returned may not always be up to date. If you need exact node counts,
        /// use a list query.
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolNodeCountsAsync(int?,DateTimeOffset?,int?,string,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchPoolNodeCounts> GetPoolNodeCountsAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolNodeCountsRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolNodeCountsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchPoolNodeCounts.DeserializeBatchPoolNodeCounts(e), ClientDiagnostics, _pipeline, "BatchClient.GetPoolNodeCounts", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        /// numbers returned may not always be up to date. If you need exact node counts,
        /// use a list query.
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolNodeCounts(int?,DateTimeOffset?,int?,string,CancellationToken)']/*" />
        public virtual Pageable<BatchPoolNodeCounts> GetPoolNodeCounts(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolNodeCountsRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolNodeCountsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchPoolNodeCounts.DeserializeBatchPoolNodeCounts(e), ClientDiagnostics, _pipeline, "BatchClient.GetPoolNodeCounts", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        /// numbers returned may not always be up to date. If you need exact node counts,
        /// use a list query.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolNodeCountsAsync(int?,DateTimeOffset?,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolNodeCountsAsync(int?,DateTimeOffset?,int?,string,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetPoolNodeCountsAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolNodeCountsRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolNodeCountsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPoolNodeCounts", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Gets the number of Compute Nodes in each state, grouped by Pool. Note that the
        /// numbers returned may not always be up to date. If you need exact node counts,
        /// use a list query.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetPoolNodeCounts(int?,DateTimeOffset?,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-support-images.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetPoolNodeCounts(int?,DateTimeOffset?,int?,string,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetPoolNodeCounts(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetPoolNodeCountsRequest(timeOutInSeconds, ocpdate, maxresults, filter, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetPoolNodeCountsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetPoolNodeCounts", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Jobs in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchJob> GetJobsAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchJob.DeserializeBatchJob(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobs", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Jobs in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobs(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchJob> GetJobs(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchJob.DeserializeBatchJob(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobs", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Jobs in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetJobsAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobs", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Jobs in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobs(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobs(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetJobs(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobs", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Jobs that have been created under the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule from which you want to get a list of Jobs. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsFromSchedulesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchJob> GetJobsFromSchedulesAsync(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsFromSchedulesRequest(jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsFromSchedulesNextPageRequest(nextLink, jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchJob.DeserializeBatchJob(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobsFromSchedules", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Jobs that have been created under the specified Job Schedule. </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule from which you want to get a list of Jobs. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsFromSchedules(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchJob> GetJobsFromSchedules(string jobScheduleId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsFromSchedulesRequest(jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsFromSchedulesNextPageRequest(nextLink, jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchJob.DeserializeBatchJob(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobsFromSchedules", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Jobs that have been created under the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobsFromSchedulesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule from which you want to get a list of Jobs. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsFromSchedulesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetJobsFromSchedulesAsync(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsFromSchedulesRequest(jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsFromSchedulesNextPageRequest(nextLink, jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobsFromSchedules", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Jobs that have been created under the specified Job Schedule.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobsFromSchedules(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobScheduleId"> The ID of the Job Schedule from which you want to get a list of Jobs. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobScheduleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobScheduleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobsFromSchedules(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetJobsFromSchedules(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobScheduleId, nameof(jobScheduleId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobsFromSchedulesRequest(jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobsFromSchedulesNextPageRequest(nextLink, jobScheduleId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobsFromSchedules", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists the execution status of the Job Preparation and Job Release Task for the
        /// specified Job across the Compute Nodes where the Job has run.
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This API returns the Job Preparation and Job Release Task status on all Compute
        /// Nodes that have run the Job Preparation or Job Release Task. This includes
        /// Compute Nodes which have since been removed from the Pool. If this API is
        /// invoked on a Job which has no Job Preparation or Job Release Task, the Batch
        /// service returns HTTP status code 409 (Conflict) with an error code of
        /// JobPreparationTaskNotSpecified.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobPreparationAndReleaseTaskStatusesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchJobPreparationAndReleaseTaskStatus> GetJobPreparationAndReleaseTaskStatusesAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobPreparationAndReleaseTaskStatusesRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobPreparationAndReleaseTaskStatusesNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchJobPreparationAndReleaseTaskStatus.DeserializeBatchJobPreparationAndReleaseTaskStatus(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobPreparationAndReleaseTaskStatuses", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists the execution status of the Job Preparation and Job Release Task for the
        /// specified Job across the Compute Nodes where the Job has run.
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// This API returns the Job Preparation and Job Release Task status on all Compute
        /// Nodes that have run the Job Preparation or Job Release Task. This includes
        /// Compute Nodes which have since been removed from the Pool. If this API is
        /// invoked on a Job which has no Job Preparation or Job Release Task, the Batch
        /// service returns HTTP status code 409 (Conflict) with an error code of
        /// JobPreparationTaskNotSpecified.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobPreparationAndReleaseTaskStatuses(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchJobPreparationAndReleaseTaskStatus> GetJobPreparationAndReleaseTaskStatuses(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobPreparationAndReleaseTaskStatusesRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobPreparationAndReleaseTaskStatusesNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchJobPreparationAndReleaseTaskStatus.DeserializeBatchJobPreparationAndReleaseTaskStatus(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobPreparationAndReleaseTaskStatuses", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the execution status of the Job Preparation and Job Release Task for the
        /// specified Job across the Compute Nodes where the Job has run.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobPreparationAndReleaseTaskStatusesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobPreparationAndReleaseTaskStatusesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetJobPreparationAndReleaseTaskStatusesAsync(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobPreparationAndReleaseTaskStatusesRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobPreparationAndReleaseTaskStatusesNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobPreparationAndReleaseTaskStatuses", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the execution status of the Job Preparation and Job Release Task for the
        /// specified Job across the Compute Nodes where the Job has run.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobPreparationAndReleaseTaskStatuses(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobPreparationAndReleaseTaskStatuses(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetJobPreparationAndReleaseTaskStatuses(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobPreparationAndReleaseTaskStatusesRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobPreparationAndReleaseTaskStatusesNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobPreparationAndReleaseTaskStatuses", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Job Schedules in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedulesAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchJobSchedule> GetJobSchedulesAsync(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobSchedulesRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobSchedulesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchJobSchedule.DeserializeBatchJobSchedule(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobSchedules", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Job Schedules in the specified Account. </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedules(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchJobSchedule> GetJobSchedules(int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobSchedulesRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobSchedulesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchJobSchedule.DeserializeBatchJobSchedule(e), ClientDiagnostics, _pipeline, "BatchClient.GetJobSchedules", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Job Schedules in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobSchedulesAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedulesAsync(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetJobSchedulesAsync(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobSchedulesRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobSchedulesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobSchedules", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Job Schedules in the specified Account.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetJobSchedules(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetJobSchedules(int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetJobSchedules(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetJobSchedulesRequest(timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetJobSchedulesNextPageRequest(nextLink, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetJobSchedules", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Tasks that are associated with the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-tasks.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// For multi-instance Tasks, information such as affinityId, executionInfo and
        /// nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        /// information about subtasks.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTasksAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchTask> GetTasksAsync(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTasksRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTasksNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchTask.DeserializeBatchTask(e), ClientDiagnostics, _pipeline, "BatchClient.GetTasks", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the Tasks that are associated with the specified Job. </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-tasks.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks>
        /// For multi-instance Tasks, information such as affinityId, executionInfo and
        /// nodeInfo refer to the primary Task. Use the list subtasks API to retrieve
        /// information about subtasks.
        /// </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTasks(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchTask> GetTasks(string jobId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, IEnumerable<string> expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTasksRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTasksNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchTask.DeserializeBatchTask(e), ClientDiagnostics, _pipeline, "BatchClient.GetTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Tasks that are associated with the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTasksAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-tasks.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTasksAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetTasksAsync(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTasksRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTasksNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the Tasks that are associated with the specified Job.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTasks(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-tasks.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="expand"> An OData $expand clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTasks(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetTasks(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTasksRequest(jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTasksNextPageRequest(nextLink, jobId, timeOutInSeconds, ocpdate, maxresults, filter, select, expand, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists all of the subtasks that are associated with the specified multi-instance
        /// Task.
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks> If the Task is not a multi-instance Task then this returns an empty collection. </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSubTasksAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchSubtask> GetSubTasksAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSubTasksRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSubTasksNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchSubtask.DeserializeBatchSubtask(e), ClientDiagnostics, _pipeline, "BatchClient.GetSubTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// Lists all of the subtasks that are associated with the specified multi-instance
        /// Task.
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <remarks> If the Task is not a multi-instance Task then this returns an empty collection. </remarks>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSubTasks(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchSubtask> GetSubTasks(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSubTasksRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSubTasksNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchSubtask.DeserializeBatchSubtask(e), ClientDiagnostics, _pipeline, "BatchClient.GetSubTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the subtasks that are associated with the specified multi-instance
        /// Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSubTasksAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSubTasksAsync(string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetSubTasksAsync(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSubTasksRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSubTasksNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetSubTasks", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the subtasks that are associated with the specified multi-instance
        /// Task.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetSubTasks(string,string,int?,DateTimeOffset?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job. </param>
        /// <param name="taskId"> The ID of the Task. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetSubTasks(string,string,int?,DateTimeOffset?,IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetSubTasks(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetSubTasksRequest(jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetSubTasksNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetSubTasks", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the files in a Task's directory on its Compute Node. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-task-files.
        /// </param>
        /// <param name="recursive">
        /// Whether to list children of the Task directory. This parameter can be used in
        /// combination with the filter parameter to list specific type of files.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchNodeFile> GetTaskFilesAsync(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, bool? recursive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTaskFilesRequest(jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTaskFilesNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchNodeFile.DeserializeBatchNodeFile(e), ClientDiagnostics, _pipeline, "BatchClient.GetTaskFiles", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the files in a Task's directory on its Compute Node. </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-task-files.
        /// </param>
        /// <param name="recursive">
        /// Whether to list children of the Task directory. This parameter can be used in
        /// combination with the filter parameter to list specific type of files.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)']/*" />
        public virtual Pageable<BatchNodeFile> GetTaskFiles(string jobId, string taskId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, bool? recursive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTaskFilesRequest(jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTaskFilesNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchNodeFile.DeserializeBatchNodeFile(e), ClientDiagnostics, _pipeline, "BatchClient.GetTaskFiles", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the files in a Task's directory on its Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTaskFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-task-files.
        /// </param>
        /// <param name="recursive">
        /// Whether to list children of the Task directory. This parameter can be used in
        /// combination with the filter parameter to list specific type of files.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetTaskFilesAsync(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTaskFilesRequest(jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTaskFilesNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetTaskFiles", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the files in a Task's directory on its Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetTaskFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="jobId"> The ID of the Job that contains the Task. </param>
        /// <param name="taskId"> The ID of the Task whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-task-files.
        /// </param>
        /// <param name="recursive">
        /// Whether to list children of the Task directory. This parameter can be used in
        /// combination with the filter parameter to list specific type of files.
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="jobId"/> or <paramref name="taskId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="jobId"/> or <paramref name="taskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetTaskFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetTaskFiles(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(jobId, nameof(jobId));
            Argument.AssertNotNullOrEmpty(taskId, nameof(taskId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetTaskFilesRequest(jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetTaskFilesNextPageRequest(nextLink, jobId, taskId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetTaskFiles", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Compute Nodes in the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool from which you want to list Compute Nodes. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchNode> GetNodesAsync(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodesRequest(poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodesNextPageRequest(nextLink, poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchNode.DeserializeBatchNode(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodes", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Compute Nodes in the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool from which you want to list Compute Nodes. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodes(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchNode> GetNodes(string poolId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodesRequest(poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodesNextPageRequest(nextLink, poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchNode.DeserializeBatchNode(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodes", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Compute Nodes in the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool from which you want to list Compute Nodes. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodesAsync(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetNodesAsync(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodesRequest(poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodesNextPageRequest(nextLink, poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodes", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Compute Nodes in the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodes(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool from which you want to list Compute Nodes. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodes(string,int?,DateTimeOffset?,int?,string,IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetNodes(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodesRequest(poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodesNextPageRequest(nextLink, poolId, timeOutInSeconds, ocpdate, maxresults, filter, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodes", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Compute Nodes Extensions in the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool that contains Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to list extensions. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensionsAsync(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},CancellationToken)']/*" />
        public virtual AsyncPageable<BatchNodeVMExtension> GetNodeExtensionsAsync(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeExtensionsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeExtensionsNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchNodeVMExtension.DeserializeBatchNodeVMExtension(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodeExtensions", "value", "odata.nextLink", context);
        }

        /// <summary> Lists the Compute Nodes Extensions in the specified Pool. </summary>
        /// <param name="poolId"> The ID of the Pool that contains Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to list extensions. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensions(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},CancellationToken)']/*" />
        public virtual Pageable<BatchNodeVMExtension> GetNodeExtensions(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, IEnumerable<string> select = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeExtensionsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeExtensionsNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchNodeVMExtension.DeserializeBatchNodeVMExtension(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodeExtensions", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Compute Nodes Extensions in the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeExtensionsAsync(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to list extensions. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensionsAsync(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetNodeExtensionsAsync(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeExtensionsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeExtensionsNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodeExtensions", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists the Compute Nodes Extensions in the specified Pool.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeExtensions(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node that you want to list extensions. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="select"> An OData $select clause. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeExtensions(string,string,int?,DateTimeOffset?,int?,IEnumerable{string},RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetNodeExtensions(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, IEnumerable<string> select, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeExtensionsRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeExtensionsNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, select, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodeExtensions", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the files in Task directories on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files.
        /// </param>
        /// <param name="recursive"> Whether to list children of a directory. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)']/*" />
        public virtual AsyncPageable<BatchNodeFile> GetNodeFilesAsync(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, bool? recursive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeFilesRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeFilesNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BatchNodeFile.DeserializeBatchNodeFile(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodeFiles", "value", "odata.nextLink", context);
        }

        /// <summary> Lists all of the files in Task directories on the specified Compute Node. </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files.
        /// </param>
        /// <param name="recursive"> Whether to list children of a directory. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)']/*" />
        public virtual Pageable<BatchNodeFile> GetNodeFiles(string poolId, string nodeId, int? timeOutInSeconds = null, DateTimeOffset? ocpdate = null, int? maxresults = null, string filter = null, bool? recursive = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            RequestContext context = cancellationToken.CanBeCanceled ? new RequestContext { CancellationToken = cancellationToken } : null;
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeFilesRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeFilesNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BatchNodeFile.DeserializeBatchNodeFile(e), ClientDiagnostics, _pipeline, "BatchClient.GetNodeFiles", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the files in Task directories on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files.
        /// </param>
        /// <param name="recursive"> Whether to list children of a directory. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFilesAsync(string,string,int?,DateTimeOffset?,int?,string,bool?,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetNodeFilesAsync(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeFilesRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeFilesNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodeFiles", "value", "odata.nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Lists all of the files in Task directories on the specified Compute Node.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNodeFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="poolId"> The ID of the Pool that contains the Compute Node. </param>
        /// <param name="nodeId"> The ID of the Compute Node whose files you want to list. </param>
        /// <param name="timeOutInSeconds"> The maximum time that the server can spend processing the request, in seconds. The default is 30 seconds. If the value is larger than 30, the default will be used instead.". </param>
        /// <param name="ocpdate">
        /// The time the request was issued. Client libraries typically set this to the
        /// current system clock time; set it explicitly if you are calling the REST API
        /// directly.
        /// </param>
        /// <param name="maxresults">
        /// The maximum number of items to return in the response. A maximum of 1000
        /// applications can be returned.
        /// </param>
        /// <param name="filter">
        /// An OData $filter clause. For more information on constructing this filter, see
        /// https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files.
        /// </param>
        /// <param name="recursive"> Whether to list children of a directory. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="poolId"/> or <paramref name="nodeId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/BatchClient.xml" path="doc/members/member[@name='GetNodeFiles(string,string,int?,DateTimeOffset?,int?,string,bool?,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetNodeFiles(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            Argument.AssertNotNullOrEmpty(poolId, nameof(poolId));
            Argument.AssertNotNullOrEmpty(nodeId, nameof(nodeId));

            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetNodeFilesRequest(poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetNodeFilesNextPageRequest(nextLink, poolId, nodeId, timeOutInSeconds, ocpdate, maxresults, filter, recursive, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "BatchClient.GetNodeFiles", "value", "odata.nextLink", context);
        }

        internal HttpMessage CreateGetApplicationsRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/applications", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetApplicationRequest(string applicationId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/applications/", false);
            uri.AppendPath(applicationId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolUsageMetricsRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, DateTimeOffset? starttime, DateTimeOffset? endtime, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/poolusagemetrics", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (starttime != null)
            {
                uri.AppendQuery("startTime", starttime.Value, "O", true);
            }
            if (endtime != null)
            {
                uri.AppendQuery("endtime", endtime.Value, "O", true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateCreatePoolRequest(RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier201);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetPoolsRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateDeletePoolRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreatePoolExistsRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200404);
            var request = message.Request;
            request.Method = RequestMethod.Head;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateUpdatePoolRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDisablePoolAutoScaleRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/disableautoscale", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateEnablePoolAutoScaleRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/enableautoscale", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateEvaluatePoolAutoScaleRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/evaluateautoscale", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateResizePoolRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/resize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateStopPoolResizeRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/stopresize", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateReplacePoolPropertiesRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier204);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/updateproperties", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateRemoveNodesRequest(string poolId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/removenodes", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetSupportedImagesRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/supportedimages", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolNodeCountsRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/nodecounts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateDeleteJobRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateUpdateJobRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateReplaceJobRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDisableJobRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/disable", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateEnableJobRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/enable", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateTerminateJobRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/terminate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateCreateJobRequest(RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier201);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetJobsRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobsFromSchedulesRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendPath("/jobs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobPreparationAndReleaseTaskStatusesRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/jobpreparationandreleasetaskstatus", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobTaskCountsRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/taskcounts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateJobScheduleExistsRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200404);
            var request = message.Request;
            request.Method = RequestMethod.Head;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateDeleteJobScheduleRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobScheduleRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateUpdateJobScheduleRequest(string jobScheduleId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateReplaceJobScheduleRequest(string jobScheduleId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDisableJobScheduleRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier204);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendPath("/disable", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateEnableJobScheduleRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier204);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendPath("/enable", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateTerminateJobScheduleRequest(string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules/", false);
            uri.AppendPath(jobScheduleId, true);
            uri.AppendPath("/terminate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateCreateJobScheduleRequest(RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier201);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetJobSchedulesRequest(int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobschedules", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateCreateTaskRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier201);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetTasksRequest(string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateCreateTaskCollectionRequest(string jobId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/addtaskcollection", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteTaskRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTaskRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, IEnumerable<string> expand, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            if (expand != null && !(expand is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("$expand", expand, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateReplaceTaskRequest(string jobId, string taskId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetSubTasksRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/subtasksinfo", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateTerminateTaskRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier204);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/terminate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateReactivateTaskRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier204);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/reactivate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateDeleteTaskFileRequest(string jobId, string taskId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (recursive != null)
            {
                uri.AppendQuery("recursive", recursive.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTaskFileRequest(string jobId, string taskId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/octet-stream");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (ocpRange != null)
            {
                request.Headers.Add("ocp-range", ocpRange);
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTaskFilePropertiesInternalRequest(string jobId, string taskId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Head;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTaskFilesRequest(string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/jobs/", false);
            uri.AppendPath(jobId, true);
            uri.AppendPath("/tasks/", false);
            uri.AppendPath(taskId, true);
            uri.AppendPath("/files", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (recursive != null)
            {
                uri.AppendQuery("recursive", recursive.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateCreateNodeUserRequest(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier201);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/users", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDeleteNodeUserRequest(string poolId, string nodeId, string userName, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/users/", false);
            uri.AppendPath(userName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateReplaceNodeUserRequest(string poolId, string nodeId, string userName, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/users/", false);
            uri.AppendPath(userName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetNodeRequest(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateRebootNodeRequest(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier202);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/reboot", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateDisableNodeSchedulingRequest(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/disablescheduling", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateEnableNodeSchedulingRequest(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/enablescheduling", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeRemoteLoginSettingsRequest(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/remoteloginsettings", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateUploadNodeLogsRequest(string poolId, string nodeId, RequestContent content, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/uploadbatchservicelogs", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            request.Headers.Add("Content-Type", "application/json; odata=minimalmetadata");
            request.Content = content;
            return message;
        }

        internal HttpMessage CreateGetNodesRequest(string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeExtensionRequest(string poolId, string nodeId, string extensionName, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/extensions/", false);
            uri.AppendPath(extensionName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeExtensionsRequest(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/extensions", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (select != null && !(select is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("$select", select, ",", true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateDeleteNodeFileRequest(string poolId, string nodeId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (recursive != null)
            {
                uri.AppendQuery("recursive", recursive.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeFileRequest(string poolId, string nodeId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, string ocpRange, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/octet-stream");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (ocpRange != null)
            {
                request.Headers.Add("ocp-range", ocpRange);
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeFilePropertiesInternalRequest(string poolId, string nodeId, string filePath, int? timeOutInSeconds, DateTimeOffset? ocpdate, RequestConditions requestConditions, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Head;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/files/", false);
            uri.AppendPath(filePath, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            if (requestConditions != null)
            {
                request.Headers.Add(requestConditions, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeFilesRequest(string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/pools/", false);
            uri.AppendPath(poolId, true);
            uri.AppendPath("/nodes/", false);
            uri.AppendPath(nodeId, true);
            uri.AppendPath("/files", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (timeOutInSeconds != null)
            {
                uri.AppendQuery("timeOut", timeOutInSeconds.Value, true);
            }
            if (maxresults != null)
            {
                uri.AppendQuery("maxresults", maxresults.Value, true);
            }
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (recursive != null)
            {
                uri.AppendQuery("recursive", recursive.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetApplicationsNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolUsageMetricsNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, DateTimeOffset? starttime, DateTimeOffset? endtime, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolsNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetSupportedImagesNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetPoolNodeCountsNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobsNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobsFromSchedulesNextPageRequest(string nextLink, string jobScheduleId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobPreparationAndReleaseTaskStatusesNextPageRequest(string nextLink, string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetJobSchedulesNextPageRequest(string nextLink, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTasksNextPageRequest(string nextLink, string jobId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, IEnumerable<string> expand, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetSubTasksNextPageRequest(string nextLink, string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetTaskFilesNextPageRequest(string nextLink, string jobId, string taskId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodesNextPageRequest(string nextLink, string poolId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeExtensionsNextPageRequest(string nextLink, string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, IEnumerable<string> select, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        internal HttpMessage CreateGetNodeFilesNextPageRequest(string nextLink, string poolId, string nodeId, int? timeOutInSeconds, DateTimeOffset? ocpdate, int? maxresults, string filter, bool? recursive, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("client-request-id", message.Request.ClientRequestId);
            request.Headers.Add("return-client-request-id", "true");
            if (ocpdate != null)
            {
                request.Headers.Add("ocp-date", ocpdate.Value, "R");
            }
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
        private static ResponseClassifier _responseClassifier201;
        private static ResponseClassifier ResponseClassifier201 => _responseClassifier201 ??= new StatusCodeClassifier(stackalloc ushort[] { 201 });
        private static ResponseClassifier _responseClassifier202;
        private static ResponseClassifier ResponseClassifier202 => _responseClassifier202 ??= new StatusCodeClassifier(stackalloc ushort[] { 202 });
        private static ResponseClassifier _responseClassifier200404;
        private static ResponseClassifier ResponseClassifier200404 => _responseClassifier200404 ??= new StatusCodeClassifier(stackalloc ushort[] { 200, 404 });
        private static ResponseClassifier _responseClassifier204;
        private static ResponseClassifier ResponseClassifier204 => _responseClassifier204 ??= new StatusCodeClassifier(stackalloc ushort[] { 204 });
    }
}
