// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    public partial class BatchAutoPoolSpecification : IUtf8JsonSerializable, IJsonModel<BatchAutoPoolSpecification>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchAutoPoolSpecification>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BatchAutoPoolSpecification>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAutoPoolSpecification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchAutoPoolSpecification)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(AutoPoolIdPrefix))
            {
                writer.WritePropertyName("autoPoolIdPrefix"u8);
                writer.WriteStringValue(AutoPoolIdPrefix);
            }
            writer.WritePropertyName("poolLifetimeOption"u8);
            writer.WriteStringValue(PoolLifetimeOption.ToString());
            if (Optional.IsDefined(KeepAlive))
            {
                writer.WritePropertyName("keepAlive"u8);
                writer.WriteBooleanValue(KeepAlive.Value);
            }
            if (Optional.IsDefined(Pool))
            {
                writer.WritePropertyName("pool"u8);
                writer.WriteObjectValue(Pool, options);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BatchAutoPoolSpecification IJsonModel<BatchAutoPoolSpecification>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAutoPoolSpecification>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchAutoPoolSpecification)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBatchAutoPoolSpecification(document.RootElement, options);
        }

        internal static BatchAutoPoolSpecification DeserializeBatchAutoPoolSpecification(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string autoPoolIdPrefix = default;
            BatchPoolLifetimeOption poolLifetimeOption = default;
            bool? keepAlive = default;
            BatchPoolSpecification pool = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("autoPoolIdPrefix"u8))
                {
                    autoPoolIdPrefix = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("poolLifetimeOption"u8))
                {
                    poolLifetimeOption = new BatchPoolLifetimeOption(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("keepAlive"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    keepAlive = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("pool"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pool = BatchPoolSpecification.DeserializeBatchPoolSpecification(property.Value, options);
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchAutoPoolSpecification(autoPoolIdPrefix, poolLifetimeOption, keepAlive, pool, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BatchAutoPoolSpecification>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAutoPoolSpecification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BatchAutoPoolSpecification)} does not support writing '{options.Format}' format.");
            }
        }

        BatchAutoPoolSpecification IPersistableModel<BatchAutoPoolSpecification>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchAutoPoolSpecification>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBatchAutoPoolSpecification(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BatchAutoPoolSpecification)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BatchAutoPoolSpecification>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchAutoPoolSpecification FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchAutoPoolSpecification(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
