// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The configuration parameters used for performing automatic OS upgrade. </summary>
    public partial class AutomaticOsUpgradePolicy
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomaticOsUpgradePolicy"/>. </summary>
        public AutomaticOsUpgradePolicy()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomaticOsUpgradePolicy"/>. </summary>
        /// <param name="disableAutomaticRollback"> Whether OS image rollback feature should be disabled. </param>
        /// <param name="enableAutomaticOsUpgrade"> Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. &lt;br /&gt;&lt;br /&gt; If this is set to true for Windows based pools, [WindowsConfiguration.enableAutomaticUpdates](https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration) cannot be set to true. </param>
        /// <param name="useRollingUpgradePolicy"> Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS. </param>
        /// <param name="osRollingUpgradeDeferral"> Defer OS upgrades on the TVMs if they are running tasks. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomaticOsUpgradePolicy(bool? disableAutomaticRollback, bool? enableAutomaticOsUpgrade, bool? useRollingUpgradePolicy, bool? osRollingUpgradeDeferral, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisableAutomaticRollback = disableAutomaticRollback;
            EnableAutomaticOsUpgrade = enableAutomaticOsUpgrade;
            UseRollingUpgradePolicy = useRollingUpgradePolicy;
            OsRollingUpgradeDeferral = osRollingUpgradeDeferral;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether OS image rollback feature should be disabled. </summary>
        public bool? DisableAutomaticRollback { get; set; }
        /// <summary> Indicates whether OS upgrades should automatically be applied to scale set instances in a rolling fashion when a newer version of the OS image becomes available. &lt;br /&gt;&lt;br /&gt; If this is set to true for Windows based pools, [WindowsConfiguration.enableAutomaticUpdates](https://learn.microsoft.com/en-us/rest/api/batchservice/pool/add?tabs=HTTP#windowsconfiguration) cannot be set to true. </summary>
        public bool? EnableAutomaticOsUpgrade { get; set; }
        /// <summary> Indicates whether rolling upgrade policy should be used during Auto OS Upgrade. Auto OS Upgrade will fallback to the default policy if no policy is defined on the VMSS. </summary>
        public bool? UseRollingUpgradePolicy { get; set; }
        /// <summary> Defer OS upgrades on the TVMs if they are running tasks. </summary>
        public bool? OsRollingUpgradeDeferral { get; set; }
    }
}
