// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> Specifies the options for the auto user that runs an Azure Batch Task. </summary>
    public partial class AutoUserSpecification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoUserSpecification"/>. </summary>
        public AutoUserSpecification()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutoUserSpecification"/>. </summary>
        /// <param name="scope"> The scope for the auto user. The default value is pool. If the pool is running Windows, a value of Task should be specified if stricter isolation between tasks is required, such as if the task mutates the registry in a way which could impact other tasks. </param>
        /// <param name="elevationLevel"> The elevation level of the auto user. The default value is nonAdmin. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoUserSpecification(AutoUserScope? scope, ElevationLevel? elevationLevel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Scope = scope;
            ElevationLevel = elevationLevel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The scope for the auto user. The default value is pool. If the pool is running Windows, a value of Task should be specified if stricter isolation between tasks is required, such as if the task mutates the registry in a way which could impact other tasks. </summary>
        public AutoUserScope? Scope { get; set; }
        /// <summary> The elevation level of the auto user. The default value is nonAdmin. </summary>
        public ElevationLevel? ElevationLevel { get; set; }
    }
}
