// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Compute.Batch
{
    /// <summary> The results and errors from an execution of a Pool autoscale formula. </summary>
    public partial class AutoScaleRun
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoScaleRun"/>. </summary>
        /// <param name="timestamp"> The time at which the autoscale formula was last evaluated. </param>
        internal AutoScaleRun(DateTimeOffset timestamp)
        {
            Timestamp = timestamp;
        }

        /// <summary> Initializes a new instance of <see cref="AutoScaleRun"/>. </summary>
        /// <param name="timestamp"> The time at which the autoscale formula was last evaluated. </param>
        /// <param name="results"> The final values of all variables used in the evaluation of the autoscale formula. Each variable value is returned in the form $variable=value, and variables are separated by semicolons. </param>
        /// <param name="error"> Details of the error encountered evaluating the autoscale formula on the Pool, if the evaluation was unsuccessful. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoScaleRun(DateTimeOffset timestamp, string results, AutoScaleRunError error, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Timestamp = timestamp;
            Results = results;
            Error = error;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutoScaleRun"/> for deserialization. </summary>
        internal AutoScaleRun()
        {
        }

        /// <summary> The time at which the autoscale formula was last evaluated. </summary>
        public DateTimeOffset Timestamp { get; }
        /// <summary> The final values of all variables used in the evaluation of the autoscale formula. Each variable value is returned in the form $variable=value, and variables are separated by semicolons. </summary>
        public string Results { get; }
        /// <summary> Details of the error encountered evaluating the autoscale formula on the Pool, if the evaluation was unsuccessful. </summary>
        public AutoScaleRunError Error { get; }
    }
}
