// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Compute.Batch
{
    /// <summary>
    /// Customizing the Serialization of BatchPoolReplaceContent to handle the missing variable certificateReferences.  This
    /// is a work around will be removed in the next release
    /// </summary>
    public partial class BatchPoolReplaceContent : IUtf8JsonSerializable, IJsonModel<BatchPoolReplaceContent>
    {
        void global::Azure.Core.IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BatchPoolReplaceContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void global::System.ClientModel.Primitives.IJsonModel<Azure.Compute.Batch.BatchPoolReplaceContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BatchPoolReplaceContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BatchPoolReplaceContent)} does not support writing '{format}' format.");
            }

            writer.WriteStartObject();
            if (Optional.IsDefined(StartTask))
            {
                writer.WritePropertyName("startTask"u8);
                writer.WriteObjectValue(StartTask, options);
            }
            writer.WritePropertyName("applicationPackageReferences"u8);
            writer.WriteStartArray();
            foreach (var item in ApplicationPackageReferences)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("metadata"u8);
            writer.WriteStartArray();
            foreach (var item in Metadata)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("certificateReferences"u8);
            writer.WriteStartArray();
            writer.WriteEndArray();
            if (Optional.IsDefined(TargetNodeCommunicationMode))
            {
                writer.WritePropertyName("targetNodeCommunicationMode"u8);
                writer.WriteStringValue(TargetNodeCommunicationMode.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
            writer.WriteEndObject();
        }


        internal static BatchPoolReplaceContent DeserializeBatchPoolReplaceContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            BatchStartTask startTask = default;
            IList<BatchApplicationPackageReference> applicationPackageReferences = default;
            IList<MetadataItem> metadata = default;
            BatchNodeCommunicationMode? targetNodeCommunicationMode = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("startTask"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTask = BatchStartTask.DeserializeBatchStartTask(property.Value, options);
                    continue;
                }
                if (property.NameEquals("applicationPackageReferences"u8))
                {
                    List<BatchApplicationPackageReference> array = new List<BatchApplicationPackageReference>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BatchApplicationPackageReference.DeserializeBatchApplicationPackageReference(item, options));
                    }
                    applicationPackageReferences = array;
                    continue;
                }
                if (property.NameEquals("metadata"u8))
                {
                    List<MetadataItem> array = new List<MetadataItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetadataItem.DeserializeMetadataItem(item, options));
                    }
                    metadata = array;
                    continue;
                }
                if (property.NameEquals("targetNodeCommunicationMode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    targetNodeCommunicationMode = new BatchNodeCommunicationMode(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BatchPoolReplaceContent(startTask, applicationPackageReferences, metadata, targetNodeCommunicationMode, serializedAdditionalRawData);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static BatchPoolReplaceContent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeBatchPoolReplaceContent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
