// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Severity of the result (Critical, Warning, Informational, Hidden). This answers how important the result is. Critical is the only update-blocking severity. </summary>
    public readonly partial struct UpdateSeverity : IEquatable<UpdateSeverity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateSeverity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateSeverity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CriticalValue = "Critical";
        private const string WarningValue = "Warning";
        private const string InformationalValue = "Informational";
        private const string HiddenValue = "Hidden";

        /// <summary> Critical. </summary>
        public static UpdateSeverity Critical { get; } = new UpdateSeverity(CriticalValue);
        /// <summary> Warning. </summary>
        public static UpdateSeverity Warning { get; } = new UpdateSeverity(WarningValue);
        /// <summary> Informational. </summary>
        public static UpdateSeverity Informational { get; } = new UpdateSeverity(InformationalValue);
        /// <summary> Hidden. </summary>
        public static UpdateSeverity Hidden { get; } = new UpdateSeverity(HiddenValue);
        /// <summary> Determines if two <see cref="UpdateSeverity"/> values are the same. </summary>
        public static bool operator ==(UpdateSeverity left, UpdateSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateSeverity"/> values are not the same. </summary>
        public static bool operator !=(UpdateSeverity left, UpdateSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateSeverity"/>. </summary>
        public static implicit operator UpdateSeverity(string value) => new UpdateSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateSeverity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
